<?php
    /* Template Name: Home page */
    get_header();
?>





   
    <!-- flex slider -->

    <link href="<?php echo get_template_directory_uri(); ?>/css/flexslider.css" rel="stylesheet" type="text/css" media="screen">
    <script src="<?php echo get_template_directory_uri(); ?>/js/jquery.flexslider-min.js"></script>      
   

<style>
    
 

        .frontImage {
            background-size: cover;
            background-position: center center;
            height: 100vh;

            position: relative;
            z-index: 20;
        }

 
     

        /* Add existing styles here */
        .main-animation {
            position: relative;
            transition: transform 0.1s ease;
            overflow: hidden;
        }

        .read_more_button-home {
            background: transparent;
            border-radius: 10px;
            color: #fff;
            border: 2px solid #fff;
            padding: 5px 0px;
            width: 130px;
            font-size: 16px;
            font-weight: 600;
          
            text-align: center;
            cursor: pointer;
        }

       
        .read_more_button-home-1 {
            background: #0e395a;
            border-radius: 10px;
            color: #fff;
            border: 2px solid #0e395a;
            padding: 5px 0px;
            width: 130px;
            font-size: 16px;
            font-weight: 600;
  
            text-align: center;
            cursor: pointer;
        }

        .read_more_button-home-1:hover {
            background: transparent;
            color: #fff;
            border: 2px solid #fff;
        }
 
 

        .f-s-m-top {
            font-size: 55px;
    text-transform: uppercase;
    font-weight: 500;
    letter-spacing: 15px;
  
    }
        

     

            
    .f-s-m-middle {
   
    font-size: 180px;
    font-weight: 500;
    letter-spacing: 3px;
    }

    

        .f-slider-main {
            position: absolute;
            bottom: 0%;
            left: 0%;
            right: 0;
            top: 35%;
            text-align: left;
            font-size: 20px;
            font-weight: 700;
            color: #fff;
            z-index: 1;
            padding-left: 10%;
            margin-left: 250px;
        }

  
        
        .read_more_button{
            background: transparent;
            border-radius: 25px;
            color: #fff;
            border: 2px solid #fff;
            padding: 5px 0px;
            width: 150px;
            font-size: 16px;
            font-weight: 400;
            text-align: center;
            cursor: pointer;
            margin: 0 auto;
    }

    .read_more_button:hover{
        background: #fff;
        color: #333;
        transition:  background 0.6s;
    }

    
        .flexslider {
            max-height: 100vh;
            margin-bottom: 0px;
          
        }

        .flex-control-nav {
        
        width: 100%;
        position: absolute;
        text-align: center;
        top: 80%;       
        z-index: 8;
        height: 20px;
        display: none;
    }
        

    

        .flex-control-paging li a {
            width: 8px;
            height: 8px;
            display: block;
            background: #999;
            cursor: pointer;
            text-indent: -9999px;
            -webkit-box-shadow: inset 0 0 3px rgba(0, 0, 0, 0.3);
            -moz-box-shadow: inset 0 0 3px rgba(0, 0, 0, 0.3);
            -o-box-shadow: inset 0 0 3px rgba(0, 0, 0, 0.3);
            box-shadow: inset 0 0 3px rgba(0, 0, 0, 0.3);
            -webkit-border-radius: 20px;
            -moz-border-radius: 20px;
            border-radius: 20px;
            font-size: 0px;
        }

        .flex-control-paging li a:hover {
            background: #ddd;
        }

        .flex-control-paging li a.flex-active {
            background: #ddd;
            cursor: default;
            font-size: 0px;
            width: 12px;
            height: 12px;
            position: relative;
            top: -2px;
        }

      

        

        .flexslider-image-bg {
            background-size: cover;
            background-position: center center;
            height: 100vh;
        }

        
 
        .flexslider ul {
            list-style: none;
            margin: 0;
            padding: 0;
        }

        .arrows {
            position: absolute;
            top: 80%;
            width: 100%;
            grid-template-columns: 40px 40px;
            display: grid;
            justify-content: center;
            transform: translateY(-50%);
            z-index: 1;
            gap: 10px;
        }

        .left-arrow {
            background-size: 40px !important;
            background: url('<?php echo get_template_directory_uri(); ?>/images/Left-Arrow.png');
            width: 40px;
            height: 40px;
            cursor: pointer;
        }

        .right-arrow {
            background-size: 40px !important;
            background: url('<?php echo get_template_directory_uri(); ?>/images/Right-Arrow.png');
            width: 40px;
            height: 40px;
            cursor: pointer;
        }

     
        @keyframes zoomIn {
            from {
                transform: scale(1);
            }
            to {
                transform: scale(1.1);
            }
        }

        .flexslider .flex-active-slide .flexslider-image-bg {
            animation: zoomIn 9s ease-in-out;     
        }

        @keyframes slideUp {
            from {
                transform: translateY(50%);
            }
            to {
                transform: translateY(0);
            }
        }

        .content-header .content-text .content-text1 {
            animation: slideUp 2s ease-in-out;
        }

        @media screen and (max-width: 1300px) {
            .f-s-m-middle {
            font-size: 115px;
            
        }
        }


        @media screen and (max-width: 991px) {
            .flexslider{
                margin-left: 0px;
            }

            .f-slider-main{
                padding-left: 0;
                text-align: center;
                margin-left: 0px;
            }

            .f-s-m-top {
            font-size: 45px;       
        }

        .f-s-m-middle {
            font-size: 90px;
            
        }

        }

         
    

    @media screen and (max-width: 485px) {
        .f-s-m-middle {
            font-size: 50px;
        
        }

        .f-s-m-top {
            font-size: 28px;
            letter-spacing: 10px;
           
        }
            }
    
       

  
</style>

 
<div class="flexslider">
                
    <div class="f-slider-main">
        <div class="f-s-m-left"  data-aos="fade-up">
            <div class="f-s-m-top">Explore</div>
            <div class="f-s-m-middle">SRI LANKA</div>

        </div>
    </div>

    <div class="arrows">
        <div class="left-arrow"></div>
        <div class="right-arrow"></div>
    </div>

 


    <ul class="slides">
        <?php 
            $args = array( 'post_type' => 'sliders', 'posts_per_page' => 4, 'orderby' => 'menu_order' );
            $the_query = new WP_Query( $args ); 
            if ( $the_query->have_posts() ) {
                $z = 0;
                while ( $the_query->have_posts() ) { 
                    $the_query->the_post(); 
                    $slider_image = get_field('slider');
                    $picture = !empty($slider_image) ? $slider_image : get_template_directory_uri().'/images/banner2.jpg';

           
            


        ?>  
                <li class="slide">
                   
                    <div class="flexslider-image-bg animated-zoom" style="background-image:linear-gradient(rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0.5)),url(<?php echo $picture; ?>);">
                        <div class="frontImage" style="background-image:url(<?php echo $front_image; ?>);">
                        </div>
                    </div>
                    
                                                  

                </li>

                
        <?php  
                $z++;
                } 
                wp_reset_postdata(); 
            } else {  
        ?>
                <p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
        <?php 
            } 
        ?> 
    </ul>

    <div class="banner-image-icon">       
    </div>
 
    
</div>


<script>
    document.addEventListener('DOMContentLoaded', function () {
        let startTimestamp;
        let slideIndex = 0;
        let timeoutId;

        function smoothScroll(targetOffset) {
            const startPosition = window.pageYOffset;
            const targetPosition = startPosition + targetOffset;
            const distance = targetPosition - startPosition;
            const duration = 1000;

            function scrollAnimation(timestamp) {
                if (!startTimestamp) startTimestamp = timestamp;

                const elapsed = timestamp - startTimestamp;
                const progress = Math.min(elapsed / duration, 1);

                window.scrollTo(0, startPosition + distance * easeInOut(progress));

                if (elapsed < duration) {
                    requestAnimationFrame(scrollAnimation);
                } else {
                    startTimestamp = null;
                }
            }

            function easeInOut(t) {
                return t < 0.5 ? 2 * t * t : 1 - Math.pow(-2 * t + 2, 2) / 2;
            }

            requestAnimationFrame(scrollAnimation);
        }

        function showSlides() {
            let i;
            let slides = document.getElementsByClassName("slide");
            let dots = document.getElementsByClassName("dot");

            // Hide all slides
            for (i = 0; i < slides.length; i++) {
                slides[i].style.display = "none";
            }

            // Increment slideIndex
            slideIndex++;

            // Reset slideIndex if it exceeds the number of slides
            if (slideIndex > slides.length) {
                slideIndex = 1;
            }

            // Display the current slide
            slides[slideIndex - 1].style.display = "block";

            // Update dot styles
            for (i = 0; i < dots.length; i++) {
                dots[i].className = dots[i].className.replace(" active", "");
            }
            dots[slideIndex - 1].className += " active";

            // Clear existing timeout and set a new one for the next slide
            clearTimeout(timeoutId);
            timeoutId = setTimeout(showSlides, 5000); // Change image every 5 seconds
        }

        let sliders = document.getElementsByClassName("flexslider")[0];
        sliders.addEventListener('click', function () {
            startTimestamp = null;
        });

        let arrow = document.getElementById("arrow-down");
        arrow.addEventListener('click', function () {
            smoothScroll(200);
        });

        // Initial call to showSlides
        showSlides();
    });
</script>

 


<!-- home about us -->

<style>
    .about-btn{
        background: #83bc3f;
    border-radius: 50%;
    height: 95px;
    width: 95px;
    display: grid;
    align-items: center;
    font-size: 14px;
    border: 2px solid #83bc3f;
    color: #fff;
    }

    .about-btn:hover{
        background: transparent;
        color: #83bc3f;
        transition: all 0.4s ease-in;
       
    }

    .about-top {
        display: flex;
        justify-content: center;
        gap: 20px;
        align-items: center;
        padding-bottom: 40px;
    }

    .about-s-title{
        font-size: 45px;
        color: #fff;
    }

    .about-us-s-image{
        background:  url('<?php echo get_template_directory_uri(); ?>/images/adams peak3.jpg') 50% 50% no-repeat;	
        background-size: cover;
        background-position: center center;
    }

    .about-us-desc{
        position: relative;
        color: #fff;
        display: grid;
    align-items: center;
    padding: 70px 8%;
    text-align: center;
    }
    
    .about-us-area {
        background: #001527;
 
        display: grid;
        grid-template-columns: 250px 1fr;
        overflow: hidden;
    }

    .about-btn-home a{
        text-decoration: none;
    }
        
 

    @media screen and (max-width: 991px) {
        .about-us-area {
            grid-template-columns: 1fr;
        }

        .about-us-s-image{
            height: 300px;
        }
    }

    @media screen and (max-width: 525px) {
        .about-btn-home {
            margin: 0 auto;
        }

        .about-top {
    display: grid;

        }
    }
 
     
</style>



<div class="about-us-area">

    <div class="about-us-s-image" data-aos="zoom-in-right"></div>

    <div class="about-us-desc" data-aos="zoom-in-left">
        <div class="about-top">
            <div class="about-s-title"> ABOUT US </div>
           

            <div class="about-btn-home">
                <a href="<?php echo esc_url(home_url('/about_us')); ?>">                                         
                    <button class="about-btn"> More <br> About  </button>
                </a>
            </div>

        </div>



        <div class="about-white-content" data-aos="zoom-in">
        <strong>Your Gateway to Unforgettable Sri Lankan Vacations
        </strong>
        <br>
        <br>
        ﻿Ceylon Links Tours is devoted to creating unique revolutionary travel experiences in Sri Lanka's breathtaking surroundings. We offer carefully designed tours that exhibit the quality of Sri Lanka from vibrant flora and fauna and luxurious tea plantations to historic sites and immaculate beaches. Our expertise in the local lifestyle and attractions is extensive. We intend to design specific trips that match your hobbies and make your travels through this stunning island nation smooth and rewarding.
        </div>
    </div>


</div>



 
<!-- why book with us -->



<style>
    .why-book{
        padding: 50px 8%;
 
    }

    .why-book-title{
        color: #001527;
        font-size: 45px;
    font-weight: 400;
        padding-bottom: 15px;
        text-align: center;
        text-transform: uppercase;
    }

    .why-book-desc{
        color:#333;
        font-size:15px;
        text-align: center;
    }

    .why-icon img{
        width: 80px;
    }
 

    .why-book-icon{
        
        padding: 0px 16%;
    padding-top: 50px;
    display: flex;
    gap: 50px 5%;
    flex-wrap: wrap;
    justify-content: center;
    }


    @keyframes tilt-shaking {
    0% { transform: rotate(0deg); }
    25% { transform: rotate(5deg); }
    50% { transform: rotate(0deg); }
    75% { transform: rotate(-5deg); }
    100% { transform: rotate(0deg); }
    }


    .why-book-1:hover .why-icon img{
        animation: tilt-shaking 0.5s infinite; 
        width: 80px;
    }

    .why-icon{
        margin: 0 auto;
    }

    .why-icon-with-desc {
        display: grid;
    gap: 5px;
    border: 2px solid #001527;
    align-items: center;
    justify-content: center;
    padding: 35px 10px;
    border-radius: 20px;
    height: 225px;
    width: 250px;
    }



    .why-title {
        color: #001527;
        font-weight: 500;
        font-size: 17px;
        text-align: center;
    }


    .why-icon-and-title{
        display: grid;
        grid-template-columns: 70px 1fr;
        gap: 0px;

    }

    .why-title-g{
        color: #86b31f;
    border-bottom: 1px solid #333;
    display: grid;
    align-items: end;
    width: 70%;
    padding-bottom: 5px;
    }

    .green-i{
        display:none; 
    }

    .why-book-1:hover .blue-i{
        display:none;
    }

    .why-book-1:hover .green-i{
        display:block;
    }


    .why-book-1:hover .why-icon-with-desc {
        background: #001527;
        transition: 0.4s background ease-in;
    }

    .why-book-1:hover .why-title{
        color: #fff;
        transition: 0.4s color ease-in;
    }


    
    
</style>

<div class="why-book">
    <div class="why-book-title" data-aos="zoom-in">WHY BOOK WITH US?</div>
 
    <div class="why-book-desc" data-aos="zoom-in">
    
    </div>

    <div class="why-book-icon">
        <div class="why-book-1" data-aos="flip-up">
            <div class="why-icon-with-desc">
                <div class="why-icon">
                <img src="<?php echo get_template_directory_uri(); ?>/images/Exceptional-Journeys.png" alt="" width="100px" height="auto" class="blue-i">
                <img src="<?php echo get_template_directory_uri(); ?>/images/Exceptional-Journeys-W.png" alt="" width="100px" height="auto" class="green-i">
              
                </div>
                <div class="why-title">Exceptional <br> Journeys</div>
            </div>

             
             
        </div>

        <div class="why-book-1" data-aos="flip-down">
            <div class="why-icon-with-desc">
                <div class="why-icon">
                <img src="<?php echo get_template_directory_uri(); ?>/images/Handpicked-Excellence.png" alt="" width="100px" height="auto" class="blue-i">
                <img src="<?php echo get_template_directory_uri(); ?>/images/Handpicked-Excellence-W.png" alt="" width="100px" height="auto" class="green-i">
               
            </div>
                <div class="why-title">Handpicked <br> Excellence</div>
            </div>
           
        </div>

        <div class="why-book-1" data-aos="flip-up">
            <div class="why-icon-with-desc">
                <div class="why-icon">
                <img src="<?php echo get_template_directory_uri(); ?>/images/Personalised-Experiences.png" alt="" width="100px" height="auto" class="blue-i">
                <img src="<?php echo get_template_directory_uri(); ?>/images/Personalised-Experiences-W.png" alt="" width="100px" height="auto" class="green-i">
                
            </div>
                <div class="why-title">Personalised <br> Experiences</div>
            </div>
           
        </div>

   


    
        <div class="why-book-1" data-aos="flip-down">
            <div class="why-icon-with-desc">
                <div class="why-icon">
                <img src="<?php echo get_template_directory_uri(); ?>/images/Unbeatable-Value.png" alt="" width="100px" height="auto" class="blue-i">
                <img src="<?php echo get_template_directory_uri(); ?>/images/Unbeatable-Value-W.png" alt="" width="100px" height="auto" class="green-i">
               
            </div>
                <div class="why-title">	Unbeatable <br> Value</div>
            </div>
             
        </div>

        <div class="why-book-1" data-aos="flip-up">
            <div class="why-icon-with-desc">
                <div class="why-icon">
                <img src="<?php echo get_template_directory_uri(); ?>/images/Wide-Range-of-Choices.png" alt="" width="100px" height="auto" class="blue-i">
                <img src="<?php echo get_template_directory_uri(); ?>/images/Wide-Range-of-Choices-W.png" alt="" width="100px" height="auto" class="green-i">
               
            </div>
                <div class="why-title">	Wide Range <br> of Choices</div>
            </div>
          
        </div>

    </div>     
     
</div>




<!-- home-destinations -->

<style>
    .pack-tab {
        display: grid;
        grid-template-columns: 1fr 1fr;
        padding: 50px 8%;
    }

    .desti-main{
        background: #001527;
    }

    .desti-btn{
        background: #83bc3f;
    border-radius: 50%;
    height: 95px;
    width: 95px;
    display: grid;
    align-items: center;
    font-size: 14px;
    border: 2px solid #83bc3f;
    color: #fff;
    }

    .desti-btn:hover{
        background: transparent;
        color: #83bc3f;
        transition: all 0.4s ease-in;
       
    }

    .desti-top {
        display: flex;
        justify-content: center;
        gap: 20px;
        align-items: center;
        padding-top: 40px;
    }

    .desti-s-title{
        font-size: 45px;
        color: #83bc3f;
    }

    .desti-btn-home a{
        text-decoration: none;
    }

    .desti-s-desc {
        padding: 0px 8%;
        padding-top: 40px;
        color: #eee;
        text-align: center;
    }

    @media screen and (max-width: 525px) {
        .desti-top{
            display: grid;
        }

        .desti-btn-home{
            margin: 0 auto;
        }

        .desti-s-desc{
        display: none;
        }
    }
</style>

<style>
    .destin-col{ 
        position:relative; 
        background: #fff;
        display: grid;
        grid-template-columns: 1fr 1fr;
        background-position: center;
        background-size: cover;
        background-repeat: no-repeat;
         
        height: 300px;
    }


    .destin-col-2{ 
        position:relative; 
        background: #fff;
        display: grid;
        grid-template-columns: 1fr 1fr;
        background-position: center;
        background-size: cover;
        background-repeat: no-repeat;
         
        height: 300px;
    }

    .destin-col-3{ 
        position:relative; 
        background: #fff;
        display: none;
        grid-template-columns: 1fr 1fr;
        background-position: center;
        background-size: cover;
        background-repeat: no-repeat;
         
        height: 300px;
    }

     
    .destin-col-img-outer{
    overflow: hidden;
  
    }

    .destin-col-img{
        display: flex;
        justify-content: center;  
        align-items: center;     
        width: 100%;    
        background-size: cover;
        background-position: center;
        background-clip: content-box; 
        position: relative;
        padding: 0px;
        height: 300px;

        transform: scale(1.09);
    transition: transform 2s, visibility 2s ease-in;
    } 


    .destin-cover {
        color: #fff;
        display: grid;
        text-align: left;
        height: 300px;
        gap: 0;
        background: url() 50% 50% no-repeat;
        background-size: cover;
        align-items: center;
         
    }

    .destin-cover-back {
        position: absolute;
    height: 300px;
    background: #173557;
    width: 56%;
    right: 0%;
    clip-path: polygon(10% 42%, 10% 0, 100% 0, 100% 100%, 10% 100%, 10% 58%, 0% 50%);
   
    }


    .destin-cover-back-2 {
        position: absolute;
    height: 300px;
    background: #173557;
    width: 56%;
    right: 44%;
    clip-path: polygon(0% 0%, 90% 0%, 90% 42%, 100% 50%, 90% 58%, 90% 100%, 0% 100%);
    z-index: 99;
   
    }

    

    .destin-sm-name{
        font-size: 25px;
        font-weight: 400;
        text-align: center;
        padding: 15px;
        position: relative;
        z-index: 100;
    } 

    .destin-button{
            text-align: center;
        }


        .daytour-btn-2 img{
        width: 0px;
        position: relative;
        z-index: 99;
        left: -40%;
        cursor: pointer;
    }


    .destin-col:hover .daytour-btn-2 img{
        left: 0%;
        position: relative;
        width: 90px;
        transition: left 0.6s ease-in-out;
    }

    .destin-col-2:hover .daytour-btn-2 img{
        left: 0%;
        position: relative;
        width: 90px;
        transition: left 0.6s ease-in-out;
    }

    .destin-col-3:hover .daytour-btn-2 img{
        left: 0%;
        position: relative;
        width: 90px;
        transition: left 0.6s ease-in-out;
    }

    .destin-col:hover .destin-col-img{
        transform: scale(1);
    }

    .destin-col-2:hover .destin-col-img{
        transform: scale(1);
    }

    .destin-col-3:hover .destin-col-img{
        transform: scale(1);
    }


    .destin-col:hover .destin-cover-back{
        background: #83bc3f;
        transition:  background 0.5s ease-in;
    }

    .destin-col-2:hover .destin-cover-back{
        background: #83bc3f;
        transition:  background 0.5s ease-in;
    }

    .destin-col-3:hover .destin-cover-back{
        background: #83bc3f;
        transition:  background 0.5s ease-in;
    }

     

    @media screen and (max-width: 750px) {
        .pack-tab {
            grid-template-columns: 1fr;
        }
    }

    @media screen and (max-width: 750px) {
    .destin-col-2{
            display: none;
        }

        .destin-col-3{
            display: grid;
        }
    }


     
</style>
 

<div class="desti-main">

        <div class="desti-top">
            <div class="desti-s-title" data-aos="zoom-in"> DESTINATIONS </div>
           
             

            <div class="desti-btn-home" data-aos="zoom-in">
                <a href="<?php echo esc_url(home_url('/destination')); ?>">                                         
                    <button class="desti-btn"> All <br> Destinations  </button>
                </a>
            </div>

        </div>

        <div class="desti-s-desc" data-aos="zoom-in"> 
        Set out on an expedition through Sri Lanka’s diverse landscape and cultural treasures, with each stop promising an amazing experience. Sri Lanka’s ancient cities, exhilarating safaris, and beautiful beaches combine exploration, relaxation, and visual beauty.


Beach

 </div>

    <div id="tabContainer" class="pack-tab"> 
 
 
        <div class="destin-col" data-aos="zoom-in">    
                                
                            
                                <div class="destin-col-img-outer">
                                    <div class="destin-col-img" style="background-image:url('<?php echo get_template_directory_uri(); ?>/images/beach8.jpg');">
                                            <!-- <div class="daytour-btn-2">
                                            <div class="tabQ" onclick="openCityDD(event, 'tD11')">
                                                    <img src="<?php echo get_template_directory_uri(); ?>/images/more.png" class="orange-icon">
                                                    </div>  
                                            </div>   -->
                                    </div>  
                                </div> 




                                <div class="destin-cover" >
                                    <div class="destin-cover-back"></div>   
                            
                                
                                    <div class="pack-info">  
                                                
                                
                                            <div class="destin-sm-name">Beach</div> 

                                        
                                        </div>                                  
                                </div>

                                
                                                                                                                                                                                                                                                                                                                                        
        </div>
    

        
        <div class="destin-col-2" data-aos="zoom-in">    
                                
                            
                                <div class="destin-col-img-outer">
                                    <div class="destin-col-img" style="background-image:url('<?php echo get_template_directory_uri(); ?>/images/safari8.jpg');">
                                            
                                    </div>  
                                </div> 




                                <div class="destin-cover" >
                                    <div class="destin-cover-back"></div>   
                            
                                
                                    <div class="pack-info">  
                                                
                                
                                            <div class="destin-sm-name">Safari</div> 

                                        
                                        </div>                                  
                                </div>

                                
                                                                                                                                                                                                                                                                                                                                        
        </div>
        

        
        <div class="destin-col" data-aos="zoom-in">    
                                
                            
                                <div class="destin-cover" >
                                    <div class="destin-cover-back-2"></div>   
                            
                                
                                    <div class="pack-info">  
                                                
                                
                                            <div class="destin-sm-name">Culture</div> 

                                        
                                        </div>                                  
                                </div>
                            
                                <div class="destin-col-img-outer">
                                    <div class="destin-col-img" style="background-image:url('<?php echo get_template_directory_uri(); ?>/images/gangarama8.jpg');">
                                             
                                    </div>  
                                </div> 



                                
                                                                                                                                                                                                                                                                                                                                        
        </div>


        <div class="destin-col-3" data-aos="zoom-in">    
                                
                            
                                <div class="destin-col-img-outer">
                                    <div class="destin-col-img" style="background-image:url('<?php echo get_template_directory_uri(); ?>/images/safari8.jpg');">
                                            
                                    </div>  
                                </div> 




                                <div class="destin-cover" >
                                    <div class="destin-cover-back"></div>   
                            
                                
                                    <div class="pack-info">  
                                                
                                
                                            <div class="destin-sm-name">Safari</div> 

                                        
                                        </div>                                  
                                </div>

                                
                                                                                                                                                                                                                                                                                                                                        
        </div>
         

         
        <div class="destin-col-2" data-aos="zoom-in">    
                                
                            
                              

                                <div class="destin-cover" >
                                    <div class="destin-cover-back-2"></div>   
                            
                                
                                    <div class="pack-info">  
                                                
                                
                                            <div class="destin-sm-name">Eco</div> 

                                        
                                        </div>                                  
                                </div>


                                <div class="destin-col-img-outer">
                                    <div class="destin-col-img" style="background-image:url('<?php echo get_template_directory_uri(); ?>/images/eco8.jpg');">
                                           
                                    </div>  
                                </div> 

                                
                                                                                                                                                                                                                                                                                                                                        
        </div>

        <div class="destin-col-3" data-aos="zoom-in">    
                                
                            
                              

                                <div class="destin-cover" >
                                    <div class="destin-cover-back-2"></div>   
                            
                                
                                    <div class="pack-info">  
                                                
                                
                                            <div class="destin-sm-name">Eco</div> 

                                        
                                        </div>                                  
                                </div>


                                <div class="destin-col-img-outer">
                                    <div class="destin-col-img" style="background-image:url('<?php echo get_template_directory_uri(); ?>/images/eco8.jpg');">
                                              
                                    </div>  
                                </div> 

                                
                                                                                                                                                                                                                                                                                                                                        
        </div>
       

    </div>

</div>


<!-- home ACTIVITIES -->


<style>

    
    .container-acti {
        padding: 50px 8%;
        background: url('<?php echo get_template_directory_uri(); ?>/images/Backgropund-Activity.png');
        background-size: 100%;
        background-position: center center;
    }


    .acti-cover{
        background: #0015277a;
        position: absolute;
        width: 100%;
        height: 550px;
        top: 0;
        z-index: 9;
        opacity: 0;
    }

    .acti-col-img-main{
        overflow: hidden;
      
    }

    .acti-col-img-main:hover{
        box-shadow: 0px 0px 15px 0px #333;
        transition:  box-shadow 0.3s ease-in;
    }

    .acti-col-img{
        display: flex;
        justify-content: center; /* Horizontally aligns content to the center */
        align-items: center;     /* Vertically aligns content to the center */
        width: 100%;     
        background: url() 50% 50% no-repeat;
        background-size: cover;
        background-clip: content-box; 
        position: relative;
        padding: 0px;
        height: 550px;
        transform: scale(1.3);
        transition: transform 0.5s, visibility 0.5s ease-out;
 
    }


    .acti-col-img:hover {
        box-shadow: 5px 4px 10px 0px rgba(0,0,0,0.61);  
        transition: transform 0.3s, visibility 0.3s ease-in;
        transform: scale(1);
        z-index: 99;
    } 

    .acti-lg-name{
        font-size: 20px;
    font-weight: 600;
    padding: 7px 0px;
    color: #333;
    position: relative;
    z-index: 99;
    text-align: left;
 
        }


 
    .acti-main:hover .acti-cover{
        opacity: 1;
    }

    .acti-main:hover .acti-lg-name{
        color: #001527;
    }

   
    .content{
        font-size: 14px;
    font-weight: 500;
    color: #555;

    }

    .acti-button{
        position: relative;
        text-align: center;
        z-index: 99;
        padding-top:10px;
    }

    .acti-button img{
        max-width: 80px;
        text-align: center;
        margin: 0 auto;
    }

    .acti-col a{
        text-decoration:none;
    }

    .destina-btn-2 img{
        width: 90px;
        position: relative;
        z-index: 99;
        opacity: 0;
    }


    .acti-col-img-main:hover .destina-btn-2 img{
        opacity: 1;
        transition: opacity 0.5s ease-in;
    }




  

    
  

    

</style>


<style>
 
    .acti-slider .slick-slide{
        margin: 0px 10px;
    }
    

    .acti-btn{
        background: #83bc3f;
    border-radius: 50%;
    height: 95px;
    width: 95px;
    display: grid;
    align-items: center;
    font-size: 14px;
    border: 2px solid #83bc3f;
    color: #fff;
    }

    .acti-btn:hover{
        background: transparent;
        color: #83bc3f;
        transition: all 0.4s ease-in;
       
    }

    .acti-top {
        display: flex;
        justify-content: center;
        gap: 20px;
        align-items: center;
 
    }

    .acti-s-title{
        font-size: 45px;
        color: #001527;
    }

    .acti-btn-home a{
        text-decoration: none;
    }

    .acti-s-desc {
        padding: 40px 0%;
    color: #333;
    text-align: center;
    }

    .acti-arrows{
        grid-template-columns: 28px 28px;
        display: grid;
        gap: 30px;
        justify-content: center;
        padding: 10px 0px;
        padding-bottom: 0px;
    }

    .left-arrow-acti{                    
        background-size: 50px !important;
        background: url('<?php echo get_template_directory_uri(); ?>/images/Left-Arrow.png');
        width: 50px; 
        height: 50px;  
        cursor: pointer;                 
    }

    .right-arrow-acti{           
        background-size:50px !important;
        background: url('<?php echo get_template_directory_uri(); ?>/images/Right-Arrow.png');
        width: 50px;
        height: 50px;
        cursor: pointer;   
                  
    }

    
    @media screen and (max-width: 525px) {
        .acti-top{
            display: grid;
        }

        .acti-btn-home{
            margin: 0 auto;
            padding-bottom: 40px;
        }

        .acti-s-desc{
        display: none;
        }
    }
</style>


<section>

 


        <div class="container-acti">

            <div class="acti-top">
            <div class="acti-s-title" data-aos="zoom-in"> ACTIVITIES </div>           

            <div class="acti-btn-home" data-aos="zoom-in">
                <a href="<?php echo esc_url(home_url('/activities')); ?>">                                         
                    <button class="acti-btn"> All <br> Activities  </button>
                </a>
            </div>

        </div>

        
        <div class="acti-s-desc" data-aos="zoom-in"> 
        Sri Lanka provides a wide range of activities to suit the interests of all tourists. Savour regional cuisine on food tours, take in cultural events and explore historical sites. Explore rich marine lifestyles, take a stroll along picturesque paths or unwind on immaculate shorelines. Join local agencies, study new capabilities in craft seminars and loosen up with spa remedies and yoga retreats to revitalise yourself. Sri Lanka gives a rewarding travel experience whether or not you’re looking for adventure or peace.
        </div>


                        <div class="acti-full acti-slider">     
                            <?php 
                                $z = 1;
                                $args = array( 
                                    'post_type' => 'Activity',
                                    'posts_per_page' => 100,
                                 
                                 
                                 
                                  
                                );

                                $the_query = new WP_Query( $args ); 
                                if ( $the_query->have_posts() ) {
                                while ( $the_query->have_posts() ) { $the_query->the_post(); 

                                    $post_id = get_the_ID();

                                    $image = get_field('feature_image');
                                    $picture = $image['sizes']['large'];  
                                    $activit=  get_field('activity_no');                                  
                                    $content = get_the_content();
                                    $limited_content = wp_trim_words($content, 35, '...'); // Limit content to 35 words
                                        if(!empty($picture )){ 
                                        $picture = $picture;
                                        }else{ 
                                        $picture = get_template_directory_uri().'/images/img2.jpg';
                            } ?>
                            
                           
                                            <div class="acti-col" data-aos="zoom-in">
                                                     
                                                    <div class="acti-main"> 
                                                        <div class="acti-col-img-main">                        
                                                            <div class="acti-col-img" style="background-image:url(<?php echo $picture; ?>);">
                                                               
                                                            
                                                            <div class="acti-cover"></div>                                                                                                                                                            
                                                            </div>  
                                                        </div>

                                                        <div class="acti-info">                                         
                                                                <div class="acti-info-inner">    
                                                                    <div class="acti-lg-name"><?php the_title(); ?></div>                                                          
                                                                </div>
                                                        </div> 
                                                    </div>
                                                                                                                                                                                                                                                                                                           
                                            </div>

                                           
                                     
 
                            <?php  $z = ++$z; } wp_reset_postdata(); ?>
                            <?php }else{  ?>
                            <p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
                            <?php } ?>              
                        </div>
            
            
                        <div class="acti-arrows">
                    <div class="left-arrow-acti"></div>
                    <div class="right-arrow-acti"></div>
        </div>
            
        </div>    

  
</section>


<script>
    $(document).ready(function(){
            $('.acti-full').slick({
        slidesToShow: 4,
        slidesToScroll: 1,
        infinite: true,
        autoplay: true,
        autoplaySpeed: 2000,
        arrows: false,
        responsive: [
        {
          breakpoint: 1600,
          settings: {
            slidesToShow: 3
          }
        },
        {
          breakpoint: 1300,
          settings: {
            slidesToShow: 2
          }
        },
        {
          breakpoint: 560,
          settings: {
            slidesToShow: 1
          }
        }
      ],
        prevArrow: $(".left-arrow-acti"),
        nextArrow: $(".right-arrow-acti"),
               
    });

  });

  // Functionality for the left arrow button
  $('.left-arrow-acti').click(function() {
      $('.acti-full').slick('slickPrev');
    });

    // Functionality for the right arrow button
    $('.right-arrow-acti').click(function() {
      $('.acti-full').slick('slickNext');
    });

</script>



<!-- home packages -->



<style>
    .home-package{
        width: 100%;
        overflow: hidden;
        padding: 0;
    }


        .card { 
        width: 100%;
    min-height: 650px;
    background: #000;
    display: flex;
    /* gap: 2px; */
    padding: 0em;
    position: relative;
        } 

        .card .card-box { 
        
            flex: 1;
    overflow: hidden;
    cursor: pointer;
    border-radius: 2px;
    background: #fff;
    border: 0px solid #42032C;
    display: flex;
    justify-content: center;
    align-items: center;
    position: relative;
    transition: background 2s ease, all 0.9s;
    background-repeat: no-repeat;
    background-size: cover;
    background-position: center center;
        } 

        .card .card-box:hover { 
            flex: 4; 
            align-items: baseline;
        } 

        .card .card-box .content-cover { 
            min-width: 14em; 
            padding: 0em; 
            text-align: center; 
            transform: rotate(-90deg); 
            transition: all .5s; 
       
            color: #42032C; 
            letter-spacing: .1em; 
            z-index: 2;
        } 

        .card-box-bg{
            position: absolute;
            width: 100%;
            height: 100%;
            z-index: 1;
            background: #001527;
            opacity: 0.6;
        }

        .card-box:nth-child(odd) .card-box-bg {
            background: #83bc3f; /* Green for odd */
            opacity: 1;
        }

        .card-box:nth-child(even) .card-box-bg {
            background: #173557; /* Blue for even */   
             opacity: 1;
        }

        .content-button{
        opacity: 0;
        position: absolute;
        bottom: -45px;
        z-index: 99;
        width: 100%;
        text-align: center;
            }

    .content-heading{
            /* background: #0080b5; */
            padding: 0px;
    font-weight: 400;
    color: #fff;
    font-size: 22px;
    transition: transform 0.9s ease;
    letter-spacing: 0px;
    }

    .content-cover{
        position: relative;
    }


    .content-num {
        transform: rotate(90deg);
    position: absolute;
    left: -195px;
    /* top: -7px; */
    font-weight: 500;
    font-size: 40px;
    color: #fff;
    /* text-align: center; */
    height: 112%;
    display: grid;
    align-items: end;
    }

        .card .card-box:hover .content-heading { 

     transform: rotate(90deg);
     padding-top: 100px;
        } 


        .card .card-box:hover .content-days{
            transform: rotate(90deg);
    left: -275px;
    top: 50px;
        }

        .card .card-box:hover .content-num{
            position: absolute;
    top: -7px;
    left: 115px;
    padding-bottom: 30px;
        }

        .card .card-box:hover .content-button{ 
        opacity: 1;
        bottom: 10px;
            }


    .card .card-box:hover   .card-box-bg{
        opacity: 1;
        background: #00000069;
    }

    .content-button button{
        border: 0;
        background: #000;
        padding: 12px 20px;
        color: #fff;
    }

    .content-days {
        position: absolute;
    left: 295px;
    color: #fff;
    /* display: grid; */
    /* align-items: center; */
    /* height: 100%; */
    /* text-align: center; */
    top: 0px;
    font-size: 22px;
    }

 
    @media only screen and (max-width: 1000px) {
        .card{
            display: grid;

        }

        .content-days{
            display: none;
        }

        .content-num{
            display: none;
        }

        .content-heading{
            transform: rotate(90deg);
        }

        .card .card-box:hover .content-heading {
       
            transition: padding .4s ease-out;
        }

        .card .card-box:hover .content-days{
            transform: rotate(90deg);
    left: -4px;
    top: 11px;
    /* padding: 0px; */
    margin: 0px;
    padding-top: 0px;
    display: block;
        }

        .card .card-box:hover .content-heading{
            transform: rotate(90deg);
            padding-top: 25px;
        }

        .card .card-box:hover .content-num {
            display: block;
    position: absolute;
    top: -7px;
    left: 121px;
    padding-bottom: 45px;
    }

    .card .card-box:hover{
        padding: 60px 0px;
    }


    .card .card-box:hover .card-box-bg{
        top:0px;
    }
        }
        
</style>


<style>

    .packages-btn{
            background: #83bc3f;
        border-radius: 50%;
        height: 95px;
        width: 95px;
        display: grid;
        align-items: center;
        font-size: 14px;
        border: 2px solid #83bc3f;
        color: #fff;
    }

    .packages-btn:hover{
        background: transparent;
        color: #83bc3f;
        transition: all 0.4s ease-in;
       
    }
    
    .packages-top {
        display: flex;
        justify-content: center;
        gap: 20px;
        align-items: center;
 
    }

    .packages-s-title{
        font-size: 45px;
        color: #001527;
    }

    .packages-btn-home a{
        text-decoration: none;
    }

    .packages-s-desc {
        padding: 40px 0%;
    color: #333;
    text-align: center;
    }


 

   
    .home-package-h{
        text-align: center;
    padding: 50px 0px;
    }
 
 

    
    .home-package-title{
        font-size: 45px;
    color: #001527;
    font-weight: 500;
    text-transform: uppercase;
    }

    .home-package-desc {
        padding: 40px 8%;
    }

   

    @media screen and (max-width: 525px) {
        .packages-top{
            display: grid;

        }

        .packages-btn-home {
            margin: 0 auto;
        }


        .home-package-desc{
            display: none;
        }

       
    }
 
</style>


<div class="home-package-h">
        <div class="container-pack">

            <div class="packages-top">
                <div class="packages-s-title" data-aos="zoom-in"> PACKAGES </div>           

                <div class="packages-btn-home" data-aos="zoom-in">
                    <a href="<?php echo esc_url(home_url('/packages')); ?>">                                         
                        <button class="packages-btn"> All <br> Packages  </button>
                    </a>
                </div>

            </div>


            <div class="home-package-desc" data-aos="zoom-in">
            With Ceylon Links Tours set out on amazing travels across Sri Lanka. Our carefully chosen experiences combine cultural adventure and leisure from historic wonders to immaculate beaches and verdant forests. Find wildlife encounters, spiritual sanctuaries, and romantic getaways that suit your needs. Join us as we explore Sri Lanka and enjoy personalised excellence at every turn.
            </div>

        </div>
        </div> 

<div class="home-package">
    
    <div class="card"> 


                <?php 
                                    $z = 1;
                                    $args = array( 'post_type' => 'packages',
                                    'posts_per_page' => 100
                                    
                               
                                      );

                                    $the_query = new WP_Query( $args ); 
                                    if ( $the_query->have_posts() ) {
                                    while ( $the_query->have_posts() ) { $the_query->the_post(); 
                                        $post_id = get_the_ID();
                                        $image = get_field('feature_image');
                                        $picture = $image['sizes']['large'];    
                                        $day= get_field('day'); 
                                        $night= get_field('nights');  
                                        $packNum = get_field('package_number');                                 
                                        $content = get_the_content();
                                        $limited_content = wp_trim_words($content, 35, '...'); // Limit content to 35 words
                                            if(!empty($picture )){ 
                                            $picture = $picture;
                                            }else{ 
                                            $picture = get_template_directory_uri().'/images/img2.jpg';
                } ?>


        <div class="card-box" style="background-image:url(<?php echo $picture; ?>);" > 

            <div class="card-box-bg">
               
            </div>

            <div class="content-cover">
                <div class="">
                    <div class="content-num"><?php echo $packNum ; ?></div>   
                    <div class="content-heading"><?php the_title(); ?></div>    
                </div>  
                <div class="content-days"> <?php echo $night ; ?>/<?php echo $day ; ?></div>  
                       
            </div>  

          

        </div>


                                <?php  $z = ++$z; } wp_reset_postdata(); ?>
                                <?php }else{  ?>
                                <p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
                                <?php } ?>  


    </div> 

    </div> 



<!-- home day tours -->

<style>

    .dayt-btn{
            background: #83bc3f;
        border-radius: 50%;
        height: 95px;
        width: 95px;
        display: grid;
        align-items: center;
        font-size: 14px;
        border: 2px solid #83bc3f;
        color: #fff;
    }

    .dayt-btn:hover{
        background: transparent;
        color: #83bc3f;
        transition: all 0.4s ease-in;
       
    }
    
    .dayt-top {
        display: flex;
        justify-content: center;
        gap: 20px;
        align-items: center;
 
    }

    .dayt-s-title{
        font-size: 45px;
        color: #001527;
    }

    .dayt-btn-home a{
        text-decoration: none;
    }

    .dayt-s-desc {
        padding: 40px 8%;
    color: #333;
    text-align: center;
    }


 

   
    .home-dayt-h{
        text-align: center;
    padding: 50px 0px;
    padding-bottom: 0px;
    }
 
 

    
    .home-dayt-title{
        font-size: 45px;
    color: #001527;
    font-weight: 500;
    text-transform: uppercase;
    }

    .home-dayt-desc {
        padding: 40px 8%;
    }

    @media screen and (max-width: 525px) {
        .dayt-top{
            display: grid; 
        }

        .dayt-btn-home {
            margin: 0 auto;
        }

        .dayt-s-desc{
            display: none;
        }
    }

  
 
</style>


<div class="home-dayt-h">

        <div class="container-dayt">

            <div class="dayt-top">
                <div class="dayt-s-title" data-aos="zoom-in">EXCEPTIONAL <br> DAY ESCAPES!</div>           

                <div class="dayt-btn-home" data-aos="zoom-in">
                    <a href="<?php echo esc_url(home_url('/day-tours')); ?>">                                         
                        <button class="dayt-btn"> All <br> Packages  </button>
                    </a>
                </div>

               

            </div>

            <div class="dayt-s-desc" data-aos="zoom-in">
            Our carefully planned day tours will help you explore the beauty and culture of Sri Lanka. These tours give visitors a peek into the heart of the island and are ideal for adventurers, history buffs and nature lovers. Discover tranquil settings, a wealth of wildlife, historic cities and colonial forts. With the assistance of informed locals, take pleasure in wildlife safaris, peaceful boat rides and regional cuisine. Our day tours offer an easy way to experience the best of Sri Lanka complete with comfortable transportation, all-inclusive entry fees and reviving meals.
                </div> 

        </div>

</div>

 
<style>
    .daytour-full.slick-slider{
        height: 750px;
    }

     .dayt-arrows{
        grid-template-columns: 50px 50px;
    display: grid;
    gap: 10px;
    justify-content: center;
    top: -100px;
    position: relative;
    }

    .left-arrow-dayt{                    
        background-size: 50px !important;
        background: url('<?php echo get_template_directory_uri(); ?>/images/Left-Arrow.png');
        width: 50px; 
        height: 50px;  
        cursor: pointer;                 
    }

    .right-arrow-dayt{           
        background-size:50px !important;
        background: url('<?php echo get_template_directory_uri(); ?>/images/Right-Arrow.png');
        width: 50px;
        height: 50px;
        cursor: pointer;   
                  
    }

    .slider-daytour .slick-slide{
        margin: 0px 10px;
    }

    .daytour-desc{
        position: absolute;
        width: 100%;
    }

 
    .row1 {
        margin: 50px 8%;
       
    }

    /* .daytour-full {
    grid-template-columns: 300px 300px 300px;
    display: grid;
    gap: 35px;
    width: 100%;
    justify-content: center;
    }
     */

    .tabcontentD{
        margin-bottom:30px;
    }

   

    .daytour-col{ 
        position:relative; 
    
        background: #ddd; 
   

        overflow: hidden;
        z-index: 99;
     
    }

    .new-daytour-col{
        height:550px;
    }


    .daytour-cover{
        background: #00000054;
        position: absolute;
        width: 100%;
        height:550px;
        top: 0;
        z-index: 9;
    
       
    }

    .daytour-col-img {
        display: flex;
        justify-content: center;
        align-items: center;
        width: 100%;
        background: url() 50% 50% no-repeat;
        background-size: cover;
        background-clip: content-box;
        position: relative;
        padding: 0px;
        height: 550px;
      
        transform: scale(1.3);
        transition: transform .5s ease-out;
    }

    .daytour-col-img:hover{
        transform: scale(1);
        transition: transform .5s ease-in;
    }
    


        .daytour-info{    
        display: grid;
        align-items: baseline;
        width: 100%;
        position: relative;
        height: 550px;
    }

    .daytour-info-inner {
        position: relative;
   
    }  

    .daytour-lg-name{
        font-size: 22px;
    font-weight: 400;
    color: #fff;
    position: relative;
    z-index: 99;
    text-align: left;
    /* background: #041237ba; */
    height: 120px;
    width: 100%;
    text-transform: uppercase;
    display: grid;
    align-items: center;
    opacity: 1;
    padding: 0px 35px;
 
        }

        .daytour-content{
            font-size: 18px;
            font-weight: 300;
            color: #fff;
            position: relative;
            z-index: 99;
            text-align: center;
            padding:10px 20px;
        }


        .daytour-info-inner a{
        text-decoration: none;
    }

    .daytour-info-inner:hover a {
    text-decoration: none;
    }

    
        .daytour-col:hover{       
            box-shadow: 0 19px 38px rgba(0,0,0,0.30), 0 15px 12px rgba(0,0,0,0.22);
        transition: box-shadow 0.5s ease-in; 
        }

    .daytour-col:hover .daytour-col-img{
        
        transform: scale(1.07);
        transition: transform .5s ease-in;
    }


  
    .content{
        font-size: 16px;
        font-weight: 500;
    }

    .daytour-button{
        font-size: 20px;
    font-weight: 500;
    color: #fff;
    position: relative;
    z-index: 99;
    text-align: center;
        
    }

    .daytour-btn-2{
        display: none;
    }

  

    .daytour-button a{
        text-decoration: none;
    }

    .new-daytour-col.slick-slide.slick-active{
        position: relative !important;
        margin-top: 200px;
        transition: margin-top 0.9s ease-in;
    }

   
    .new-daytour-col.slick-slide.slick-active.slick-center{
        position: relative !important;
        margin-top: 0px;
         
    }
  

    @media screen and (max-width: 1300px) {
        .daytour-full.slick-slider{
        height: auto;
        }
    

    .new-daytour-col.slick-slide.slick-active{
        margin-top: 0px;
    }

    .dayt-arrows{
        padding-bottom: 50px;
        top: 0px;
    }
    }
  
    
</style>



<div class="row1">
                   

    <div class="daytour-full slider-daytour">
                        
                            
                            <?php 
                                      $z = 1;
                                      $args = array( 'post_type' => 'day_tour',
                                      'posts_per_page' => 100,                            
                                    );

                                    $the_query = new WP_Query( $args ); 
                                    if ( $the_query->have_posts() ) {
                                    while ( $the_query->have_posts() ) { $the_query->the_post(); 
                                        $post_id = get_the_ID();
                                        $image = get_field('feature_image');
                                        $picture = $image['sizes']['large'];                                    
                                        $content = get_the_content();
                                        $limited_content = wp_trim_words($content, 35, '...'); // Limit content to 35 words
                                            if(!empty($picture )){ 
                                            $picture = $picture;
                                            }else{ 
                                            $picture = get_template_directory_uri().'/images/img2.jpg';
                            } ?>


                                        <div class="new-daytour-col">
                                        
                                                <div class="daytour-col"> 
                                                    
                                                    <div class="daytour-desc" >
                                                                                                        
                                                                <div class="daytour-info">                                         
                                                                    <div class="daytour-info-inner">   
                                                                        
                                                                        <div class="daytour-lg-name"><?php the_title(); ?></div> 
                                                                        
        
                                                                    </div>
                                                                </div> 
                                                    </div> 

                                                    <div class="daytour-col-img" style="background-image:url(<?php echo $picture; ?>);">
                                                        <div class="daytour-cover"></div> 
                                                                                                            
                                                    </div> 
                                                                            
                                                </div>
                                         
 

                                        </div>  
    
                                <?php  $z = ++$z; } wp_reset_postdata(); ?>
                                <?php }else{  ?>
                                <p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
                                <?php } ?>  
                                                                        
                    </div>

          
    </div>

 

    <div class="dayt-arrows">
    <div class="left-arrow-dayt"></div>
    <div class="right-arrow-dayt"></div>
</div>


<script>
    $(document).ready(function(){
            $('.daytour-full').slick({
        slidesToShow: 3,
        slidesToScroll: 1,
        infinite: true,
        autoplay: true,
        autoplaySpeed: 2000,
        
        centerMode: true,
        centerPadding: '0%',
        arrows: false,
        responsive: [
        
        {
          breakpoint: 1300,
          settings: {
            slidesToShow: 2,
            centerMode: false
          }
        },
        {
          breakpoint: 560,
          settings: {
            slidesToShow: 1,
            centerMode: false
          }
        }
      ],
        prevArrow: $(".left-arrow-dayt"),
        nextArrow: $(".right-arrow-dayt"),
               
    });

  });

  // Functionality for the left arrow button
  $('.left-arrow-dayt').click(function() {
      $('.daytour-full').slick('slickPrev');
    });

    // Functionality for the right arrow button
    $('.right-arrow-dayt').click(function() {
      $('.daytour-full').slick('slickNext');
    });

</script>



 
 
<!-- home testimonials -->

<?php include get_theme_file_path( 'package-testimonial-2.php' ); ?>

<?php include get_theme_file_path( 'package-form.php' ); ?>
 


<!-- flex-slider -->


<script>
    $(document).ready(function () {
        var flexSlider = $('.flexslider').flexslider({
            animation: 'slide',
            slideshowSpeed: 9000,
            animationSpeed: 1000,
            controlNav: true,
            directionNav: false, // Disable default navigation
            prevText: '', 
            nextText: '' 
        });

        // Custom arrow functionality
        $('.left-arrow').click(function() {
            flexSlider.flexslider('prev');
        });

        $('.right-arrow').click(function() {
            flexSlider.flexslider('next');
        });
    });
</script>



 

<?php
get_footer();
?>