<?php

function custom_theme_assets() {
	wp_enqueue_style( 'style', get_stylesheet_uri() );
}

add_action( 'wp_enqueue_scripts', 'custom_theme_assets' );

register_nav_menus( [ 'primary-left' => __( 'Primary Menu Left' ) ] );
register_nav_menus( [ 'primary-right' => __( 'Primary Menu Right' ) ] );

register_nav_menus( [ 'primary' => __( 'Primary Menu' ) ] );

register_nav_menus( [ 'footer' => __( 'Footer Menu' ) ] );
register_nav_menus( [ 'mobile' => __( 'mobile Menu' ) ] );



// Enqueuing
function load_css()
{
    wp_register_style('bootstrap', get_template_directory_uri() . '/css/bootstrap.css', [], 1, 'all');
    wp_enqueue_style('bootstrap');

}
add_action('wp_enqueue_scripts', 'load_css');



/*Custom Post type start*/
function cw_post_type_packages() {
	$supports = array(
	'title', // post title
	'editor', // post content
	'author', // post author
	'thumbnail', // featured images
	'excerpt', // post excerpt
	'custom-fields', // custom fields
	'comments', // post comments
	'revisions', // post revisions
	'post-formats', // post formats
	);
	$labels = array(
	'name' => _x('packages', 'plural'),
	'singular_name' => _x('packages', 'singular'),
	'menu_name' => _x('packages', 'admin menu'),
	'name_admin_bar' => _x('packages', 'admin bar'),
	'add_new' => _x('Add New', 'add new'),
	'add_new_item' => __('Add New packages'),
	'new_item' => __('New packages'),
	'edit_item' => __('Edit packages'),
	'view_item' => __('View packages'),
	'all_items' => __('All packages'),
	'search_items' => __('Search packages'),
	'not_found' => __('No packages found.'),
	);
	$args = array(
	'supports' => $supports,
	'labels' => $labels,
	'public' => true,
	'query_var' => true,
	'rewrite' => array('slug' => 'packages'),
	'has_archive' => true,
	'hierarchical' => false,
	);
	register_post_type('packages', $args);
	}
	add_action('init', 'cw_post_type_packages');
/*Custom Post type end*/


/*Custom Post type start*/
function cw_post_type_destinations() {
	$supports = array(
	'title', // post title
	'editor', // post content
	'author', // post author
	'thumbnail', // featured images
	'excerpt', // post excerpt
	'custom-fields', // custom fields
	'comments', // post comments
	'revisions', // post revisions
	'post-formats', // post formats
	);
	$labels = array(
	'name' => _x('destinations', 'plural'),
	'singular_name' => _x('destinations', 'singular'),
	'menu_name' => _x('destinations', 'admin menu'),
	'name_admin_bar' => _x('destinations', 'admin bar'),
	'add_new' => _x('Add New', 'add new'),
	'add_new_item' => __('Add New destinations'),
	'new_item' => __('New destinations'),
	'edit_item' => __('Edit destinations'),
	'view_item' => __('View destinations'),
	'all_items' => __('All destinations'),
	'search_items' => __('Search destinations'),
	'not_found' => __('No destinations found.'),
	);

	$args = array(
	'supports' => $supports,
	'labels' => $labels,
	'public' => true,
	'query_var' => true,
	'rewrite' => array('slug' => 'destinations'),
	'has_archive' => true,
	'hierarchical' => false,
	);
	register_post_type('destinations', $args);
	}
	add_action('init', 'cw_post_type_destinations');
/*Custom Post type end*/


/*Custom Post type start*/
function cw_post_type_day_tour() {
	$supports = array(
	'title', // post title
	'editor', // post content
	'author', // post author
	'thumbnail', // featured images
	'excerpt', // post excerpt
	'custom-fields', // custom fields
	'comments', // post comments
	'revisions', // post revisions
	'post-formats', // post formats
	);
	$labels = array(
	'name' => _x('day_tour', 'plural'),
	'singular_name' => _x('day_tour', 'singular'),
	'menu_name' => _x('day_tour', 'admin menu'),
	'name_admin_bar' => _x('day_tour', 'admin bar'),
	'add_new' => _x('Add New', 'add new'),
	'add_new_item' => __('Add New day_tour'),
	'new_item' => __('New day_tour'),
	'edit_item' => __('Edit day_tour'),
	'view_item' => __('View day_tour'),
	'all_items' => __('All day_tour'),
	'search_items' => __('Search day_tour'),
	'not_found' => __('No day_tour found.'),
	);
	
	$args = array(
	'supports' => $supports,
	'labels' => $labels,
	'public' => true,
	'query_var' => true,
	'rewrite' => array('slug' => 'day_tour'),
	'has_archive' => true,
	'hierarchical' => false,
	);
	register_post_type('day_tour', $args);
	}
	add_action('init', 'cw_post_type_day_tour');
/*Custom Post type end*/


/*Custom Post type start*/
function cw_post_type_activity() {
	$supports = array(
	'title', // post title
	'editor', // post content
	'author', // post author
	'thumbnail', // featured images
	'excerpt', // post excerpt
	'custom-fields', // custom fields
	'comments', // post comments
	'revisions', // post revisions
	'post-formats', // post formats
	);
	$labels = array(
	'name' => _x('activity', 'plural'),
	'singular_name' => _x('activity', 'singular'),
	'menu_name' => _x('activity', 'admin menu'),
	'name_admin_bar' => _x('activity', 'admin bar'),
	'add_new' => _x('Add New', 'add new'),
	'add_new_item' => __('Add New activity'),
	'new_item' => __('New activity'),
	'edit_item' => __('Edit activity'),
	'view_item' => __('View activity'),
	'all_items' => __('All activity'),
	'search_items' => __('Search activity'),
	'not_found' => __('No activity found.'),
	);
	
	$args = array(
	'supports' => $supports,
	'labels' => $labels,
	'public' => true,
	'query_var' => true,
	'rewrite' => array('slug' => 'activity'),
	'has_archive' => true,
	'hierarchical' => false,
	);
	register_post_type('activity', $args);
	}
	add_action('init', 'cw_post_type_activity');
/*Custom Post type end*/



/*Custom Post type start*/
function cw_post_type_reviews() {
	$supports = array(
	'title', // post title
	'editor', // post content
	'author', // post author
	'thumbnail', // featured images
	'excerpt', // post excerpt
	'custom-fields', // custom fields
	'comments', // post comments
	'revisions', // post revisions
	'post-formats', // post formats
	);

	$labels = array(
	'name' => _x('reviews', 'plural'),
	'singular_name' => _x('reviews', 'singular'),
	'menu_name' => _x('reviews', 'admin menu'),
	'name_admin_bar' => _x('reviews', 'admin bar'),
	'add_new' => _x('Add New', 'add new'),
	'add_new_item' => __('Add New home'),
	'new_item' => __('New reviews'),
	'edit_item' => __('Edit reviews'),
	'view_item' => __('View reviews'),
	'all_items' => __('All activity'),
	'search_items' => __('Search reviews'),
	'not_found' => __('No reviews found.'),
	);
	
	$args = array(
	'supports' => $supports,
	'labels' => $labels,
	'public' => true,
	'query_var' => true,
	'rewrite' => array('slug' => 'reviews'),
	'has_archive' => true,
	'hierarchical' => false,
	);
	register_post_type('reviews', $args);
	}
	add_action('init', 'cw_post_type_reviews');
/*Custom Post type end*/


/*Custom Post type start*/
/* ========CPT Sliders========= */

function custom_post_type_sliders() {
	$supports = array(
		'title', // post title
		'editor', // post content
		'author', // post author
		'thumbnail', // featured images
		'excerpt', // post excerpt
		'custom-fields', // custom fields
		'comments', // post comments
		'revisions', // post revisions
		'post-formats', // post formats
	);
	$labels = array(
		'name' => _x('Sliders', 'plural'),
		'singular_name' => _x('Sliders', 'singular'),
		'menu_name' => _x('Sliders', 'admin menu'),
		'name_admin_bar' => _x('Sliders', 'admin bar'),
		'add_new' => _x('Add New Sliders', 'add new'),
		'add_new_item' => __('Add New Sliders'),
		'new_item' => __('New Sliders'),
		'edit_item' => __('Edit Sliders'),
		'view_item' => __('View Sliders'),
		'all_items' => __('All Sliders'),
		'search_items' => __('Search Sliders'),
		'not_found' => __('No Sliders found.'),
	);
	$args = array(
		'supports' => $supports,
		'labels' => $labels,
		'public' => true,
		'query_var' => true,
		'rewrite' => array('slug' => 'Sliders'),
		'has_archive' => true,
		'hierarchical' => false,
	);
	register_post_type('Sliders', $args);
	}
		add_action('init', 'custom_post_type_sliders');

/*Custom Post type end*/



/*Custom Post type start*/
function cw_post_type_blog() {
	$supports = array(
	'title', // post title
	'editor', // post content
	'author', // post author
	'thumbnail', // featured images
	'excerpt', // post excerpt
	'custom-fields', // custom fields
	'comments', // post comments
	'revisions', // post revisions
	'post-formats', // post formats
	);
	$labels = array(
	'name' => _x('blog', 'plural'),
	'singular_name' => _x('blog', 'singular'),
	'menu_name' => _x('blog', 'admin menu'),
	'name_admin_bar' => _x('blog', 'admin bar'),
	'add_new' => _x('Add New', 'add new'),
	'add_new_item' => __('Add New blog'),
	'new_item' => __('New blog'),
	'edit_item' => __('Edit blog'),
	'view_item' => __('View blog'),
	'all_items' => __('All blog'),
	'search_items' => __('Search blog'),
	'not_found' => __('No blog found.'),
	);
	
	$args = array(
	'supports' => $supports,
	'labels' => $labels,
	'public' => true,
	'query_var' => true,
	'rewrite' => array('slug' => 'blog'),
	'has_archive' => true,
	'hierarchical' => false,
	);
	register_post_type('blog', $args);
	}
	add_action('init', 'cw_post_type_blog');
/*Custom Post type end*/


add_filter('wpcf7_autop_or_not', '__return_false');

?>