<?php
/**
 * Template for displaying all single posts
 *
 * @package WordPress
 * @subpackage Twenty_Ten
 * @since Twenty Ten 1.0
 */
get_header(); 
include get_theme_file_path( 'header-widget.php' ); 

$highlights  = get_field( "highlights" );
$day_night_1  = get_field( "day_night_1" );
$day_night_2  = get_field( "day_night_2" );

$package_activity  = get_field( "package_activity" );
$package_interest  = get_field( "package_interest" );



?>
<style type="text/css">
	.package-single-home{
		display: grid;
		grid-template-columns: 1fr 400px;
		gap: 35px;		
	}


/**************/
.package--right{
 display: block;
 position: -webkit-sticky;
 position: sticky;
 max-height: calc(100vh - 200px);
 top: 20px;
 width: 100%;
}
.package--left{
	min-height: 990px;
}

.tour-highlights-title{
    font-size: 25px;
    font-weight: 600;
    margin-bottom: 18px;
}
.package--right--inner{
    background: #efefef;
    padding: 25px;
}


.package--right--inner ul{
list-style: none;
		padding: 0;
		display: grid;
		grid-template-columns: 1fr;
		gap: 8px;
}
.package--right--inner ul li{
position: relative;
padding-left: 25px;
}

.package--right--inner ul li::after{
			content: '';
			position: absolute;
			width: 10px;
			height: 10px;
			-border-radius:100%;
			-webkit-border-radius:100%;
			-moz-border-radius:100%;
			background: #BED630;			
			left: 0;
    		top: 8px;

}

.package--icons{
margin-top: 35px;
}

.package--icons ul{
display: grid;
grid-template-columns: 1fr 1fr;
gap: 15px;
}
li.package--icon--col{
    display: grid;
    grid-template-columns: 55px 1fr;
    gap: 25px;
    align-items: center;
}
.package--icon{

}
.package--icon svg{
    fill: #8d8d8d;
}
.package--title{
    text-transform: uppercase;
    font-size: 16px;
    font-weight: 600;
    color: #8d8d8d;
}

.package--title span{
    text-transform: capitalize;
    font-weight: 500;
    color: #000;
    font-size: 15px;
}

/********************************************************/
.package-day-details-row{
		display: grid;
		grid-template-columns: 1fr 200px 1fr;
		gap: 50px;
		align-items: start;
		overflow: hidden;
		padding-bottom: 150px;
	}
	.package-day-col{

	}
	.package-day-col-content{

	}
	.package-col-day{
	text-transform: uppercase;
    font-size: 16px;
    font-weight: 500;
    color: #8d8d8d;
    margin-bottom: 6px;
	}
	.package-col-day-title{
font-size: 25px;
    font-weight: 600;
    line-height: 1.2;
    margin-bottom: 15px;
	}
	.package-col-day-text{

	}
	.package-day-col-img{

	}
	.package-day-col-img img{
		width: 100%;
		object-fit: cover;
	}
	.package-day-path.odd{
		position: relative;
	}
	.package-day-path.odd::after{
		content: '';
		position: absolute;
		background: url(<?php echo get_template_directory_uri(); ?>/images/path.png);
background-size: 100%;
    background-repeat: no-repeat;
    background-position: center top;
    width: 100px;
    min-height: 500px;
    top: 0;

	}

.package-day-path.even{
		position: relative;
	}
	.package-day-path.even::after{
		content: '';
		position: absolute;
		background: url(<?php echo get_template_directory_uri(); ?>/images/path2.png);
background-size: 100%;
    background-repeat: no-repeat;
    background-position: center top;
    width: 100px;
    min-height: 500px;
    top: 0;
    right: 34px;

	}

/********************************************************/
@media screen and (max-width: 1100px){


}

@media screen and (max-width: 1000px){


}

@media screen and (max-width: 950px){


}

@media screen and (max-width: 850px){
.package-single-home {
    display: grid;
    grid-template-columns: 1fr;
    gap: 35px;
}
.package--left {
    min-height: 100%;
}
.package-day-col-img img {
    width: 100%;
    object-fit: cover;
    height: 230px;
}

.package--right {
    display: block;
    position: unset;
    position: relative;
    max-height: 100%;
    top: 0;
    width: 100%;
}

}

@media screen and (max-width: 767px){
.package-day-details-row {
    display: grid;
    grid-template-columns: 1fr;
    gap: 20px;
    align-items: start;
    overflow: hidden;
    padding-bottom: 50px;
}
    .package-day-details-row.even {
        display: flex;
        flex-wrap: wrap;
        width: 100%;
        flex-direction: column-reverse;
    }
.package-day-details-row.odd{
        display: flex;
        flex-wrap: wrap;
        width: 100%;
        flex-direction: column;

}
.package-day-col {
    width: 100%;
}

.package-day-path.odd {
    position: relative;
    display: none;
}

.package-day-path.even {
    position: relative;
    display: none;
}


.package-day-col-img img {
    width: 100%;
    object-fit: cover;
    height: 350px;
}

}

@media screen and (max-width: 650px){


}

@media screen and (max-width: 550px){
.package--icons ul {
    grid-template-columns: 1fr;
}

}

</style>
<section>
	<div class="container">
		<div class="row">
			<div class="col-sm-12">
				<div class="package-single-home">
					<div class="package--left" >

						<div class="package--content">
							<?php the_content(); ?>
						</div>
						<div class="package--icons">
							<ul>
								<li class="package--icon--col">
									<div class="package--icon">
											<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 100 100" style="enable-background:new 0 0 100 100;" xml:space="preserve">
<g>
	<path  d="M50.94,0c1.83,0.73,2.59,2.12,2.58,4.05c-0.03,2.96,0.03,5.91-0.02,8.87c-0.05,2.91-2.83,4.59-5.26,3.23
		c-1.18-0.66-1.78-1.73-1.8-3.04c-0.05-3.22-0.06-6.43,0-9.65c0.03-1.7,0.98-2.84,2.55-3.46C49.64,0,50.29,0,50.94,0z"/>
	<path class="st7" d="M0,48.99c0.73-1.84,2.12-2.6,4.05-2.58c2.96,0.03,5.91-0.03,8.87,0.02c2.74,0.05,4.43,2.51,3.4,4.91
		c-0.6,1.4-1.74,2.12-3.21,2.15c-3.21,0.06-6.43,0.06-9.65,0c-1.7-0.03-2.85-0.97-3.46-2.55C0,50.29,0,49.64,0,48.99z"/>
	<path  d="M76.58,50.03C76.56,64.74,64.63,76.61,49.9,76.58c-14.71-0.03-26.57-11.94-26.55-26.68
		C23.38,35.2,35.3,23.33,50.03,23.36C64.74,23.38,76.61,35.31,76.58,50.03z M49.95,30.33c-11.08,0.22-19.62,8.8-19.58,19.68
		c0.05,11.19,8.84,19.6,19.65,19.55c11.06-0.05,19.53-8.74,19.53-19.58C69.57,39.01,60.93,30.52,49.95,30.33z"/>
	<path class="st7" d="M91.65,53.52c-1.49,0-2.99,0.02-4.48,0c-2.26-0.03-3.86-1.5-3.86-3.54c-0.01-2.03,1.59-3.53,3.85-3.55
		c3.02-0.02,6.04-0.03,9.06,0c2.27,0.02,3.8,1.5,3.78,3.58c-0.02,2.02-1.54,3.46-3.77,3.5C94.71,53.54,93.18,53.52,91.65,53.52z"/>
	<path  d="M46.42,91.6c0-1.49-0.02-2.99,0-4.48c0.03-2.2,1.5-3.77,3.49-3.8c2.02-0.03,3.57,1.58,3.59,3.81
		c0.03,3.02,0.03,6.04,0,9.06c-0.02,2.28-1.48,3.82-3.54,3.82c-2.06,0-3.51-1.55-3.54-3.83C46.4,94.65,46.42,93.12,46.42,91.6z"/>
	<path  d="M13.56,17.46c0.04-1.85,0.66-2.95,1.96-3.54c1.44-0.66,2.83-0.44,3.98,0.64c1.38,1.29,2.68,2.65,4.02,3.98
		c0.9,0.9,1.81,1.78,2.68,2.7c1.53,1.62,1.59,3.73,0.18,5.15c-1.41,1.42-3.55,1.38-5.14-0.17c-2.19-2.13-4.34-4.31-6.49-6.48
		C14.02,18.99,13.52,18.13,13.56,17.46z"/>
	<path  d="M82.88,13.58c1.35,0.01,2.41,0.57,3.05,1.75c0.65,1.2,0.62,2.44-0.12,3.61c-0.19,0.3-0.42,0.58-0.67,0.83
		c-2.13,2.14-4.25,4.3-6.42,6.41c-1.95,1.89-4.68,1.52-5.82-0.74c-0.68-1.34-0.46-2.8,0.68-4.05c0.79-0.87,1.64-1.67,2.47-2.5
		c1.38-1.38,2.75-2.76,4.14-4.13C81.05,13.91,81.85,13.58,82.88,13.58z"/>
	<path d="M17.6,86.38c-2.01-0.04-3.13-0.68-3.72-2.03c-0.63-1.45-0.37-2.82,0.72-3.97c1.19-1.25,2.43-2.45,3.65-3.67
		c0.97-0.97,1.92-1.94,2.9-2.89c1.66-1.6,3.77-1.7,5.22-0.27c1.45,1.43,1.39,3.58-0.21,5.21c-2.09,2.14-4.22,4.24-6.34,6.35
		C19.05,85.86,18.19,86.4,17.6,86.38z"/>
	<path  d="M86.38,82.41c-0.06,1.97-0.71,3.08-2.07,3.66c-1.45,0.62-2.82,0.35-3.96-0.75c-1.43-1.37-2.81-2.8-4.22-4.2
		c-0.83-0.83-1.68-1.64-2.47-2.49c-1.47-1.58-1.5-3.68-0.1-5.07c1.4-1.39,3.52-1.39,5.07,0.11c2.24,2.17,4.43,4.4,6.62,6.62
		C85.96,81,86.41,81.86,86.38,82.41z"/>
</g>
</svg>

									</div>
									<div class="package--title--cover">
									<div class="package--title">Days</div>
									<div class="package--title"><span><?php echo $day_night_1; ?> Days</span></div>
									</div>
								</li>
								<li class="package--icon--col">
									<div class="package--icon">
										<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 99.99 100" style="enable-background:new 0 0 99.99 100;" xml:space="preserve">

<g>
	<path  d="M0,45.94c0.37-2.8,0.77-5.59,1.47-8.34C6.26,18.93,22.13,4.18,41.08,0.79c2.98-0.53,5.98-0.85,9.02-0.79
		c1.65,0.03,2.83,0.81,3.21,2.17c0.4,1.4-0.12,2.65-1.53,3.57c-6.16,4.03-10.68,9.43-13.6,16.19c-5.89,13.65-2.02,30.14,9.28,39.79
		c5.18,4.42,11.07,7.29,17.8,8.27c9.75,1.42,18.65-0.79,26.57-6.74c0.81-0.61,1.59-1.24,2.69-1.23c2.17,0.03,3.52,2.03,2.77,4.21
		c-1.92,5.63-4.75,10.76-8.52,15.35C81.2,90.8,71.6,96.68,59.92,99.12c-1.87,0.39-3.78,0.59-5.67,0.88c-2.73,0-5.46,0-8.2,0
		c-1.67-0.24-3.35-0.43-5-0.73c-19.1-3.49-34.78-18.1-39.61-36.89C0.75,59.66,0.37,56.9,0,54.14C0,51.41,0,48.67,0,45.94z
		 M40.54,7.23C25.24,10.04,6.41,25.03,5.97,49.49C5.6,69.91,19.93,88.95,41.76,93.22c20.37,3.98,38.15-7.05,45.36-19.97
		c-18.45,6.57-34.71,3.34-48.07-11.52c-5.78-6.42-8.84-14.22-9.52-22.83C28.57,26.83,32.42,16.34,40.54,7.23z"/>
	<path  d="M82.42,20.59c-0.01,1.63-1.15,2.86-2.87,2.97c-3,0.19-5.43,1.39-7.2,3.87c-1.07,1.51-1.48,3.22-1.63,5.03
		c-0.16,1.88-1.32,3.02-3.04,3.01c-1.66-0.01-2.83-1.15-2.96-2.98c-0.3-4.09-2.23-6.98-6.12-8.45c-0.89-0.34-1.84-0.37-2.78-0.47
		c-1.68-0.17-2.82-1.4-2.8-3.04c0.02-1.59,1.16-2.85,2.79-2.94c3.4-0.18,6.05-1.57,7.79-4.56c0.76-1.3,0.98-2.74,1.12-4.2
		c0.16-1.81,1.32-2.95,2.98-2.96c1.68-0.01,2.86,1.14,3.02,2.93c0.39,4.46,2.8,7.54,6.66,8.46c0.75,0.18,1.54,0.23,2.31,0.32
		C81.3,17.75,82.43,18.99,82.42,20.59z M67.68,23.22c0.13-0.07,0.26-0.11,0.34-0.2c0.66-0.76,1.36-1.48,2.12-2.13
		c0.26-0.22,0.19-0.45-0.06-0.65c-0.73-0.59-1.4-1.25-1.99-1.99c-0.28-0.35-0.5-0.32-0.77,0.02c-0.57,0.71-1.21,1.35-1.92,1.92
		c-0.33,0.27-0.37,0.51-0.03,0.78c0.72,0.56,1.32,1.24,1.92,1.93C67.39,23.02,67.54,23.11,67.68,23.22z"/>
	<path  d="M91.16,5.87c1.67,0.01,2.96,1.29,2.97,2.96c0.01,1.72-1.3,3.03-3.01,3.02c-1.71-0.01-3-1.34-2.97-3.06
		C88.17,7.13,89.48,5.86,91.16,5.87z"/>
	<path  d="M96.98,29.48c1.72-0.01,3.02,1.31,3.01,3.02c-0.01,1.67-1.3,2.95-2.97,2.96c-1.71,0.01-3.02-1.31-3.01-3.02
		C94.01,30.78,95.31,29.49,96.98,29.48z"/>
</g>
</svg>

									</div>
									<div class="package--title--cover">
									<div class="package--title">Nights</div>
									<div class="package--title"><span><?php echo $day_night_2; ?> Nights</span></div>
									</div>
								</li>
								<li class="package--icon--col">
									<div class="package--icon">
										<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 85.11 100" style="enable-background:new 0 0 85.11 100;" xml:space="preserve">

<g>
	<path  d="M47.59,0c1.59,1.41,2.16,4.08,1.3,6.04c-0.49,1.13-1.65,1.87-2.87,1.83c-1.25-0.04-2.42-0.87-2.76-2.1
		c-0.36-1.3-0.33-2.63-0.01-3.95c0.19-0.81,0.81-1.31,1.4-1.82C45.64,0,46.61,0,47.59,0z"/>
	<path class="st7" d="M48.24,99.96c-5.86,0-11.73,0-17.59,0c-2.25,0-3.42-1.17-3.43-3.43c-0.01-2.9-0.03-5.8,0-8.7
		c0.01-0.7-0.12-0.98-0.93-0.85c-1.89,0.31-3.81,0.47-5.71,0.73c-3.91,0.54-7.96-2.69-8.21-6.62c-0.29-4.71-0.54-9.42-0.8-14.13
		c-0.07-1.33-0.12-1.4-1.5-1.4c-1.43,0-2.87,0.01-4.3,0c-4.51-0.04-7.17-4.56-4.98-8.52c1.61-2.91,3.29-5.77,4.94-8.66
		c1-1.75,2.03-3.49,3-5.26c0.74-1.34,1.82-1.94,3.34-1.93c4.5,0.03,8.99,0.01,13.49,0c0.3,0,0.73,0.17,0.89-0.18
		c0.13-0.27-0.2-0.52-0.36-0.76c-2.04-3.08-3.55-6.37-3.85-10.11c-0.56-6.99,3.69-15.29,11.76-16.57c4.33-0.69,8.02,0.74,11.08,3.85
		c0.89,0.9,0.89,0.9,1.74,0.04c6.28-6.41,16.21-5.02,20.68,2.94c2.84,5.06,2.98,10.28,0.67,15.58c-0.67,1.53-1.49,2.97-2.4,4.36
		c-0.14,0.21-0.43,0.42-0.33,0.67c0.14,0.34,0.52,0.19,0.79,0.19c4.69,0.01,9.38,0.01,14.07,0.01c2.67,0,3.83,1.15,3.7,3.84
		c-0.35,7.21-1.72,14.15-5.46,20.45c-2.09,3.52-4.78,6.5-8.16,8.83c-0.76,0.53-1.02,1.11-1.01,2.02c0.04,6.58-0.05,13.16,0.05,19.74
		c0.04,2.71-1.39,3.97-3.87,3.92C59.77,99.89,54,99.96,48.24,99.96z M48.31,93.96c4.63,0,9.25-0.03,13.87,0.02
		c0.96,0.01,1.2-0.3,1.2-1.22c-0.04-6.22,0.02-12.44-0.05-18.66c-0.02-1.77,0.61-2.94,2.14-3.82c2.37-1.36,4.37-3.17,6.06-5.32
		c3.84-4.88,5.39-10.61,6.12-16.64c0.11-0.92-0.4-1-1.11-1c-5.24,0.01-10.49,0.02-15.73,0c-0.67,0-1.16,0.22-1.64,0.68
		c-3.42,3.27-7.13,6.19-11.07,8.81c-1.46,0.97-2.8,0.95-4.25-0.01c-3.98-2.63-7.71-5.56-11.17-8.85c-0.42-0.4-0.86-0.63-1.46-0.63
		c-5.67,0.02-11.33,0.02-17,0c-0.64,0-1.01,0.23-1.32,0.77c-2,3.54-4.02,7.08-6.06,10.6c-0.38,0.65-0.34,0.88,0.49,0.87
		c2.44-0.03,4.89-0.03,7.33,0c1.77,0.03,2.97,1.32,2.93,3.1c-0.01,0.65-0.08,1.3-0.04,1.95c0.25,4.71,0.55,9.42,0.77,14.13
		c0.14,2.91,0.22,3.03,3.13,2.73c5.25-0.54,10.43-1.44,15.54-2.79c2.29-0.61,3.94-1.89,4.97-4.03c1.21-2.52,2.48-5.02,3.75-7.52
		c0.91-1.79,2.63-2.43,4.23-1.63c1.57,0.79,2.07,2.58,1.19,4.37c-1.3,2.63-2.6,5.26-3.93,7.87c-1.81,3.54-4.67,5.79-8.51,6.77
		c-1.58,0.4-3.16,0.79-4.75,1.14c-0.56,0.13-0.75,0.42-0.7,0.96c0.18,2.05,0.1,4.1,0.09,6.15c-0.01,0.93,0.28,1.23,1.23,1.22
		C39.12,93.94,43.72,93.96,48.31,93.96z M63.62,28.12c0.04-1.64-0.64-3.75-2.01-5.62c-2.85-3.88-7.77-4.02-10.86-0.34
		c-0.85,1.01-1.41,2.17-1.85,3.42c-0.52,1.47-1.59,2.25-2.98,2.24c-1.32-0.01-2.39-0.82-2.89-2.23c-0.29-0.8-0.62-1.58-1.05-2.31
		c-2.82-4.77-8.56-5.07-11.75-0.6c-1.2,1.69-1.81,3.6-1.94,5.66c-0.18,2.97,0.93,5.57,2.49,7.98c3.79,5.84,9.05,10.2,14.63,14.21
		c0.47,0.34,0.84,0.19,1.23-0.11c1.19-0.9,2.42-1.77,3.59-2.7c3.72-2.98,7.23-6.19,10-10.11C62.1,34.96,63.64,32.18,63.62,28.12z"/>
	<path class="st7" d="M24.21,13.36c-0.01,1.48-0.6,2.4-1.74,2.92c-1.13,0.52-2.24,0.39-3.19-0.44c-0.78-0.69-1.52-1.43-2.21-2.2
		c-1.02-1.14-1.01-2.76-0.03-3.92c0.92-1.1,2.55-1.43,3.79-0.64c1.18,0.75,2.12,1.8,2.96,2.93C24.14,12.45,24.23,13.01,24.21,13.36z
		"/>
	<path  d="M76.2,11.68c0,0.1,0.01,0.2,0,0.29c-0.12,1.71-3.08,4.58-4.78,4.58c-1.23,0-2.19-0.53-2.75-1.68
		c-0.56-1.13-0.47-2.24,0.34-3.19c0.71-0.84,1.5-1.63,2.34-2.35c0.98-0.85,2.13-0.92,3.28-0.35C75.7,9.53,76.21,10.47,76.2,11.68z"
		/>
	<path  d="M80.9,29.48c0.71,0.01,1.42-0.08,2.12,0.16c1.28,0.45,2.16,1.7,2.08,2.98c-0.07,1.34-1.01,2.49-2.33,2.79
		c-1.18,0.27-2.39,0.27-3.58,0.03c-1.49-0.3-2.56-1.66-2.46-3.07c0.1-1.52,1.26-2.74,2.8-2.89C79.99,29.44,80.45,29.48,80.9,29.48z"
		/>
	<path  d="M11.35,29.48c0.65,0.02,1.3-0.08,1.94,0.12c1.35,0.43,2.28,1.65,2.23,2.99c-0.05,1.37-1.03,2.55-2.41,2.84
		c-1.16,0.25-2.33,0.25-3.49,0.01c-1.55-0.33-2.47-1.61-2.36-3.23c0.09-1.43,1.23-2.58,2.73-2.73
		C10.44,29.44,10.89,29.48,11.35,29.48z"/>
</g>
</svg>
									</div>
									<div class="package--title--cover">
									<div class="package--title">Activity</div>
									<div class="package--title"><span><?php echo $package_activity; ?></span></div>
									</div>
								</li>
								<li class="package--icon--col">
									<div class="package--icon">
										<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 98.6 100" style="enable-background:new 0 0 98.6 100;" xml:space="preserve">

<g>
	<path  d="M51.25,0c3.01,0.77,5.48,2.3,7.16,5c4.08,6.54-0.14,15.21-7.79,16.18c-5.32,0.68-11.81-3.11-12.03-10.54
		C38.45,6,41.7,1.73,46.24,0.35c0.37-0.11,0.74-0.23,1.11-0.35C48.65,0,49.95,0,51.25,0z M49.31,17.12c3.63,0,6.57-2.95,6.57-6.58
		c-0.01-3.54-2.96-6.5-6.54-6.55c-3.55-0.05-6.62,2.99-6.62,6.57C42.72,14.18,45.68,17.13,49.31,17.12z"/>
	<path class="st7" d="M35.1,100c-2.57,0-5.14,0.01-7.71,0c-1.58-0.01-2.25-0.6-2.42-2.17c-0.06-0.55-0.09-1.11-0.05-1.66
		c0.29-3.43-1.49-5.72-4.11-7.57c-1.32-0.93-2.81-1.48-4.29-2.07c-2.73-1.09-5.02-2.71-6.53-5.31c-0.57-0.99-1-2.04-1.36-3.12
		C5.91,69.85,3.2,61.61,0.48,53.37c-0.92-2.78-0.57-5.3,1.6-7.35c2.63-2.5,6.71-2.21,9.14,0.56c0.6,0.69,1.07,1.47,1.48,2.29
		c3.19,6.36,6.4,12.72,9.59,19.09c0.4,0.79,0.84,1.55,1.55,2.1c0.72,0.56,1.52,0.82,2.34,0.27c0.86-0.57,0.69-1.38,0.37-2.18
		c-0.66-1.63-1.34-3.24-1.97-4.88c-1.3-3.41,0.28-7.11,3.59-8.51c3.25-1.36,7.05,0.07,8.53,3.35c0.94,2.07,1.67,4.23,2.5,6.35
		c2.12,5.39,4.04,10.84,4.99,16.59c0.66,4.02,1.01,8.06,1.08,12.12c0.02,1.4,0.07,2.79,0.11,4.19c0.06,1.77-0.77,2.65-2.56,2.65
		C40.24,100,37.67,100,35.1,100z M35.14,95.96c1.76,0,3.51-0.02,5.27,0.01c0.65,0.01,0.85-0.24,0.81-0.87
		c-0.09-1.26-0.11-2.53-0.17-3.8c-0.18-4.29-0.62-8.55-1.56-12.74c-1.45-6.44-4.12-12.45-6.46-18.58c-0.54-1.4-2.03-1.96-3.3-1.42
		c-1.27,0.54-1.81,1.93-1.26,3.37c0.63,1.64,1.31,3.25,1.96,4.89c0.36,0.91,0.61,1.86,0.47,2.85c-0.61,4.47-5.39,6.53-9.17,3.97
		c-1.45-0.98-2.4-2.35-3.17-3.88c-3.14-6.28-6.29-12.55-9.44-18.83c-0.35-0.7-0.71-1.39-1.33-1.9c-1.31-1.06-2.95-0.58-3.55,1
		c-0.33,0.89,0.04,1.67,0.3,2.46c2.58,7.87,5.26,15.72,7.74,23.62c1.03,3.3,2.87,5.61,6.14,6.77c1.23,0.43,2.43,0.95,3.54,1.62
		c4.1,2.45,6.96,5.74,7.1,10.79c0.02,0.67,0.42,0.69,0.91,0.69C31.69,95.95,33.42,95.96,35.14,95.96z"/>
	<path  d="M63.42,100c-2.6,0-5.2,0.01-7.81,0c-1.55-0.01-2.4-0.77-2.37-2.33c0.11-7.09,0.35-14.16,2.09-21.09
		c1.33-5.32,3.43-10.36,5.37-15.47c0.35-0.91,0.67-1.83,1.06-2.73c1.2-2.75,4.13-4.5,6.88-4.12c3.11,0.43,5.38,2.68,5.84,5.82
		c0.18,1.22-0.09,2.39-0.55,3.52c-0.62,1.54-1.25,3.07-1.88,4.61c-0.3,0.74-0.43,1.48,0.29,2.04c0.75,0.58,1.54,0.42,2.26-0.08
		c0.69-0.47,1.17-1.12,1.54-1.86c2.69-5.34,5.38-10.69,8.06-16.03c0.67-1.34,1.31-2.69,2.02-4.01c1.07-1.98,2.62-3.39,4.89-3.85
		c4.5-0.93,8.54,3.42,7.24,7.98c-1.17,4.09-2.63,8.1-3.95,12.15c-1.44,4.39-2.93,8.76-4.28,13.17c-1.31,4.27-3.92,7.26-8.12,8.84
		c-2.26,0.85-4.44,1.85-6.14,3.67c-1.42,1.51-2.28,3.22-2.18,5.35c0.04,0.84,0.03,1.7-0.08,2.53c-0.16,1.27-0.89,1.88-2.18,1.89
		C68.75,100.01,66.08,100,63.42,100z M63.46,95.96c1.76,0,3.51-0.01,5.27,0.01c0.57,0.01,0.81-0.19,0.82-0.79
		c0.06-3.87,1.95-6.78,4.83-9.16c1.73-1.43,3.71-2.39,5.8-3.15c3.1-1.12,5.13-3.2,6.01-6.4c1.08-3.92,2.5-7.73,3.76-11.59
		c1.46-4.48,2.96-8.94,4.41-13.43c0.36-1.12-0.13-2.21-1.1-2.75c-0.87-0.49-1.91-0.27-2.74,0.58c-0.51,0.52-0.81,1.17-1.13,1.81
		c-3.15,6.28-6.29,12.55-9.44,18.83c-0.72,1.44-1.65,2.72-3,3.65c-2.25,1.56-5.18,1.54-7.18-0.07c-2.02-1.62-2.61-4.15-1.57-6.78
		c0.61-1.54,1.26-3.07,1.87-4.61c0.62-1.55,0.12-2.99-1.2-3.56c-1.36-0.59-2.78,0.09-3.42,1.68c-0.61,1.51-1.17,3.03-1.76,4.55
		c-1.9,4.91-3.79,9.82-4.85,15c-1.04,5.09-1.22,10.24-1.47,15.4c-0.03,0.62,0.25,0.78,0.81,0.78C59.94,95.94,61.7,95.96,63.46,95.96
		z"/>
	<path  d="M49.33,55.48c-5.9,0.01-10.83-4.91-10.76-10.73c0.07-5.87,4.91-10.65,10.75-10.64
		c5.84,0.01,10.71,4.87,10.71,10.69C60.03,50.62,55.17,55.47,49.33,55.48z M49.36,38.29c-3.7-0.02-6.62,2.83-6.64,6.48
		c-0.01,3.66,2.88,6.54,6.57,6.55c3.65,0,6.55-2.82,6.59-6.43C55.91,41.23,53.02,38.3,49.36,38.29z"/>
	<path  d="M21.12,38.34c-5.93,0.01-10.71-4.72-10.71-10.62c0-5.87,4.77-10.67,10.67-10.72
		c5.83-0.05,10.71,4.82,10.72,10.67C31.8,33.58,27.04,38.33,21.12,38.34z M14.57,27.7c0,3.68,2.9,6.59,6.54,6.58
		c3.61-0.01,6.49-2.9,6.51-6.53c0.02-3.69-2.85-6.6-6.5-6.62C17.46,21.13,14.57,24.02,14.57,27.7z"/>
	<path  d="M77.49,38.34c-5.93-0.01-10.69-4.76-10.68-10.66c0.01-5.86,4.89-10.72,10.71-10.68
		c5.9,0.04,10.67,4.83,10.67,10.71C88.19,33.62,83.43,38.35,77.49,38.34z M84.03,27.69c-0.01-3.68-2.9-6.57-6.56-6.55
		c-3.65,0.01-6.51,2.93-6.49,6.62c0.02,3.62,2.9,6.51,6.51,6.52C81.14,34.29,84.04,31.37,84.03,27.69z"/>
	<path  d="M33.05,48.5c-0.03,1.46-1.47,2.36-2.95,1.77c-2-0.8-3.83-1.91-5.6-3.11c-0.7-0.47-1.38-0.97-2.04-1.5
		c-1.01-0.83-1.19-1.98-0.49-2.92c0.68-0.93,1.91-1.13,2.94-0.35c2.13,1.62,4.39,3,6.81,4.13C32.55,46.9,33.01,47.56,33.05,48.5z"/>
	<path class="st7" d="M67.52,50.49c-0.85-0.06-1.51-0.49-1.82-1.33c-0.33-0.88-0.09-1.67,0.62-2.28c0.24-0.21,0.54-0.35,0.83-0.49
		c2.23-1.06,4.35-2.32,6.31-3.83c1.19-0.92,2.44-0.82,3.18,0.18c0.75,1.02,0.49,2.17-0.71,3.11c-2.1,1.65-4.38,3.01-6.78,4.17
		C68.64,50.25,68.13,50.47,67.52,50.49z"/>
	<path  d="M23.51,13.5c-0.84-0.09-1.48-0.53-1.82-1.36c-0.36-0.9-0.08-1.68,0.62-2.28c1.56-1.34,3.29-2.43,5.08-3.42
		c0.88-0.49,1.78-0.94,2.71-1.34c1.12-0.48,2.25-0.07,2.73,0.93c0.49,1.02,0.16,2.19-0.95,2.72c-2.53,1.21-4.91,2.65-7.13,4.36
		C24.41,13.38,23.99,13.48,23.51,13.5z"/>
	<path  d="M67.72,4.87c0.23,0.07,0.61,0.15,0.96,0.31C71.3,6.36,73.74,7.83,76,9.6c1.02,0.8,1.29,1.7,0.87,2.63
		c-0.54,1.19-1.94,1.67-3.01,0.87c-2.28-1.69-4.67-3.16-7.22-4.4c-0.9-0.44-1.25-1.39-1-2.31C65.87,5.54,66.7,4.88,67.72,4.87z"/>
</g>
</svg>
									</div>
									<div class="package--title--cover">
									<div class="package--title">Interest</div>
									<div class="package--title"><span><?php echo $package_interest; ?></span></div>
								</div>
								</li>
							</ul>

						</div>
						
					</div>					
					<div class="package--right">
						<div class="package--right--inner round-conner-20">
							<div class="tour-highlights-title">Tour Highlights</div>
							<?php echo $highlights; ?>
						</div>
					</div>
				</div>
			</div>
		</div>	
	</div>
</section>

<section>
	<div class="container">
		<div class="row">
			<div class="col-sm-12">
				

				<?php
                                $day_1 = get_field('day_1');
                                $day_title_1 = get_field('day_title_1');
                                $day_info_1 = get_field('day_info_1');
                                $day_img_1 = get_field('day_image_1');
                                if(!empty($day_img_1)){
                                	$day_img_1 = $day_img_1;
                                }else{
                                	$day_img_1 =  get_template_directory_uri().'/images/s3-lg.jpg';	
                                }
                                if(!empty($day_1)){
                ?>

				<!---->
				<div class="package-day-details-row odd">
							<div class="package-day-col">
								<div class="package-day-col-content">
									<div class="package-col-day"><?php echo $day_1; ?></div>
									<div class="package-col-day-title"><?php echo  $day_title_1; ?></div>
									<div class="package-col-day-text"><?php echo  $day_info_1; ?></div>
								</div>
							</div>
							<div class="package-day-path odd"></div>
							<div class="package-day-col">
								<div class="package-day-col-img">
									<img src="<?php echo $day_img_1; ?>" class="lozad round-conner-20">
								</div>
							</div>
				</div>
				<!---->
			<?php } ?>



				<?php
                                $day_1 = get_field('day_2');
                                $day_title_1 = get_field('day_title_2');
                                $day_info_1 = get_field('day_info_2');
                                $day_img_1 = get_field('day_image_2');
                                if(!empty($day_img_1)){
                                	$day_img_1 = $day_img_1;
                                }else{
                                	$day_img_1 =  get_template_directory_uri().'/images/s3-lg.jpg';	
                                }
                                if(!empty($day_1)){
                ?>

				<!---->
				<div class="package-day-details-row even">
							<div class="package-day-col">
								<div class="package-day-col-img">
									<img src="<?php echo $day_img_1; ?>" class="lozad round-conner-20">
								</div>

							</div>
							<div class="package-day-path even"></div>
							<div class="package-day-col">
								<div class="package-day-col-content">
									<div class="package-col-day"><?php echo $day_1; ?></div>
									<div class="package-col-day-title"><?php echo  $day_title_1; ?></div>
									<div class="package-col-day-text"><?php echo  $day_info_1; ?></div>
								</div>
							</div>
				</div>
				<!---->
			<?php } ?>



			<?php
                                $day_1 = get_field('day_3');
                                $day_title_1 = get_field('day_title_3');
                                $day_info_1 = get_field('day_info_3');
                                $day_img_1 = get_field('day_image_3');
                                if(!empty($day_img_1)){
                                	$day_img_1 = $day_img_1;
                                }else{
                                	$day_img_1 =  get_template_directory_uri().'/images/s3-lg.jpg';	
                                }
                                if(!empty($day_1)){
                ?>

				<!---->
				<div class="package-day-details-row odd">
							<div class="package-day-col">
								<div class="package-day-col-content">
									<div class="package-col-day"><?php echo $day_1; ?></div>
									<div class="package-col-day-title"><?php echo  $day_title_1; ?></div>
									<div class="package-col-day-text"><?php echo  $day_info_1; ?></div>
								</div>
							</div>
							<div class="package-day-path odd"></div>
							<div class="package-day-col">
								<div class="package-day-col-img">
									<img src="<?php echo $day_img_1; ?>" class="lozad round-conner-20">
								</div>
							</div>
				</div>
				<!---->
			<?php } ?>


			<?php
                                $day_1 = get_field('day_4');
                                $day_title_1 = get_field('day_title_4');
                                $day_info_1 = get_field('day_info_4');
                                $day_img_1 = get_field('day_image_4');
                                if(!empty($day_img_1)){
                                	$day_img_1 = $day_img_1;
                                }else{
                                	$day_img_1 =  get_template_directory_uri().'/images/s3-lg.jpg';	
                                }
                                if(!empty($day_1)){
                ?>

				<!---->
				<div class="package-day-details-row even">
							<div class="package-day-col">
								<div class="package-day-col-img">
									<img src="<?php echo $day_img_1; ?>" class="lozad round-conner-20">
								</div>
								
							</div>
							<div class="package-day-path even"></div>
							<div class="package-day-col">
								<div class="package-day-col-content">
									<div class="package-col-day"><?php echo $day_1; ?></div>
									<div class="package-col-day-title"><?php echo  $day_title_1; ?></div>
									<div class="package-col-day-text"><?php echo  $day_info_1; ?></div>
								</div>
							</div>
				</div>
				<!---->
			<?php } ?>


<?php
                                $day_1 = get_field('day_5');
                                $day_title_1 = get_field('day_title_5');
                                $day_info_1 = get_field('day_info_5');
                                $day_img_1 = get_field('day_image_5');
                                if(!empty($day_img_1)){
                                	$day_img_1 = $day_img_1;
                                }else{
                                	$day_img_1 =  get_template_directory_uri().'/images/s3-lg.jpg';	
                                }
                                if(!empty($day_1)){
                ?>

				<!---->
				<div class="package-day-details-row odd">
							<div class="package-day-col">
								<div class="package-day-col-content">
									<div class="package-col-day"><?php echo $day_1; ?></div>
									<div class="package-col-day-title"><?php echo  $day_title_1; ?></div>
									<div class="package-col-day-text"><?php echo  $day_info_1; ?></div>
								</div>
							</div>
							<div class="package-day-path odd"></div>
							<div class="package-day-col">
								<div class="package-day-col-img">
									<img src="<?php echo $day_img_1; ?>" class="lozad round-conner-20">
								</div>
							</div>
				</div>
				<!---->
			<?php } ?>


			<?php
                                $day_1 = get_field('day_6');
                                $day_title_1 = get_field('day_title_6');
                                $day_info_1 = get_field('day_info_6');
                                $day_img_1 = get_field('day_image_6');
                                if(!empty($day_img_1)){
                                	$day_img_1 = $day_img_1;
                                }else{
                                	$day_img_1 =  get_template_directory_uri().'/images/s3-lg.jpg';	
                                }
                                if(!empty($day_1)){
                ?>

				<!---->
				<div class="package-day-details-row even">
							<div class="package-day-col">
								<div class="package-day-col-img">
									<img src="<?php echo $day_img_1; ?>" class="lozad round-conner-20">
								</div>
								
							</div>
							<div class="package-day-path even"></div>
							<div class="package-day-col">
								<div class="package-day-col-content">
									<div class="package-col-day"><?php echo $day_1; ?></div>
									<div class="package-col-day-title"><?php echo  $day_title_1; ?></div>
									<div class="package-col-day-text"><?php echo  $day_info_1; ?></div>
								</div>
							</div>
				</div>
				<!---->
			<?php } ?>



			<?php
                                $day_1 = get_field('day_7');
                                $day_title_1 = get_field('day_title_7');
                                $day_info_1 = get_field('day_info_7');
                                $day_img_1 = get_field('day_image_7');
                                if(!empty($day_img_1)){
                                	$day_img_1 = $day_img_1;
                                }else{
                                	$day_img_1 =  get_template_directory_uri().'/images/s3-lg.jpg';	
                                }
                                if(!empty($day_1)){
                ?>

				<!---->
				<div class="package-day-details-row odd">
							
							
							<div class="package-day-col">
								<div class="package-day-col-content">
									<div class="package-col-day"><?php echo $day_1; ?></div>
									<div class="package-col-day-title"><?php echo  $day_title_1; ?></div>
									<div class="package-col-day-text"><?php echo  $day_info_1; ?></div>
								</div>
							</div>
							<div class="package-day-path odd"></div>
							<div class="package-day-col">
								<div class="package-day-col-img">
									<img src="<?php echo $day_img_1; ?>" class="lozad round-conner-20">
								</div>
								
							</div>
				</div>
				<!---->
			<?php } ?>





			<?php
                                $day_1 = get_field('day_8');
                                $day_title_1 = get_field('day_title_8');
                                $day_info_1 = get_field('day_info_8');
                                $day_img_1 = get_field('day_image_8');
                                if(!empty($day_img_1)){
                                	$day_img_1 = $day_img_1;
                                }else{
                                	$day_img_1 =  get_template_directory_uri().'/images/s3-lg.jpg';	
                                }
                                if(!empty($day_1)){
                ?>

				<!---->
				<div class="package-day-details-row even">
							<div class="package-day-col">
								<div class="package-day-col-img">
									<img src="<?php echo $day_img_1; ?>" class="lozad round-conner-20">
								</div>
								
							</div>
							<div class="package-day-path even"></div>
							<div class="package-day-col">
								<div class="package-day-col-content">
									<div class="package-col-day"><?php echo $day_1; ?></div>
									<div class="package-col-day-title"><?php echo  $day_title_1; ?></div>
									<div class="package-col-day-text"><?php echo  $day_info_1; ?></div>
								</div>
							</div>
				</div>
				<!---->
			<?php } ?>



			<?php
                                $day_1 = get_field('day_9');
                                $day_title_1 = get_field('day_title_9');
                                $day_info_1 = get_field('day_info_9');
                                $day_img_1 = get_field('day_image_9');
                                if(!empty($day_img_1)){
                                	$day_img_1 = $day_img_1;
                                }else{
                                	$day_img_1 =  get_template_directory_uri().'/images/s3-lg.jpg';	
                                }
                                if(!empty($day_1)){
                ?>

				<!---->
				<div class="package-day-details-row odd">
							
							
							<div class="package-day-col">
								<div class="package-day-col-content">
									<div class="package-col-day"><?php echo $day_1; ?></div>
									<div class="package-col-day-title"><?php echo  $day_title_1; ?></div>
									<div class="package-col-day-text"><?php echo  $day_info_1; ?></div>
								</div>
							</div>
							<div class="package-day-path odd"></div>
							<div class="package-day-col">
								<div class="package-day-col-img">
									<img src="<?php echo $day_img_1; ?>" class="lozad round-conner-20">
								</div>
								
							</div>
				</div>
				<!---->
			<?php } ?>






			<?php
                                $day_1 = get_field('day_10');
                                $day_title_1 = get_field('day_title_10');
                                $day_info_1 = get_field('day_info_10');
                                $day_img_1 = get_field('day_image_10');
                                if(!empty($day_img_1)){
                                	$day_img_1 = $day_img_1;
                                }else{
                                	$day_img_1 =  get_template_directory_uri().'/images/s3-lg.jpg';	
                                }
                                if(!empty($day_1)){
                ?>

				<!---->
				<div class="package-day-details-row even">
							<div class="package-day-col">
								<div class="package-day-col-img">
									<img src="<?php echo $day_img_1; ?>" class="lozad round-conner-20">
								</div>
								
							</div>
							<div class="package-day-path even"></div>
							<div class="package-day-col">
								<div class="package-day-col-content">
									<div class="package-col-day"><?php echo $day_1; ?></div>
									<div class="package-col-day-title"><?php echo  $day_title_1; ?></div>
									<div class="package-col-day-text"><?php echo  $day_info_1; ?></div>
								</div>
							</div>
				</div>
				<!---->
			<?php } ?>



			<?php
                                $day_1 = get_field('day_11');
                                $day_title_1 = get_field('day_title_11');
                                $day_info_1 = get_field('day_info_11');
                                $day_img_1 = get_field('day_image_11');
                                if(!empty($day_img_1)){
                                	$day_img_1 = $day_img_1;
                                }else{
                                	$day_img_1 =  get_template_directory_uri().'/images/s3-lg.jpg';	
                                }
                                if(!empty($day_1)){
                ?>

				<!---->
				<div class="package-day-details-row odd">
						
							
							<div class="package-day-col">
								<div class="package-day-col-content">
									<div class="package-col-day"><?php echo $day_1; ?></div>
									<div class="package-col-day-title"><?php echo  $day_title_1; ?></div>
									<div class="package-col-day-text"><?php echo  $day_info_1; ?></div>
								</div>
							</div>
							<div class="package-day-path odd"></div>
								<div class="package-day-col">
								<div class="package-day-col-img">
									<img src="<?php echo $day_img_1; ?>" class="lozad round-conner-20">
								</div>
								
							</div>

				</div>
				<!---->
			<?php } ?>


			<?php
                                $day_1 = get_field('day_12');
                                $day_title_1 = get_field('day_title_12');
                                $day_info_1 = get_field('day_info_12');
                                $day_img_1 = get_field('day_image_12');
                                if(!empty($day_img_1)){
                                	$day_img_1 = $day_img_1;
                                }else{
                                	$day_img_1 =  get_template_directory_uri().'/images/s3-lg.jpg';	
                                }
                                if(!empty($day_1)){
                ?>

				<!---->
				<div class="package-day-details-row even">
							<div class="package-day-col">
								<div class="package-day-col-img">
									<img src="<?php echo $day_img_1; ?>" class="lozad round-conner-20">
								</div>
								
							</div>
							<div class="package-day-path even"></div>
							<div class="package-day-col">
								<div class="package-day-col-content">
									<div class="package-col-day"><?php echo $day_1; ?></div>
									<div class="package-col-day-title"><?php echo  $day_title_1; ?></div>
									<div class="package-col-day-text"><?php echo  $day_info_1; ?></div>
								</div>
							</div>
				</div>
				<!---->
			<?php } ?>



			<?php
                                $day_1 = get_field('day_13');
                                $day_title_1 = get_field('day_title_13');
                                $day_info_1 = get_field('day_info_13');
                                $day_img_1 = get_field('day_image_13');
                                if(!empty($day_img_1)){
                                	$day_img_1 = $day_img_1;
                                }else{
                                	$day_img_1 =  get_template_directory_uri().'/images/s3-lg.jpg';	
                                }
                                if(!empty($day_1)){
                ?>

				<!---->
				<div class="package-day-details-row odd">
							
							
							<div class="package-day-col">
								<div class="package-day-col-content">
									<div class="package-col-day"><?php echo $day_1; ?></div>
									<div class="package-col-day-title"><?php echo  $day_title_1; ?></div>
									<div class="package-col-day-text"><?php echo  $day_info_1; ?></div>
								</div>
							</div>
							<div class="package-day-path odd"></div>
							<div class="package-day-col">
								<div class="package-day-col-img">
									<img src="<?php echo $day_img_1; ?>" class="lozad round-conner-20">
								</div>
								
							</div>
				</div>
				<!---->
			<?php } ?>



			<?php
                                $day_1 = get_field('day_14');
                                $day_title_1 = get_field('day_title_14');
                                $day_info_1 = get_field('day_info_14');
                                $day_img_1 = get_field('day_image_14');
                                if(!empty($day_img_1)){
                                	$day_img_1 = $day_img_1;
                                }else{
                                	$day_img_1 =  get_template_directory_uri().'/images/s3-lg.jpg';	
                                }
                                if(!empty($day_1)){
                ?>

				<!---->
				<div class="package-day-details-row even">
							<div class="package-day-col">
								<div class="package-day-col-img">
									<img src="<?php echo $day_img_1; ?>" class="lozad round-conner-20">
								</div>
								
							</div>
							<div class="package-day-path even"></div>
							<div class="package-day-col">
								<div class="package-day-col-content">
									<div class="package-col-day"><?php echo $day_1; ?></div>
									<div class="package-col-day-title"><?php echo  $day_title_1; ?></div>
									<div class="package-col-day-text"><?php echo  $day_info_1; ?></div>
								</div>
							</div>
				</div>
				<!---->
			<?php } ?>


			</div>
		</div>


<div class="row pt-60">
	<div class="col-sm-12">
			<?php include get_theme_file_path( 'package-form.php' );  ?>
	</div>
</div>



	</div>
</section>

<?php get_footer(); ?>