<?php
/**
 * Template Name: Packages Page
*/
get_header(); 
include get_theme_file_path( 'header-widget.php' ); 
?>
<style>


/************/
.Dtab{
	display: flex;
    justify-content: center;
    gap: 20px;

}
.Dtablinks{
	border: 0;
	background: #0000;
	outline: 0;
	position: relative;
}

.Dtablinks.active::before {
    transform-origin: left;
    transform: scaleX(1);
}

.Dtablinks::before{
    content: '';
    position: absolute;
    width: 100%;
    height: 2px;
    border-radius: 4px;
    background-color: #BED630;
    bottom: 0;
    left: 0;
    transform-origin: right;
    transform: scaleX(0);
    transition: transform .3s ease-in-out;
}


.Dtablinks:hover::before {
  transform-origin: left;
  transform: scaleX(1);
}

/******/
/******/

.package-home{
		display: grid;
		grid-template-columns: 1fr 1fr;
		gap: 40px;
	}

.package--col{}

.package--col--inner{
	display: grid;
grid-template-columns: 1fr 1fr;
gap: 20px;
align-items: center;
}

.package--img-cover{
	overflow: hidden;
	position: relative;
}
.package--img{
		width:100%;
  background:url() 50% 50% no-repeat;
  background-size:cover;
  background-clip:content-box; 
    position:relative;

        /* Initial scale */
    transform: scale(1.2);
    /* Combined transitions for box-shadow and transform */
    transition: transform 1s, visibility 1s ease-in;

}

.package--img:before{
     display:block;
     content:"";
    padding-top:160%;
}

.package--content{

}
.package--title{
	    font-size: 24px;
    font-weight: 700;
    margin-bottom: 15px;
}

.package--img-bg{

    position: absolute;
    width: 100%;
    height: 100%;
    z-index: 1;
    opacity: 0;
      transition: opacity 2s ease;
}

.day-amount{
    position: absolute;
    z-index: 99;
    color: #fff;
    font-size: 23px;
    font-weight: 600;
    top: 13px;
    left: 15px;
}
.package--button{
	padding-top: 25px;
}
/*******Hover********/
.package--col:hover .package--img{
  transform: scale(1);
}
.package--col:hover .package--img-bg{

}

/**********/
@media screen and (max-width: 865px) {
.package--col--inner {
    grid-template-columns: 1fr;

}
.package--img:before {

    padding-top: 100%;
}


}


@media screen and (max-width: 700px) {
.package-home {
    display: grid;
    grid-template-columns: 1fr;
    gap: 40px;
}
.package--img:before {
    padding-top: 60%;
}

}

@media screen and (max-width: 500px) {
.package--img:before {
    padding-top: 90%;
}

.Dtab {
    display: grid;
    justify-content: center;
    gap: 10px;
}
}
</style>	

<section>
	<div class="container">
		<div class="row text-center pb-50">
			<div class="col-sm-12">
				<?php the_content(); ?>
			</div>
		</div>
		
			<div class="row pb-60">
			<div class="col-sm-12">
 
<div class="Dtab">
  <button class="Dtablinks" onclick="openCity(event, 'D1')" id="defaultOpenD">Two of Us </button>
  <button class="Dtablinks" onclick="openCity(event, 'D2')">Specialty</button>
  <button class="Dtablinks" onclick="openCity(event, 'D3')">Tours With Family</button>
</div>

			</div>
		</div>	

<div class="row">
<div class="col-sm-12">

<!---->
<div class="Dtabcontent" id="D1">
<div class="package-home">
<?php 
$z = 1;
$args = array( 
'post_type' => 'post',
'posts_per_page' => 100 , 
'orderby' =>'menu_order',
'meta_key'      => 'package_options',
'meta_value'    => 'two_of_us'

);
$the_query = new WP_Query( $args ); 
if ( $the_query->have_posts() ) {
while ( $the_query->have_posts() ) { $the_query->the_post(); 
 
$day_night_1  = get_field( "day_night_1" );
$day_night_2  = get_field( "day_night_2" );

$package_front_image = get_field("package_front_image");
if(!empty($package_front_image )){ 
$package_front_image = $package_front_image;
 }else{ 
$package_front_image = get_template_directory_uri().'/images/s3-lg.jpg';
 } 
?>	
<div class="package--col">
						<div class="package--col--inner">
						<div class="package--img-cover round-conner-20">
						<div class="day-amount">
							<?php echo $day_night_1; ?> D / <?php echo $day_night_2; ?> N
						</div>	
						<div class="package--img-bg round-conner-20"></div>	
						<div class="package--img lozad round-conner-20"  data-background-image="<?php echo $package_front_image; ?>">						
						</div>
						</div>
						<div class="package--content">
							<div class="package--title"><?php the_title(); ?></div>
							<div class="package--text"><?php
                                $char_limit = 150;
                                $content    = $post->post_content;
                                echo substr(strip_tags($content), 0, $char_limit) . '....';
                                ?></div>
							<div class="package--button"><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="custom-button dark-green-button">View Package</a></div>
						</div>
						</div>
					</div>
<?php $z = ++$z; } wp_reset_postdata(); ?>
<?php }else{  ?>
<p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
<?php } ?> 
</div>
</div>
<!---->
<!---->
<div class="Dtabcontent" id="D2">
<div class="package-home">
<?php 
$z = 1;
$args = array( 
'post_type' => 'post',
'posts_per_page' => 100 , 
'orderby' =>'menu_order',
'meta_key'      => 'package_options',
'meta_value'    => 'specialty'

);
$the_query = new WP_Query( $args ); 
if ( $the_query->have_posts() ) {
while ( $the_query->have_posts() ) { $the_query->the_post(); 
 
$day_night_1  = get_field( "day_night_1" );
$day_night_2  = get_field( "day_night_2" );

$package_front_image = get_field("package_front_image");
if(!empty($package_front_image )){ 
$package_front_image = $package_front_image;
 }else{ 
$package_front_image = get_template_directory_uri().'/images/s3-lg.jpg';
 } 
?>	
<div class="package--col">
						<div class="package--col--inner">
						<div class="package--img-cover round-conner-20">
						<div class="day-amount">
							<?php echo $day_night_1; ?> D / <?php echo $day_night_2; ?> N
						</div>	
						<div class="package--img-bg round-conner-20"></div>	
						<div class="package--img lozad round-conner-20"  data-background-image="<?php echo $package_front_image; ?>">						
						</div>
						</div>
						<div class="package--content">
							<div class="package--title"><?php the_title(); ?></div>
							<div class="package--text"><?php
                                $char_limit = 150;
                                $content    = $post->post_content;
                                echo substr(strip_tags($content), 0, $char_limit) . '....';
                                ?></div>
							<div class="package--button"><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="custom-button dark-green-button">View Package</a></div>
						</div>
						</div>
					</div>
<?php $z = ++$z; } wp_reset_postdata(); ?>
<?php }else{  ?>
<p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
<?php } ?> 
</div>

</div>
<!---->
<!---->
<div class="Dtabcontent" id="D3">
<div class="package-home">
<?php 
$z = 1;
$args = array( 
'post_type' => 'post',
'posts_per_page' => 100 , 
'orderby' =>'menu_order',
'meta_key'      => 'package_options',
'meta_value'    => 'family'

);
$the_query = new WP_Query( $args ); 
if ( $the_query->have_posts() ) {
while ( $the_query->have_posts() ) { $the_query->the_post(); 
 
$day_night_1  = get_field( "day_night_1" );
$day_night_2  = get_field( "day_night_2" );

$package_front_image = get_field("package_front_image");
if(!empty($package_front_image )){ 
$package_front_image = $package_front_image;
 }else{ 
$package_front_image = get_template_directory_uri().'/images/s3-lg.jpg';
 } 
?>	
<div class="package--col">
						<div class="package--col--inner">
						<div class="package--img-cover round-conner-20">
						<div class="day-amount">
							<?php echo $day_night_1; ?> D / <?php echo $day_night_2; ?> N
						</div>	
						<div class="package--img-bg round-conner-20"></div>	
						<div class="package--img lozad round-conner-20"  data-background-image="<?php echo $package_front_image; ?>">						
						</div>
						</div>
						<div class="package--content">
							<div class="package--title"><?php the_title(); ?></div>
							<div class="package--text"><?php
                                $char_limit = 150;
                                $content    = $post->post_content;
                                echo substr(strip_tags($content), 0, $char_limit) . '....';
                                ?></div>
							<div class="package--button"><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="custom-button dark-green-button">View Package</a></div>
						</div>
						</div>
					</div>
<?php $z = ++$z; } wp_reset_postdata(); ?>
<?php }else{  ?>
<p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
<?php } ?> 
</div>


</div>
<!---->

</div>
</div>

</div>
</section>

<script>
function openCity(evt, cityName) {
  var i, tabcontent, tablinks;
  tabcontent = document.getElementsByClassName("Dtabcontent");
  for (i = 0; i < tabcontent.length; i++) {
    tabcontent[i].style.display = "none";
  }
  tablinks = document.getElementsByClassName("Dtablinks");
  for (i = 0; i < tablinks.length; i++) {
    tablinks[i].className = tablinks[i].className.replace(" active", "");
  }
  document.getElementById(cityName).style.display = "block";
  evt.currentTarget.className += " active";
}

// Get the element with id="defaultOpen" and click on it
document.getElementById("defaultOpenD").click();
</script>

<?php get_footer(); ?>