
jQuery(function($) {

	"use strict";

		/**
		 * Sticky Header
		 */
		$(".container-wrapper").waypoint(function() {
			$(".navbar").toggleClass("navbar-sticky-function");
			$(".navbar").toggleClass("navbar-sticky");
			return false;
		}, { offset: "-20px" });
		
		
		
		
		/**
		 * Smooth scroll to anchor
		 */
		$('a.anchor[href*=#]:not([href=#])').on("click",function() {
			if (location.pathname.replace(/^\//,'') == this.pathname.replace(/^\//,'') && location.hostname == this.hostname) {
				var target = $(this.hash);
				target = target.length ? target : $('[name=' + this.hash.slice(1) +']');
				if (target.length) {
					$('html,body').animate({
						scrollTop: (target.offset().top - 120) // 70px offset for navbar menu
					}, 1000);
					return false;
				}
			}
		});
		
		


	/**
		 * Slicknav - a Mobile Menu
		 */
		$('#responsive-menu').slicknav({
			duration: 300,
			easingOpen: 'easeInExpo',
			easingClose: 'easeOutExpo',
			closedSymbol: '<i class="fa fa-plus"></i>',
			openedSymbol: '<i class="fa fa-minus"></i>',
			prependTo: '#slicknav-mobile',
			allowParentLinks: true,
			label:"" 
		});
		
		
		

		/**
		 * slick
		 */
		 
		 
		
		 
		 $('.homeexcursions').slick({
			slidesToShow: 4,
			slidesToScroll:1,
			arrows:true,
			infinite: true,
			autoplay: true,
           autoplaySpeed: 3000,
			responsive: [
				{
				breakpoint: 1199,
				settings: {
					slidesToShow: 4,
					}
				}, 
				{
				breakpoint: 991,
				settings: {
					slidesToShow: 3
				
					}
				}, 
				{
				breakpoint: 767,
				settings: {
					slidesToShow: 2
					 
					}
				}, 
				{
				breakpoint: 480,
				settings: {
					slidesToShow: 1
					
					}
				}
			]
			
		});
		
		
		 $('.reviews-wrapper').slick({
			slidesToShow: 3,
			slidesToScroll:1,
			arrows:true,
			infinite: true,
			autoplay: true,
			 dots: true,
           autoplaySpeed: 3000,
			responsive: [
				{
				breakpoint: 1199,
				settings: {
					slidesToShow: 3,
					}
				}, 
				{
				breakpoint: 991,
				settings: {
					slidesToShow: 2,
					 dots: false
					
					}
				}, 
				{
				breakpoint: 767,
				settings: {
					slidesToShow: 2,
					 dots: false
					
			
					}
				}, 
				{
				breakpoint: 550,
				settings: {
					slidesToShow: 1,
					 dots: false
					
					}
				}
			]
			
		});
		
		
		 
		 
		$('.gallery-slideshow').slick({
			slidesToShow: 5,
			slidesToScroll:1,
			speed: 500,
			arrows: true,
			fade: true,
			asNavFor: '.gallery-nav'
		});
		$('.gallery-nav').slick({
			slidesToShow: 7,
			slidesToScroll: 1,
			speed: 500,
			asNavFor: '.gallery-slideshow',
			dots: false,
			centerMode: true,
			focusOnSelect: true,
			infinite: true,
			responsive: [
				{
				breakpoint: 1199,
				settings: {
					slidesToShow: 7,
					}
				}, 
				{
				breakpoint: 991,
				settings: {
					slidesToShow: 5,
					 dots: true,
					 arrows: false
					}
				}, 
				{
				breakpoint: 767,
				settings: {
					slidesToShow: 5,
					 dots: true,
					 arrows: false
					}
				}, 
				{
				breakpoint: 480,
				settings: {
					slidesToShow: 3,
					 dots: true,
					 arrows: false
					}
				}
			]
		});




		 $('.destination-1').slick({			
			slidesToShow: 3,
			slidesToScroll:1,
			arrows:true,
			infinite: true,
			dots: false,
			autoplay: false,
           autoplaySpeed: 3000,
			responsive: [
				{
				breakpoint: 1199,
				settings: {
					slidesToShow: 3,
					}
				}, 
				{
				breakpoint: 991,
				settings: {
					slidesToShow: 2,
					rows:1,  
					}
				}, 
				{
				breakpoint: 767,
				settings: {
					slidesToShow: 2,
					rows:1, 
					}
				}, 
				{
				breakpoint: 580,
				settings: {
					slidesToShow: 1,
					rows:1, 
					}
				}
			]
			
		});
		
		
		
		$('.experiences').slick({
			slidesToShow:1,
			slidesToScroll:1,
			arrows:true,
			infinite: true,
			autoplay: true,
           autoplaySpeed: 3000,
			 dots: false,
			responsive: [
				{
				breakpoint: 1199,
				settings: {
					slidesToShow:1,
					}
				}, 
				{
				breakpoint: 991,
				settings: {
					slidesToShow: 1,
					
					}
				}, 
				{
				breakpoint: 767,
				settings: {
					slidesToShow: 1,
					
					}
				}, 
				{
				breakpoint: 580,
				settings: {
					slidesToShow: 1,
					
					}
				}
			]
			
		});
		
		
		
		$('.daytour-1').slick({
			slidesToShow:3,
			slidesToScroll:1,
			arrows:true,
			infinite: true,
			autoplay: true,
           autoplaySpeed: 3000,
			 dots: true,
			responsive: [
				{
				breakpoint: 1199,
				settings: {
					slidesToShow:3,
					}
				}, 
				{
				breakpoint: 991,
				settings: {
					slidesToShow: 2,
					
					}
				}, 
				{
				breakpoint: 767,
				settings: {
					slidesToShow: 2,
					
					}
				}, 
				{
				breakpoint: 580,
				settings: {
					slidesToShow: 1,
					
					}
				}
			]
			
		});
		
		 
	
		
		 $('.activi-1').slick({
			slidesToShow: 1,
			slidesToScroll:1,
			dots: false,
			arrows:true,
			infinite: true,
			autoplay: true,
           autoplaySpeed: 3000,
			
			
		});
		
		
		 $('.activi-2').slick({
			slidesToShow: 1,
			slidesToScroll:1,
			dots: false,
			arrows:true,
			infinite: true,
			autoplay: true,
           autoplaySpeed: 3000,
						
		});
		
		
		
		 $('.activi-3').slick({
			slidesToShow: 1,
			slidesToScroll:1,
			dots: false,
			arrows:true,
			infinite: true,
			autoplay: true,
           autoplaySpeed: 3000,
						
		});
		
		 $('.activi-4').slick({
			slidesToShow: 1,
			slidesToScroll:1,
			dots: false,
			arrows:true,
			infinite: true,
			autoplay: true,
           autoplaySpeed: 3000,
						
		});
		
		 $('.activi-5').slick({
			slidesToShow: 1,
			slidesToScroll:1,
			dots: false,
			arrows:true,
			infinite: true,
			autoplay: true,
           autoplaySpeed: 3000,
						
		});
		
		
		 $('.activi-6').slick({
			slidesToShow: 1,
			slidesToScroll:1,
			dots: false,
			arrows:true,
			infinite: true,
			autoplay: true,
           autoplaySpeed: 3000,
						
		});
		
		
		
		 $('.activi-7').slick({
			slidesToShow: 1,
			slidesToScroll:1,
			dots: false,
			arrows:true,
			infinite: true,
			autoplay: true,
           autoplaySpeed: 3000,
						
		});
		
		
		
		 $('.activi-8').slick({
			slidesToShow: 1,
			slidesToScroll:1,
			dots: false,
			arrows:true,
			infinite: true,
			autoplay: true,
           autoplaySpeed: 3000,
						
		});
		
		
		 $('.activi-9').slick({
			slidesToShow: 1,
			slidesToScroll:1,
			dots: false,
			arrows:true,
			infinite: true,
			autoplay: true,
           autoplaySpeed: 3000,
						
		});
		
		
		 $('.activi-10').slick({
			slidesToShow: 1,
			slidesToScroll:1,
			dots: false,
			arrows:true,
			infinite: true,
			autoplay: true,
           autoplaySpeed: 3000,
						
		});
		
		
		 $('.activi-11').slick({
			slidesToShow: 1,
			slidesToScroll:1,
			dots: false,
			arrows:true,
			infinite: true,
			autoplay: true,
           autoplaySpeed: 3000,
						
		});
		 $('.package-h').slick({
			slidesToShow: 1,
			slidesToScroll:1,
			dots: false,
			arrows:true,
			infinite: true,
			autoplay: true,
           autoplaySpeed: 3000,
			
			
		});
		
		
		
		$('.packh').slick({
			slidesToShow: 3,
			slidesToScroll:1,
			arrows:true,
			infinite: true,
			autoplay: true,
           autoplaySpeed: 3000,
			 dots: false,
			responsive: [
				{
				breakpoint: 1199,
				settings: {
					slidesToShow: 3,
					}
				}, 
				{
				breakpoint: 991,
				settings: {
					slidesToShow: 2,
					
					}
				}, 
				{
				breakpoint: 767,
				settings: {
					slidesToShow: 2,
					
					}
				}, 
				{
				breakpoint: 580,
				settings: {
					slidesToShow: 1,
					
					}
				}
			]
			
		});
		
		 
		
	
})(jQuery);