<?php
/**
 * Template for displaying all single posts
 *
 * @package WordPress
 * @subpackage Twenty_Ten
 * @since Twenty Ten 1.0
 */
get_header(); 
include get_theme_file_path( 'header-widget.php' ); 

$when =  get_field("when");
$suitable =  get_field("suitable");
$long = get_field("long");
$day_tours_short = get_field("day_tours_short");

$tours_includes = get_field("tours_includes");

$day_tour_gallery_1 = get_field("day_tour_gallery_1");
$day_tour_gallery_2 = get_field("day_tour_gallery_2");
$day_tour_gallery_3 = get_field("day_tour_gallery_3");
$day_tour_gallery_4 = get_field("day_tour_gallery_4");
$day_tour_gallery_5 = get_field("day_tour_gallery_5");

?>
<style type="text/css">

.daytours-cover{
	display: grid;
	grid-template-columns: 1fr 1fr 1fr;
	gap: 60px;
}
.daytour--col--0{ text-align:center; }
.daytour--col--title{
	  font-size: 30px;
    font-weight: 700;
    text-transform: uppercase;
    line-height: 1;
    margin-bottom: 15px;
    color: #04211D;
}
.daytour--col--text{}


	.daytour-subtitle{
  font-size: 30px;
    font-weight: 700;
    text-transform: uppercase;
    line-height: 1;
    margin-bottom: 15px;
    color: #04211D;
	}
	.includes-text{

	}
	.includes-text ul{
		list-style: none;
		padding: 0;
		display: grid;
		grid-template-columns: 1fr 1fr 1fr;
		gap: 15px;

	}
	.includes-text ul li{
		position: relative;
		padding-left: 25px;

	}	

		.includes-text ul li::after{
			content: '';
			position: absolute;
			width: 10px;
			height: 10px;
			-border-radius:100%;
			-webkit-border-radius:100%;
			-moz-border-radius:100%;
			background: #BED630;			
			left: 0;
    		top: 8px;


		}
	/**************/
	.daytours-slider-section{
		overflow: hidden;
		padding: 50px 0;
	} 

	.day-gallery{

	}

	.day-gallery img{
    height: 700px;
    object-fit: cover;
    width: 100%;
	}

	/*************/
	.newsletter{
		padding: 50px 0;
		background: #04211D;
		color: #fff;
	}

.newsletter--inner{}
.newsletter--inner--1{ 
    display: grid;
    grid-template-columns: 1fr 160px;
    gap: 45px;
    align-items: center;
 }
.newsletter--left{}
.newsletter--right{}
.newsletter--title{
	    font-size: 50px;
    line-height: 1.2;
    margin-bottom: 14px;
}
.newsletter--text{}
.newsletter--button{}
.newsletter--button a{ 
    padding: 10px 20px 10px 20px;
    font-size: 20px;
 }

/****************/
 .includes-section{
 	    width: 100%;
    padding: 50px 0;
    background: #f7f7f7;
 }
 .includes-section ul{

 }
 .includes-section ul li{
 	
 }


@media screen and (max-width: 767px) {
.daytour--col--title{
	font-size:19px ;
}

.newsletter--title {
    font-size: 30px;

}

.includes-text ul {
    grid-template-columns: 1fr 1fr;
}

}

@media screen and (max-width: 600px) {
.daytours-cover {
    display: grid;
    grid-template-columns: 1fr;
    gap: 25px;
}

.newsletter--inner--1 {
    display: grid;
    grid-template-columns: 1fr;
    gap: 25px;
    align-items: center;
}

    .includes-text ul {
        grid-template-columns: 1fr;
    }

}
</style>

<section class="pb-0">
	<div class="container">
		<div class="row">
			<div class="col-sm-12">				
				<div class="daytours-cover">
					<div class="daytour--col--0">
						<div class="daytour--col--title">When</div>
						<div class="daytour--col--text"><?php echo $when; ?></div>
					</div>
					<div class="daytour--col--0">
						<div class="daytour--col--title">Suitable For</div>
						<div class="daytour--col--text"><?php echo $suitable; ?></div>
					</div>
					<div class="daytour--col--0">
						<div class="daytour--col--title">How Long</div>
						<div class="daytour--col--text"><?php echo $long; ?></div>
					</div>
				</div>

			</div>
		</div>
	</div>


<div class="daytours-slider-section">
	<div class=" day-gallery">
		
		<?php if(!empty($day_tour_gallery_1)){ ?>
		<!---->
		<div class="daytour-gallery-img">
			<img  src="<?php echo $day_tour_gallery_1; ?>">
		</div>
		<!---->
		<?php } ?>
		<?php if(!empty($day_tour_gallery_2)){ ?>
		<!---->
		<div class="daytour-gallery-img">
			<img  src="<?php echo $day_tour_gallery_2; ?>">
		</div>
		<!---->
		<?php } ?>
		<?php if(!empty($day_tour_gallery_3)){ ?>
		<!---->
		<div class="daytour-gallery-img">
			<img  src="<?php echo $day_tour_gallery_3; ?>">
		</div>
		<!---->
		<?php } ?>
		<?php if(!empty($day_tour_gallery_4)){ ?>
		<!---->
		<div class="daytour-gallery-img">
			<img  src="<?php echo $day_tour_gallery_4; ?>">
		</div>
		<!---->
		<?php } ?>
		<?php if(!empty($day_tour_gallery_5)){ ?>
		<!---->
		<div class="daytour-gallery-img">
			<img  src="<?php echo $day_tour_gallery_5; ?>">
		</div>
		<!---->
		<?php } ?>


	</div>
</div>

<div class="container">
		<div class="row pb-40 text-center">
			<div class="col-sm-12">					
				<?php  echo $day_tours_short; ?>
			</div>
		</div>
</div>

<div class="newsletter">
	<div class="container">
		<div class="row">
			<div class="col-sm-12">
				<div class="newsletter--inner">
					<div class="newsletter--inner--1">
					<div class="newsletter--left">
						<div class="newsletter--title">Inquire about this Trip</div>
						<div class="newsletter--text">All Epic Leisure Club trips are tailored exactly the way you need. Let's create an itinerary that’s entirely yours!</div>
					</div>
					<div class="newsletter--right">
						<div class="newsletter--button">
							<a href="" class="custom-button light-green-button" title="Inquire Now">Inquire Now</a>
						</div>
					</div>
					</div>
				</div>
			</div>
		</div>
	</div>			
</div>

<div class="container">
		<div class="row pb-40">
			<div class="col-sm-12">	
				<?php the_content(); ?>
			</div>
		</div>
			
</div>

<div class="includes-section">
<div class="container">
		
		<div class="row">
			<div class="col-sm-12">	
				<div class="daytour-subtitle">INCLUDES</div>
				<div class="includes-text">
				<?php echo $tours_includes; ?>
				</div>
			</div>
		</div>			
</div>
</div>

</section>


<?php get_footer(); ?>