	<?php
/**
 * Header template for our theme
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />

<meta name="viewport" content="width=device-width, minimum-scale=1.0, maximum-scale=1.0" />
<title>
<?php
	/*
	 * Print the <title> tag based on what is being viewed.
	 */
	global $page, $paged;

	wp_title( '|', true, 'right' );

	// Add the blog name.
	bloginfo( 'name' );

	// Add the blog description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
if ( $site_description && ( is_home() || is_front_page() ) ) {
	echo " | $site_description";
}

	// Add a page number if necessary:
if ( ( $paged >= 2 || $page >= 2 ) && ! is_404() ) {
	echo esc_html( ' | ' . sprintf( __( 'Page %s', 'twentyten' ), max( $paged, $page ) ) );
}

?>
	</title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php echo esc_url( get_bloginfo( 'pingback_url' ) ); ?>">
<?php
	/*
	 * We add some JavaScript to pages with the comment form
	 * to support sites with threaded comments (when in use).
	 */
if ( is_singular() && get_option( 'thread_comments' ) ) {
	wp_enqueue_script( 'comment-reply' );
}

	/*
	 * Always have wp_head() just before the closing </head>
	 * tag of your theme, or you will break many plugins, which
	 * generally use this hook to add elements to <head> such
	 * as styles, scripts, and meta tags.
	 */
	wp_head();

?>


<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css" media="screen">	
<link href="<?php echo get_template_directory_uri(); ?>/css/animate.css" rel="stylesheet">
<link href="<?php echo get_template_directory_uri(); ?>/css/main.css" rel="stylesheet">
<link href="<?php echo get_template_directory_uri(); ?>/css/component.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/ionicons.css">
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/Pe-icon-7-stroke.css"> 
<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css"> 
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/lozad/dist/lozad.min.js"></script>
<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/style.css" media="screen">	
<style>
.custom-header{
    padding: 15px 50px 15px 50px;
   
}
.custom-header-inner{
    display: grid;
    grid-template-columns: 120px 1fr 155px 180px;
    gap: 30px;
    align-items: center;
}

/*****************/
.navbar-sticky .custom-header{

background: #04211D;

}


/**************/
.header-button{

}

.header-button  a{
    background: #BED630;
    color: #fff;
    padding: 8px 10px;
    -webkit-border-radius: 6px;
    -moz-border-radius: 6px;
    border-radius: 6px;
    border: 2px solid #BED630;
}

.header-button  a:hover{
background: #0000;
color: #fff;
border: 2px solid #fff;
}
.header-phone{

}
.header-phone a{
    color: #fff;
}


.phone-num{
	background: url(<?php echo get_template_directory_uri(); ?>/images/phone-i.svg);
	    background-size: 19px;
    background-repeat: no-repeat;
    padding-left: 25px;
}
.whatsapp-num{
background: url(<?php echo get_template_directory_uri(); ?>/images/whatsapp-i.svg);
    background-size: 19px;
    background-repeat: no-repeat;
    padding-left: 25px;
}
/************/

.round-conner-20{
    -webkit-border-radius: 20px;
-moz-border-radius: 20px;
border-radius: 20px;
}

/************/
.custom-button{
    padding: 8px 10px;
    -webkit-border-radius: 6px;
    -moz-border-radius: 6px;
    border-radius: 6px;
}
.light-green-button{
    background: #BED630;
    color: #fff;
}
.dark-green-button{
 background: #04211D;
    color: #fff;
}
.white-line-button{
    background: #0000;
    color: #fff;
}

.light-green-button:hover{
 background: #04211D;
    color: #fff;
}

.dark-green-button:hover{
  background: #BED630;
    color: #04211D;
}

/*************/

.dark-green-text{
color: #04211D;
}
.light-green-text{
color: #BED630;
}
.white-text{
    color: #fff;
}

/************/
.section-header{
font-size: 45px;
font-weight: 700;
}

.section-header-text{

}
/*************/
.navbar-nav{
    float: right;
}

.navbar-nav > li > a{
    position: relative;
}

.navbar-nav > li > a:hover::before {
    transform-origin: left;
    transform: scaleX(1);
}

.navbar-nav > li > a:before {
    content: '';
    position: absolute;
    width: 100%;
    height: 2px;
    border-radius: 4px;
    background-color: #BED630;
    bottom: 0;
    left: 0;
    transform-origin: right;
    transform: scaleX(0);
    transition: transform .3s ease-in-out;
}
.navbar-nav li ul{
 border-top: 0px solid #B68D03;
    background: #BED630;
    -webkit-box-shadow: 0px 7px 16px -1px rgba(0, 0, 0, 0.44);
    -moz-box-shadow: 0px 7px 16px -1px rgba(0, 0, 0, 0.44);
    box-shadow: 0px 7px 16px -1px rgba(0, 0, 0, 0.44);
}
/*******************/
.slick-prev, .slick-next{
    background: #BED630;
    color: #fff;
    -webkit-border-radius:100%;
-moz-border-radius: 100%;
border-radius: 100%;
    line-height: 1;
}
.slick-prev:before, .slick-next:before {
    opacity: 1;
    color: #ffffff;
}
.slick-prev:hover, .slick-prev:focus, .slick-next:hover, .slick-next:focus {
     background: #04211D;
    color: #fff;
}

/*******************/
@media screen and (max-width: 1200px) {

}

@media screen and (max-width: 1100px) {

}

@media screen and (max-width: 1000px) {
.custom-header-inner {
    grid-template-columns: 120px 1fr;
}
.header-phone{
    display: none;
}
.header-button{
    display: none;
}
.slick-prev {
    left: 0;
}
.slick-next {
    right: 0;
}

}
@media screen and (max-width: 990px) {

}
@media screen and (max-width: 850px) {
.custom-header {
    padding: 15px 20px 15px 20px;
}
}
@media screen and (max-width: 767px) {
.slider-text {
    position: absolute;
    width: 90%;
    margin: 0 auto;
}
}
@media screen and (max-width: 650px) {


}
@media screen and (max-width: 550px) {
.section-header {
    font-size: 31px;
    font-weight: 700;
}


}
@media screen and (max-width: 390px) {

}

</style>
    
<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-MC5BF7NPM9"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-MC5BF7NPM9');
</script>

    
    
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<!-- start Container Wrapper -->
<div class="container-wrapper">



    <!-- start Header -->
        <header id="header">
                            
            <nav class="navbar navbar-primary navbar-fixed-top ">
            
            
                    <div class="custom-header">                        
                        <div class="custom-header-inner">     
                                                                                          
                            <div class="header-logo">                                
                               <a href="<?php echo home_url(); ?>/">
                                <img   src="<?php echo get_template_directory_uri(); ?>/images/logo-c.svg" class="logo-white">
                                </a>                             
                            </div>
                           
                            <div class="header-menu">
                                 <?php
                wp_nav_menu(
                    array(
                        'container_class' => 'collapse navbar-collapse navbar-arrow',
                         'container_id' => 'navbar',
                         'menu_class' => 'nav navbar-nav',
                         'menu_id' => 'responsive-menu',
                        'theme_location'  => 'primary',
                    )
                );
                ?>
                            </div>    


                            <div class="header-phone"> 
                                <a href="tel:+94912222267" title="+94912222267" class="phone-num">+94 91 222 2267</a>
                     			<a href="https://wa.me/94773497658" title="94773497658" class="whatsapp-num">+94 77 349 7658</a>
                            </div>
                            <div class="header-button">
                                <a href="<?php echo home_url(); ?>/tailor-made/" title="Plan Your Tour">Tailor Made Tour</a>
                            </div>

                         
                            
                        </div>
                       
                    </div> 
                    <div id="slicknav-mobile"></div>                                      
            </nav>
  
        </header>
  
  
    
    
    <div class="clear"></div>
        
        <!-- start Main Wrapper -->
        <div class="main-wrapper">