<?php
/**
 * Template Name: Destinations Page
*/
get_header(); 
include get_theme_file_path( 'header-widget.php' ); 
?>
<style type="text/css">
	.destination-home{
		display: grid;
		grid-template-columns: 1fr 1fr;
		gap: 40px;
	}

.destination--col{}

.destination--col--inner{
	display: grid;
grid-template-columns: 1fr 1fr;
gap: 20px;
align-items: center;
}

.destination--img-cover{
	overflow: hidden;
	position: relative;
}
.destination--img{
		width:100%;
  background:url() 50% 50% no-repeat;
  background-size:cover;
  background-clip:content-box; 
    position:relative;

        /* Initial scale */
    transform: scale(1.2);
    /* Combined transitions for box-shadow and transform */
    transition: transform 1s, visibility 1s ease-in;

}

.destination--img:before{
     display:block;
     content:"";
    padding-top:160%;
}

.destination--content{

}
.destination--title{
	    font-size: 24px;
    font-weight: 700;
    margin-bottom: 15px;
}

.destination--img-bg{

    position: absolute;
    width: 100%;
    height: 100%;
    z-index: 1;
    opacity: 0;
      transition: opacity 2s ease;
}
/*******Hover********/
.destination--col:hover .destination--img{
  transform: scale(1);
}
.destination--col:hover .destination--img-bg{
opacity: 1;
}

/************/
.Dtab{
	display: flex;
    justify-content: center;
    gap: 20px;

}
.Dtablinks{
	border: 0;
	background: #0000;
	outline: 0;
	position: relative;
}

.Dtablinks.active::before {
    transform-origin: left;
    transform: scaleX(1);
}

.Dtablinks::before{
    content: '';
    position: absolute;
    width: 100%;
    height: 2px;
    border-radius: 4px;
    background-color: #BED630;
    bottom: 0;
    left: 0;
    transform-origin: right;
    transform: scaleX(0);
    transition: transform .3s ease-in-out;
}


.Dtablinks:hover::before {
  transform-origin: left;
  transform: scaleX(1);
}


/*******************/
@media screen and (max-width: 800px) {
	.destination-home{
		display: grid;
		grid-template-columns: 1fr;
		gap: 40px;
	}

}


@media screen and (max-width: 560px) {
.destination--col--inner{
display: grid;
grid-template-columns: 1fr;
gap: 20px;
align-items: center;
}

.destination--img:before {
    display: block;
    content: "";
    padding-top: 100%;
}

.Dtab{
	display: grid;
    justify-content: center;
    gap: 20px;

}


}

</style>
<section>
	<div class="container">
		<div class="row pb-60">
			<div class="col-sm-12 text-center">
				<?php the_content(); ?>
			</div>
		</div>

		<div class="row pb-60">
			<div class="col-sm-12">
 
<div class="Dtab">
  <button class="Dtablinks" onclick="openCity(event, 'D1')" id="defaultOpenD">Beach</button>
  <button class="Dtablinks" onclick="openCity(event, 'D2')">Nature and Wildlife</button>
  <button class="Dtablinks" onclick="openCity(event, 'D3')">Heritage</button>
  <button class="Dtablinks" onclick="openCity(event, 'D4')">Eco Adventures</button>
</div>

			</div>
		</div>			

		<div class="row">
			<div class="col-sm-12">

<!---->
<div class="Dtabcontent" id="D1">
<div class="destination-home">
					
<?php 
$z = 1;
$args = array( 'post_type' => 'destination', 'posts_per_page' => 100 , 'orderby' =>'menu_order',
'meta_key'      => 'destination_options',
'meta_value'    => 'beach'
);
$the_query = new WP_Query( $args ); 
 if ( $the_query->have_posts() ) {
 while ( $the_query->have_posts() ) { $the_query->the_post(); 

$destination_front_image = get_field("destination_front_image");
if(!empty($destination_front_image )){ 
$destination_front_image = $destination_front_image;
 }else{ 
$destination_front_image = get_template_directory_uri().'/images/s3-lg.jpg';
 } ?>



					<div class="destination--col">
						<div class="destination--col--inner">
						<div class="destination--img-cover round-conner-20">
						<div class="destination--img-bg round-conner-20"></div>	
						<div class="destination--img lozad round-conner-20"  data-background-image="<?php echo $destination_front_image; ?>">						
						</div>
						</div>
						<div class="destination--content">
							<div class="destination--title"><?php the_title(); ?></div>
							<div class="destination--text"><?php the_content(); ?></div>
						</div>
						</div>
					</div>
<?php $z = ++$z; } wp_reset_postdata(); ?>
<?php }else{  ?>
<p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
<?php } ?> 


				</div>
			</div>
<!---->
<!---->
<div class="Dtabcontent" id="D2">
<div class="destination-home">
					
<?php 
$z = 1;
$args = array( 'post_type' => 'destination', 'posts_per_page' => 100 , 'orderby' =>'menu_order',
'meta_key'      => 'destination_options',
'meta_value'    => 'wildlife'
);
$the_query = new WP_Query( $args ); 
 if ( $the_query->have_posts() ) {
 while ( $the_query->have_posts() ) { $the_query->the_post(); 

$destination_front_image = get_field("destination_front_image");
if(!empty($destination_front_image )){ 
$destination_front_image = $destination_front_image;
 }else{ 
$destination_front_image = get_template_directory_uri().'/images/s3-lg.jpg';
 } ?>



					<div class="destination--col">
						<div class="destination--col--inner">
						<div class="destination--img-cover round-conner-20">
						<div class="destination--img-bg round-conner-20"></div>	
						<div class="destination--img lozad round-conner-20"  data-background-image="<?php echo $destination_front_image; ?>">						
						</div>
						</div>
						<div class="destination--content">
							<div class="destination--title"><?php the_title(); ?></div>
							<div class="destination--text"><?php the_content(); ?></div>
						</div>
						</div>
					</div>
<?php $z = ++$z; } wp_reset_postdata(); ?>
<?php }else{  ?>
<p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
<?php } ?> 


				</div>
			</div>
<!---->

<!---->
<div class="Dtabcontent" id="D3">
<div class="destination-home">
					
<?php 
$z = 1;
$args = array( 'post_type' => 'destination', 'posts_per_page' => 100 , 'orderby' =>'menu_order',
'meta_key'      => 'destination_options',
'meta_value'    => 'heritage'
);
$the_query = new WP_Query( $args ); 
 if ( $the_query->have_posts() ) {
 while ( $the_query->have_posts() ) { $the_query->the_post(); 

$destination_front_image = get_field("destination_front_image");
if(!empty($destination_front_image )){ 
$destination_front_image = $destination_front_image;
 }else{ 
$destination_front_image = get_template_directory_uri().'/images/s3-lg.jpg';
 } ?>



					<div class="destination--col">
						<div class="destination--col--inner">
						<div class="destination--img-cover round-conner-20">
						<div class="destination--img-bg round-conner-20"></div>	
						<div class="destination--img lozad round-conner-20"  data-background-image="<?php echo $destination_front_image; ?>">						
						</div>
						</div>
						<div class="destination--content">
							<div class="destination--title"><?php the_title(); ?></div>
							<div class="destination--text"><?php the_content(); ?></div>
						</div>
						</div>
					</div>
<?php $z = ++$z; } wp_reset_postdata(); ?>
<?php }else{  ?>
<p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
<?php } ?> 


				</div>
			</div>
<!---->
<!---->
<div class="Dtabcontent" id="D4">
<div class="destination-home">
					
<?php 
$z = 1;
$args = array( 'post_type' => 'destination', 'posts_per_page' => 100 , 'orderby' =>'menu_order',
'meta_key'      => 'destination_options',
'meta_value'    => 'eco'
);
$the_query = new WP_Query( $args ); 
 if ( $the_query->have_posts() ) {
 while ( $the_query->have_posts() ) { $the_query->the_post(); 

$destination_front_image = get_field("destination_front_image");
if(!empty($destination_front_image )){ 
$destination_front_image = $destination_front_image;
 }else{ 
$destination_front_image = get_template_directory_uri().'/images/s3-lg.jpg';
 } ?>



					<div class="destination--col">
						<div class="destination--col--inner">
						<div class="destination--img-cover round-conner-20">
						<div class="destination--img-bg round-conner-20"></div>	
						<div class="destination--img lozad round-conner-20"  data-background-image="<?php echo $destination_front_image; ?>">						
						</div>
						</div>
						<div class="destination--content">
							<div class="destination--title"><?php the_title(); ?></div>
							<div class="destination--text"><?php the_content(); ?></div>
						</div>
						</div>
					</div>
<?php $z = ++$z; } wp_reset_postdata(); ?>
<?php }else{  ?>
<p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
<?php } ?> 


				</div>
			</div>
<!---->


		</div>

	</div>


</div>
</section>

<script>
function openCity(evt, cityName) {
  var i, tabcontent, tablinks;
  tabcontent = document.getElementsByClassName("Dtabcontent");
  for (i = 0; i < tabcontent.length; i++) {
    tabcontent[i].style.display = "none";
  }
  tablinks = document.getElementsByClassName("Dtablinks");
  for (i = 0; i < tablinks.length; i++) {
    tablinks[i].className = tablinks[i].className.replace(" active", "");
  }
  document.getElementById(cityName).style.display = "block";
  evt.currentTarget.className += " active";
}

// Get the element with id="defaultOpen" and click on it
document.getElementById("defaultOpenD").click();
</script>
<?php get_footer(); ?>