<?php
/**
 * Template Name: Day Tours Page
*/
get_header(); 
include get_theme_file_path( 'header-widget.php' ); 
?>

<style type="text/css">
	

/************/
.Dtab{
	display: flex;
    justify-content: center;
    gap: 20px;

}
.Dtablinks{
	border: 0;
	background: #0000;
	outline: 0;
	position: relative;
}

.Dtablinks.active::before {
    transform-origin: left;
    transform: scaleX(1);
}

.Dtablinks::before{
    content: '';
    position: absolute;
    width: 100%;
    height: 2px;
    border-radius: 4px;
    background-color: #BED630;
    bottom: 0;
    left: 0;
    transform-origin: right;
    transform: scaleX(0);
    transition: transform .3s ease-in-out;
}


.Dtablinks:hover::before {
  transform-origin: left;
  transform: scaleX(1);
}

/******/
/******/

.daytours-home{
		display: grid;
		grid-template-columns: 1fr 1fr;
		gap: 40px;
	}

.daytour--col{}

.daytour--col--inner{
	display: grid;
grid-template-columns: 1fr 1fr;
gap: 20px;
align-items: center;
}

.daytour--img-cover{
	overflow: hidden;
	position: relative;
}
.daytour--img{
		width:100%;
  background:url() 50% 50% no-repeat;
  background-size:cover;
  background-clip:content-box; 
    position:relative;

        /* Initial scale */
    transform: scale(1.2);
    /* Combined transitions for box-shadow and transform */
    transition: transform 1s, visibility 1s ease-in;

}

.daytour--img:before{
     display:block;
     content:"";
    padding-top:160%;
}

.daytour--content{

}
.daytour--title{
	    font-size: 24px;
    font-weight: 700;
    margin-bottom: 15px;
}

.daytour--img-bg{

    position: absolute;
    width: 100%;
    height: 100%;
    z-index: 1;
    opacity: 0;
      transition: opacity 2s ease;
}

.daytour--button{
	padding-top: 15px;
}
/*******Hover********/
.daytour--col:hover .daytour--img{
  transform: scale(1);
}
.daytour--col:hover .daytour--img-bg{
opacity: 1;
}


/*******************/
@media screen and (max-width: 800px) {
.daytours-home{
		display: grid;
		grid-template-columns: 1fr;
		gap: 40px;
	}

}


@media screen and (max-width: 560px) {
.daytour--col--inner{
display: grid;
grid-template-columns: 1fr;
gap: 20px;
align-items: center;
}

.daytour--img:before {
    display: block;
    content: "";
    padding-top: 100%;
}

.Dtab{
	display: grid;
    justify-content: center;
    gap: 20px;

}


}

</style>
<section>
	<div class="container">
		<div class="row pb-50 text-center">
			<div class="col-sm-12">
				<?php the_content(); ?>	
			</div>
		</div>
		<div class="row pb-50">
			<div class="col-sm-12">
				<div class="Dtab">
  <button class="Dtablinks" onclick="openCity(event, 'D1')" id="defaultOpenD">Coastal Getaways </button>
  <button class="Dtablinks" onclick="openCity(event, 'D2')">Adventure Escapes</button>
  <button class="Dtablinks" onclick="openCity(event, 'D3')">Cultural Vistas</button>
</div>
			</div>
		</div>	

		<div class="row">
			<div class="col-sm-12">

			
<!---->
<!---->			
<div class="Dtabcontent" id="D1">
<div class="daytours-home">

<?php 
$z = 1;
$args = array( 'post_type' => 'day-tour', 'posts_per_page' => 20 , 'orderby' =>'menu_order' ,
'meta_key'      => 'daytour_options',
'meta_value'    => 'coastal_getaways'
);
$the_query = new WP_Query( $args ); 
if ( $the_query->have_posts() ) {
while ( $the_query->have_posts() ) { $the_query->the_post(); 


$day_tour_front_image = get_field("day_tour_front_image");
if(!empty($day_tour_front_image )){ 
$day_tour_front_image = $day_tour_front_image;
 }else{ 
$day_tour_front_image = get_template_directory_uri().'/images/s3-lg.jpg';

}
 
 ?>
<div class="daytour--col">
						<div class="daytour--col--inner">
						<div class="daytour--img-cover round-conner-20">						
						<div class="daytour--img-bg round-conner-20"></div>	
						<div class="daytour--img lozad round-conner-20"  data-background-image="<?php echo $day_tour_front_image; ?>">						
						</div>
						</div>
						<div class="daytour--content">
							<div class="daytour--title"><?php the_title(); ?></div>
							<div class="daytour--text"><?php
                                $char_limit = 150;
                                $content = get_field("day_tours_short");                              
                                echo substr(strip_tags($content), 0, $char_limit) . '....';
                                ?></div>
							<div class="daytour--button"><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="custom-button dark-green-button">View Day Tour</a></div>
						</div>
						</div>
					</div>
<?php $z = ++$z; } wp_reset_postdata(); ?>
<?php }else{  ?>
<p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
<?php } ?> 
</div>
</div>
<!---->
<!---->
		
<!---->
<!---->			
<div class="Dtabcontent" id="D2">
<div class="daytours-home">

<?php 
$z = 1;
$args = array( 'post_type' => 'day-tour', 'posts_per_page' => 20 , 'orderby' =>'menu_order' ,
'meta_key'      => 'daytour_options',
'meta_value'    => 'adventure_escapes'
);
$the_query = new WP_Query( $args ); 
if ( $the_query->have_posts() ) {
while ( $the_query->have_posts() ) { $the_query->the_post(); 


$day_tour_front_image = get_field("day_tour_front_image");
if(!empty($day_tour_front_image )){ 
$day_tour_front_image = $day_tour_front_image;
 }else{ 
$day_tour_front_image = get_template_directory_uri().'/images/s3-lg.jpg';

}
 
 ?>
<div class="daytour--col">
						<div class="daytour--col--inner">
						<div class="daytour--img-cover round-conner-20">						
						<div class="daytour--img-bg round-conner-20"></div>	
						<div class="daytour--img lozad round-conner-20"  data-background-image="<?php echo $day_tour_front_image; ?>">						
						</div>
						</div>
						<div class="daytour--content">
							<div class="daytour--title"><?php the_title(); ?></div>
							<div class="daytour--text"><?php
                                $char_limit = 150;
                                $content    = $post->post_content;
                                echo substr(strip_tags($content), 0, $char_limit) . '....';
                                ?></div>
							<div class="daytour--button"><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="custom-button dark-green-button">View Day Tour</a></div>
						</div>
						</div>
					</div>
<?php $z = ++$z; } wp_reset_postdata(); ?>
<?php }else{  ?>
<p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
<?php } ?> 
</div>
</div>
<!---->
<!---->
		
<!---->
<!---->			
<div class="Dtabcontent" id="D3">
<div class="daytours-home">

<?php 
$z = 1;
$args = array( 'post_type' => 'day-tour', 'posts_per_page' => 20 , 'orderby' =>'menu_order' ,
'meta_key'      => 'daytour_options',
'meta_value'    => 'cultural_vistas'
);
$the_query = new WP_Query( $args ); 
if ( $the_query->have_posts() ) {
while ( $the_query->have_posts() ) { $the_query->the_post(); 


$day_tour_front_image = get_field("day_tour_front_image");
if(!empty($day_tour_front_image )){ 
$day_tour_front_image = $day_tour_front_image;
 }else{ 
$day_tour_front_image = get_template_directory_uri().'/images/s3-lg.jpg';

}
 
 ?>
<div class="daytour--col">
						<div class="daytour--col--inner">
						<div class="daytour--img-cover round-conner-20">						
						<div class="daytour--img-bg round-conner-20"></div>	
						<div class="daytour--img lozad round-conner-20"  data-background-image="<?php echo $day_tour_front_image; ?>">						
						</div>
						</div>
						<div class="daytour--content">
							<div class="daytour--title"><?php the_title(); ?></div>
							<div class="daytour--text"><?php
                                $char_limit = 150;
                                $content    = $post->post_content;
                                echo substr(strip_tags($content), 0, $char_limit) . '....';
                                ?></div>
							<div class="daytour--button"><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="custom-button dark-green-button">View Day Tour</a></div>
						</div>
						</div>
					</div>
<?php $z = ++$z; } wp_reset_postdata(); ?>
<?php }else{  ?>
<p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
<?php } ?> 
</div>
</div>
<!---->
<!---->


			</div>
		</div>		

	</div>	
</section>

<script>
function openCity(evt, cityName) {
  var i, tabcontent, tablinks;
  tabcontent = document.getElementsByClassName("Dtabcontent");
  for (i = 0; i < tabcontent.length; i++) {
    tabcontent[i].style.display = "none";
  }
  tablinks = document.getElementsByClassName("Dtablinks");
  for (i = 0; i < tablinks.length; i++) {
    tablinks[i].className = tablinks[i].className.replace(" active", "");
  }
  document.getElementById(cityName).style.display = "block";
  evt.currentTarget.className += " active";
}

// Get the element with id="defaultOpen" and click on it
document.getElementById("defaultOpenD").click();
</script>


<?php get_footer(); ?>