<?php
// Template Name: Strengths
?>

<?php 
    get_header(); 
    include get_theme_file_path('header-banner.php');
?>

<style>
    .strengths--section {
        padding: 4% 20%;
        width: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        position: relative;
        background: #FFF;
    }
	
    .strengths--section-inner {
        text-align: center;
        width: 100%;
        position: relative;
    }

    .strengths--section-inner-text-container {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        justify-content: center;
        text-align: left;
        gap: 10px;
        position: relative;
    }

    .strengths--section-inner-content-container {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        margin-top: 30px;
        position: relative;
    }

    .strengths--section-inner-content-container-slider-wrapper-1 {
        width: 100%;
        position: relative;
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 20px;
    }

    .strengths--section-inner-content-container-slider-wrapper-single-slide {
        border: 1px solid #00D6C9;
        border-radius: 15px;
        padding: 20px;
    }

    .strengths--section-inner-content-container-slider-wrapper-single-slide-inner {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        text-align: center;
        gap: 15px;
    }

    .strengths--section-inner-content-container-slider-wrapper-single-slide-inner-title {
        font-weight: 400;
        font-size: clamp(15px, 2vw, 24px); /* min 15px, fluid, max 24px */
        line-height: 100%;
        color: #00D6C9;
    }

    .strengths--section-inner-content-container-slider-wrapper-single-slide-inner-description {
        font-weight: 400;
        font-size: clamp(12.5px, 1.5vw, 16px); /* min 12.5px, fluid, max 16px */
        line-height: 150%;
        color: #1E1E1E;
    }


    @media (max-width: 1600px) {
        .strengths--section {
            padding: 4% 18%;
        }
    } 

    @media (max-width: 1400px) {
        .strengths--section {
            padding: 4% 15%;
        }
    }

    @media (max-width: 1200px) {
        .strengths--section {
            padding: 4% 10%;
        }
    }

    @media (max-width: 650px) {
        .strengths--section-inner-content-container-slider-wrapper-1 {
            grid-template-columns: 1fr;
        }
    }
</style>

<section class="strengths--section">
    <div class="strengths--section-inner">
        <div class="strengths--section-inner-content-container">
            <div class="strengths--section-inner-content-container-slider-wrapper-1">
                <?php 
                    $args = array( 
                        'post_type' => 'strength',
                        'posts_per_page' => 100 , 
                        'orderby' =>'menu_order' ,
                    );

                    $count = 0;

                    $the_query = new WP_Query( $args ); 

                        if ( $the_query->have_posts() ) {
                            while ( $the_query->have_posts() ) { 
                                $the_query->the_post(); 
                                $count++;
                ?>
                    <div class="strengths--section-inner-content-container-slider-wrapper-single-slide" data-aos="zoom-in">
                        <div class="strengths--section-inner-content-container-slider-wrapper-single-slide-inner">
                            <div class="strengths--section-inner-content-container-slider-wrapper-single-slide-inner-title"><?php the_title(); ?></div>

                            <div class="strengths--section-inner-content-container-slider-wrapper-single-slide-inner-description">
                                <?php the_content(); ?>
                            </div>
                        </div>
                    </div>
                <?php
                    }
                        wp_reset_postdata();
                    } else {
                        echo '<p class="description-font-family black-font">No content to display</p>';
                    }
                ?>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>
