<?php
// Template Name: Products Range
?>

<?php 
    get_header(); 
    include get_theme_file_path('header-banner.php');
?>

<style>
    .featured--products--section {
        padding: 4% 20%;
        width: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        position: relative;
        background: #F6F9FF;
        border-bottom: 2px solid;
        border-image-source: linear-gradient(270deg, rgba(255, 255, 255, 0) 0%, #00D6C9 50.48%, rgba(255, 255, 255, 0) 100%);
        border-image-slice: 1;
        border-image-repeat: stretch;
    }
	
    .featured--products--section-inner {
        text-align: center;
        width: 100%;
        position: relative;
    }

    .featured--products--section-inner-text-container {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        text-align: center;
        gap: 10px;
        position: relative;
    }

    .featured--products--section-inner-content-container {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        margin-top: 30px;
        position: relative;
        padding-bottom: 3%;
    }

    .featured--products--section-inner-content-container-slider-wrapper-1 {
        width: 100%;
        position: relative;
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 20px;
    }

    .featured--products--section-inner-content-container-slider-wrapper .slick-dots {
        position: absolute;
        bottom: -10%;
        display: block;
        width: 100%;
        padding: 0;
        margin: 0;
        list-style: none;
        text-align: center;
    }

    .featured--products--section-inner-content-container-slider-wrapper-single-slide {
        position: relative;
    }

    .featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-wrapper {
        position: relative;
        width: 100%;
        display: flex;
        flex-direction: column;
    }

    .featured--products--section-inner-content-container-slider-wrapper .slick-dots li.slick-active button:before {
        opacity: 1;
        color: #0D1B39;
    }

    .featured--products--section-inner-content-container-slider-wrapper .slick-dots li button:before {
        font-family: slick;
        font-size: 10px;
        line-height: 20px;
        position: absolute;
        top: 0;
        left: 0;
        width: 20px;
        height: 20px;
        content: '•';
        text-align: center;
        opacity: .25;
        color: #000;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
    }

    .featured--products--section-inner-content-container-slider-wrapper .slick-next, 
    .featured--products--section-inner-content-container-slider-wrapper .slick-prev {
        width: 30px;
        height: 30px;
        position: absolute;
        top: 102%;
        z-index: 50;
    }

    .featured--products--section-inner-content-container-slider-wrapper .slick-next::before, 
    .featured--products--section-inner-content-container-slider-wrapper .slick-prev::before {
        font-size: 0;
    }

    .featured--products--section-inner-content-container-slider-wrapper .slick-prev {
        background: url('<?php echo get_template_directory_uri(); ?>/icons/prev.svg');
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        left: 45%;
        background-color: #fff;
        box-shadow: 0px 4px 23.2px 0px #00000012;
        padding: 10px;
    }

    .featured--products--section-inner-content-container-slider-wrapper .slick-next {
        background: url('<?php echo get_template_directory_uri(); ?>/icons/next.svg');
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        right: 45%;
        background-color: #fff;
        box-shadow: 0px 4px 23.2px 0px #00000012;
        padding: 10px;
    }

    .featured--products--section-inner-content-container-slider-wrapper-single-slide-inner {
        position: relative;
    }

    .featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-image-container {
        position: relative;
        z-index: 1;
        width: 100%;
        height: 350px;
        border-radius: 5px;
    }

    .featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-image-container img {
        width: 100%;
        height: 90%;
        object-fit: cover;
        object-position: center;
        border-radius: 5px;
    }

    .featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-text-container-wrapper {
        width: 100%;
        position: absolute;
        z-index: 2;
        bottom: 0;
        padding: 0% 10%;
    }

    .featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-text-container {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 10px 15px;
        border-radius: 5px;
        background: #fff;
    }

    .featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-text-container-title {
        font-weight: 400;
        color: #0D1B39;
    }

    @media (max-width: 1600px) {
        .featured--products--section {
            padding: 4% 18%;
        }
    } 

    @media (max-width: 1400px) {
        .featured--products--section {
            padding: 4% 15%;
        }
    }

    @media (max-width: 1200px) {
        .featured--products--section {
            padding: 4% 10%;
        }
    }

    @media (max-width: 1100px) {
        .featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-text-container {
            padding: 8px;
        }
    }

    @media (max-width: 992px) {
        .featured--products--section {
            padding: 4% 5%;
        }
    }

    @media (max-width: 900px) {
        .featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-text-container {
            padding: 15px;
        }

        .featured--products--section-inner-content-container-slider-wrapper-1 {
            grid-template-columns: 1fr;
        }
    }

    /*  */
    .popup-overlay {
        display: none;
        position: fixed;
        top: 0; left: 0;
        width: 100%; height: 100%;
        background: rgba(0,0,0,0.7);
        justify-content: center;
        align-items: center;
        z-index: 9999;
    }

    .popup-content {
        background: #fff;
        padding: 30px;
        border-radius: 10px;
        max-width: 600px;
        width: 90%;
        text-align: left;
        position: relative;
    }

    .popup-close {
        position: absolute;
        right: 15px; top: 10px;
        font-size: 24px;
        cursor: pointer;
    }

    .popup-inner img {
        border-radius: 6px;
        display: block;
    }
</style>

<section class="featured--products--section">
    <div class="featured--products--section-inner">       

        <div class="featured--products--section-inner-content-container">
            <div class="featured--products--section-inner-content-container-slider-wrapper-1">
                <?php 
                $args = array( 
                    'post_type' => 'featured-product',
                    'posts_per_page' => 100 , 
                    'orderby' =>'menu_order' ,
                );

                $the_query = new WP_Query( $args ); 
                $count = 0;

                if ( $the_query->have_posts() ) {
                    while ( $the_query->have_posts() ) { 
                        $the_query->the_post(); 
                        $count++;

                        $front_image = get_field('featured_product_image');
                        if(empty($front_image)) {
                            $front_image = get_template_directory_uri().'/images/products.jpg';
                        } else {
                            $front_image = $front_image;
                        }
                ?>
                <div class="featured--products--section-inner-content-container-slider-wrapper-single-slide" data-aos="zoom-in">
                    <div class="featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-wrapper">
                        <div class="featured--products--section-inner-content-container-slider-wrapper-single-slide-inner">
                            <div class="featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-image-container">
                                <img src="<?php echo $front_image; ?>" alt="">
                            </div>

                            <div class="featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-text-container-wrapper">
                                <div class="featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-text-container">
                                    <div class="featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-text-container-title font-1"><?php the_title(); ?></div>
                                    <a href="javascript:void(0);" 
                                    class="section-button-yellow open-popup" 
                                    data-title="<?php echo esc_attr(get_the_title()); ?>" 
                                    data-content="<?php echo esc_attr(wp_kses_post(get_the_content())); ?>" 
                                    data-image="<?php echo esc_url($front_image); ?>">
                                    More Info
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php   
                    }                   
                        wp_reset_postdata();
                    } else {
                        echo '<p class="description-font-family black-font">No content to display</p>';
                    }
                ?>
            </div>
        </div>

        <div id="product-popup" class="popup-overlay">
            <div class="popup-content">
                <span class="popup-close">&times;</span>
                <div class="popup-inner">
                <img id="popup-image" src="" alt="" style="max-width:100%; margin-bottom:15px;">
                <h2 id="popup-title"></h2>
                <div id="popup-body"></div>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        const buttons = document.querySelectorAll(".open-popup");
        const popup = document.getElementById("product-popup");
        const popupTitle = document.getElementById("popup-title");
        const popupBody = document.getElementById("popup-body");
        const popupImage = document.getElementById("popup-image");
        const popupClose = document.querySelector(".popup-close");

        buttons.forEach(btn => {
            btn.addEventListener("click", function() {
                const title = this.getAttribute("data-title");
                const content = this.getAttribute("data-content");
                const image = this.getAttribute("data-image");

                popupTitle.innerHTML = title;
                popupBody.innerHTML = content;
                popupImage.src = image;

                popup.style.display = "flex";
            });
        });

        popupClose.addEventListener("click", function() {
            popup.style.display = "none";
        });

        popup.addEventListener("click", function(e) {
            if(e.target === popup) {
                popup.style.display = "none";
            }
        });
    });
</script>

<?php get_footer(); ?>