<?php
// Template Name: Home
?>

<?php get_header(); ?>

<style>
    .header-banner {
        overflow: hidden;
        align-items: center;
        height: 100vh;
        display: flex;
        justify-content: center;
        flex-direction: column;
        position: relative;
        z-index: 99;
        text-align: center;
        background: 
            linear-gradient(180deg, rgba(255,255,255,0) 70%, #ffffff 100%),
            url('<?php echo get_template_directory_uri(); ?>/images/home.jpg');
        background-position: center;
        background-repeat: no-repeat;
        background-size: cover;
        background-attachment: fixed;
    }

    .banner-heading {
        text-align: left;
        display: flex;
        justify-content: center;
        align-items: flex-start;
        flex-direction: column;
        gap: 20px;
        width: 100%;
        height: 100%;
        padding-inline: 20%;
    }

    .banner-heading .title {
        font-weight: 500;
        font-size: 40px;
        line-height: 130%;
        color: #fff;
    }

    .banner-heading .description {
        font-weight: 400;
        line-height: 130%;
        color: #fff;
    }

    .header-banner .logo {
        height: 195px;
        width: 195px;
    }

    .header-banner .logo img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        object-position: center;
    }

    .home-bottom-bg {
        position: absolute;
        top: 22%;
        width: 100%;
        z-index: 25;
    }

    .home-bottom-bg img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        object-position: center;
    }

    @media (max-width: 1600px) {
        .banner-heading {
            padding-inline: 18%;
        }
    }

    @media (max-width: 1500px) {
        .banner-heading .title {
            font-size: 36px;
        }
    }

    @media (max-width: 1400px) {
        .banner-heading {
            padding-inline: 15%;
        }
    }

    @media (max-width: 1379px) {
        .home-title {
            font-size: 55px;
        }
    }

    @media (max-width: 1200px) {
        .header-banner .logo {
            height: 165px;
            width: 165px;
        }

        .banner-heading {
            padding-inline: 10%;
        }

        .banner-heading .title {
            font-size: 32px;
        }
    }

    @media (max-width: 992px) {
        .banner-heading {
            text-align: center;
            display: flex;
            justify-content: center;
            align-items: center;
            flex-direction: column;
            gap: 20px;
            width: 100%;
            padding-inline: 10%;
        }

        .banner-heading .title {
            font-size: 28px;
        }

        .header-banner .logo {
            height: 95px;
            width: 95px;
        }

        .header-banner {
            height: 80vh;
        }
    }

    @media (max-width: 768px) {
        .header-banner .logo {
            height: 65px;
            width: 65px;
        }

        .banner-heading .title {
            font-size: 24px;
        }
    }

    @media (max-width: 580px) {
        .header-banner {
            background-attachment: scroll;
        }

        .header-banner .logo {
            height: 45px;
            width: 45px;
        }
    }

    @media (max-width: 575px) {
        .banner-heading .title {
            font-size: 20px;
        }
    }

    @media (max-width: 480px) {
        .header-banner .logo {
            height: 30px;
        }

        .banner-heading .title {
            font-size: 18px;
        }

        .header-banner {
            height: 60vh;
        }
    }

    @media (max-width: 420px) {
        .header-banner .logo {
            height: 25px;
            width: 25px;
        }
    }
</style>

<div class="header-banner">

    <div class="black-bg"></div>

    <div class="banner-heading">
        <div class="title" data-aos="fade-down">
            Your One-Stop Partner for Premium Resort & Hotel Supplies
        </div>

        <div class="description font-1">
            CeyPearl Exim, based in Sri Lanka, is a leading one-stop supplier for the hospitality industry. We provide customized, high quality products such as printing and packaging solutions, luxury wooden and leather items, eco friendly coir and garden products, and handcrafted cane goods. With a focus on quality, sustainability, and customer satisfaction, they are a trusted partner for hotels and resorts in Sri Lanka and internationally.
        </div>

        <!-- directs to about us inne page -->
        <a class="section-button-white-border" href="<?php echo home_url(); ?>/about-us/">Read More</a>
    </div>

</div>

<!-- products section -->
<style>
    .products--section {
        padding: 4% 20%;
        width: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        position: relative;
        background: #fff;
        border-bottom: 2px solid;
        border-image-source: linear-gradient(270deg, rgba(255, 255, 255, 0) 0%, #00D6C9 50.48%, rgba(255, 255, 255, 0) 100%);
        border-image-slice: 1;
        border-image-repeat: stretch;
    }
	
    .products--section-inner {
        text-align: center;
        width: 100%;
        position: relative;
    }

    .products--section-inner-text-container {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        text-align: center;
        gap: 10px;
    }

    .products--section-inner-content-container {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        margin-top: 30px;
    }

    .products--section-inner-content-container-slider-werapper {
        width: 100%;
        position: relative;
        margin: 0 auto;
    }

    .products--section-inner-content-container-slider-werapper .slick-dots li.slick-active button:before {
        opacity: 1;
        color: #0D1B39;
    }

    .products--section-inner-content-container-slider-werapper .slick-dots li button:before {
        font-family: slick;
        font-size: 10px;
        line-height: 20px;
        position: absolute;
        top: 0;
        left: 0;
        width: 20px;
        height: 20px;
        content: '•';
        text-align: center;
        opacity: .25;
        color: #000;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
    }

    .products--section-inner-content-container-slider-werapper .slick-next, 
    .products--section-inner-content-container-slider-werapper .slick-prev {
        width: 30px;
        height: 30px;
        position: absolute;
        top: 50%;
        z-index: 50;
    }

    .products--section-inner-content-container-slider-werapper .slick-next::before, 
    .products--section-inner-content-container-slider-werapper .slick-prev::before {
        font-size: 0;
    }

    .products--section-inner-content-container-slider-werapper .slick-prev {
        background: url('<?php echo get_template_directory_uri(); ?>/icons/prev.svg');
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        left: -1%;
        background-color: #fff;
        box-shadow: 0px 4px 23.2px 0px #00000012;
        padding: 10px;
    }

    .products--section-inner-content-container-slider-werapper .slick-next {
        background: url('<?php echo get_template_directory_uri(); ?>/icons/next.svg');
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        right: -1%;
        background-color: #fff;
        box-shadow: 0px 4px 23.2px 0px #00000012;
        padding: 10px;
    }

    .products--section-inner-content-container-slider-werapper .slick-slide {
        position: relative;
        box-sizing: border-box;
        padding: 0px 10px;
    }

    .products--section-inner-content-container-slider-werapper-single-slide {
        width: 100%;
    }

    .products--section-inner-content-container-slider-werapper-single-slide-inner {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        gap: 20px;
    }

    .products--section-inner-content-container-slider-werapper-single-slide-inner-image-container {
        width: 100%;
        height: 400px;
        border-radius: 5px;
    }

    .products--section-inner-content-container-slider-werapper-single-slide-inner-image-container img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        object-position: center;
        border-radius: 5px;
    }

    .products--section-inner-content-container-slider-werapper-single-slide-inner-text {
        font-weight: 400;
        font-size: 16px;
        color: #0D1B39;
    }

    @media (max-width: 1600px) {
        .products--section {
            padding: 4% 18%;
        }
    }

    @media (max-width: 1500px) {
        .products--section-inner-content-container-slider-werapper-single-slide-inner-image-container {
            height: 350px;
        }
    }

    @media (max-width: 1400px) {
        .products--section {
            padding: 4% 15%;
        }
    }

    @media (max-width: 1200px) {
        .products--section {
            padding: 4% 10%;
        }
    }

    /*  */
    .popup-overlay {
        display: none;
        position: fixed;
        top: 0; left: 0;
        width: 100%; height: 100%;
        background: rgba(0,0,0,0.7);
        justify-content: center;
        align-items: center;
        z-index: 9999;
    }

    .popup-content {
        background: #fff;
        padding: 30px;
        border-radius: 10px;
        max-width: 600px;
        width: 90%;
        text-align: left;
        position: relative;
    }

    .popup-close {
        position: absolute;
        right: 15px; top: 10px;
        font-size: 24px;
        cursor: pointer;
    }
</style>

<section class="products--section">
    <div class="products--section-inner">
        <div class="products--section-inner-text-container" data-aos="fade-up">
            <div class="section-inner-text-container-title">Our Product Categories</div>
            <div class="section-inner-text-container-tagline">
                You can get a workspace of the highest quality at an affordable price and still enjoy the facilities that are oly here.
            </div>
        </div>

        <div class="products--section-inner-content-container" data-aos="fade-up">
            <div class="products--section-inner-content-container-slider-werapper">
                <?php 
                    $args = array( 
                        'post_type' => 'offer-product',
                        'posts_per_page' => 100 , 
                        'orderby' =>'menu_order' ,
                    );

                    $count = 0;

                    $the_query = new WP_Query( $args ); 

                        if ( $the_query->have_posts() ) {
                            while ( $the_query->have_posts() ) { 
                                $the_query->the_post(); 
                                $count++;

                                $front_image = get_field('offer_product_image');
                                if(empty($front_image)) {
                                    $front_image = get_template_directory_uri().'/images/products.jpg';
                                } else {
                                    $front_image = $front_image;
                                }

                                $content = get_the_content();
                ?>
                <div class="products--section-inner-content-container-slider-werapper-single-slide">
                    <div class="products--section-inner-content-container-slider-werapper-single-slide-inner">
                        <div class="products--section-inner-content-container-slider-werapper-single-slide-inner-image-container">
                            <img src="<?php echo $front_image; ?>" alt="">
                        </div>

                        <div class="products--section-inner-content-container-slider-werapper-single-slide-inner-text"><?php the_title(); ?></div>

                        <!-- <a href="<?php //the_permalink(); ?>" class="section-button">
                            More Info
                            <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M13.2328 16.4569C12.9328 16.7426 12.9212 17.2173 13.2069 17.5172C13.4926 17.8172 13.9673 17.8288 14.2672 17.5431L13.2328 16.4569ZM19.5172 12.5431C19.8172 12.2574 19.8288 11.7827 19.5431 11.4828C19.2574 11.1828 18.7827 11.1712 18.4828 11.4569L19.5172 12.5431ZM18.4828 12.5431C18.7827 12.8288 19.2574 12.8172 19.5431 12.5172C19.8288 12.2173 19.8172 11.7426 19.5172 11.4569L18.4828 12.5431ZM14.2672 6.4569C13.9673 6.17123 13.4926 6.18281 13.2069 6.48276C12.9212 6.78271 12.9328 7.25744 13.2328 7.5431L14.2672 6.4569ZM19 12.75C19.4142 12.75 19.75 12.4142 19.75 12C19.75 11.5858 19.4142 11.25 19 11.25V12.75ZM5 11.25C4.58579 11.25 4.25 11.5858 4.25 12C4.25 12.4142 4.58579 12.75 5 12.75V11.25ZM14.2672 17.5431L19.5172 12.5431L18.4828 11.4569L13.2328 16.4569L14.2672 17.5431ZM19.5172 11.4569L14.2672 6.4569L13.2328 7.5431L18.4828 12.5431L19.5172 11.4569ZM19 11.25L5 11.25V12.75L19 12.75V11.25Z"></path> </g></svg>
                        </a> -->

                        <a href="javascript:void(0);" 
                            class="section-button open-popup" 
                            data-title="<?php echo esc_attr(get_the_title()); ?>" 
                            data-content="<?php echo esc_attr(wp_kses_post($content)); ?>">
                            More Info
                            <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M13.2328 16.4569C12.9328 16.7426 12.9212 17.2173 13.2069 17.5172C13.4926 17.8172 13.9673 17.8288 14.2672 17.5431L13.2328 16.4569ZM19.5172 12.5431C19.8172 12.2574 19.8288 11.7827 19.5431 11.4828C19.2574 11.1828 18.7827 11.1712 18.4828 11.4569L19.5172 12.5431ZM18.4828 12.5431C18.7827 12.8288 19.2574 12.8172 19.5431 12.5172C19.8288 12.2173 19.8172 11.7426 19.5172 11.4569L18.4828 12.5431ZM14.2672 6.4569C13.9673 6.17123 13.4926 6.18281 13.2069 6.48276C12.9212 6.78271 12.9328 7.25744 13.2328 7.5431L14.2672 6.4569ZM19 12.75C19.4142 12.75 19.75 12.4142 19.75 12C19.75 11.5858 19.4142 11.25 19 11.25V12.75ZM5 11.25C4.58579 11.25 4.25 11.5858 4.25 12C4.25 12.4142 4.58579 12.75 5 12.75V11.25ZM14.2672 17.5431L19.5172 12.5431L18.4828 11.4569L13.2328 16.4569L14.2672 17.5431ZM19.5172 11.4569L14.2672 6.4569L13.2328 7.5431L18.4828 12.5431L19.5172 11.4569ZM19 11.25L5 11.25V12.75L19 12.75V11.25Z"></path>
                            </svg>
                        </a>
                    </div>
                </div>
                <?php
                    }
                        wp_reset_postdata();
                    } else {
                        echo '<p class="description-font-family black-font">No content to display</p>';
                    }
                ?>
            </div>
        </div>

        <div id="product-popup" class="popup-overlay">
            <div class="popup-content">
                <span class="popup-close">&times;</span>
                <h2 id="popup-title"></h2>
                <div id="popup-body"></div>
            </div>
        </div>
    </div>
</section>

<!-- featured products -->
<style>
    .featured--products--section {
        padding: 4% 20%;
        width: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        position: relative;
        background: #F6F9FF;
        border-bottom: 2px solid;
        border-image-source: linear-gradient(270deg, rgba(255, 255, 255, 0) 0%, #00D6C9 50.48%, rgba(255, 255, 255, 0) 100%);
        border-image-slice: 1;
        border-image-repeat: stretch;
    }
	
    .featured--products--section-inner {
        text-align: center;
        width: 100%;
        position: relative;
    }

    .featured--products--section-inner-text-container {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        text-align: center;
        gap: 10px;
        position: relative;
    }

    .featured--products--section-inner-content-container {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        margin-top: 30px;
        position: relative;
        padding-bottom: 3%;
    }

    .featured--products--section-inner-content-container-slider-wrapper {
        width: 100%;
        position: relative;
        margin: 0 auto;
    }

    .featured--products--section-inner-content-container-slider-wrapper .slick-dots {
        position: absolute;
        bottom: -10%;
        display: block;
        width: 100%;
        padding: 0;
        margin: 0;
        list-style: none;
        text-align: center;
    }

    .featured--products--section-inner-content-container-slider-wrapper-single-slide {
        position: relative;
    }

    .featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-wrapper {
        position: relative;
        width: 100%;
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 20px;
    }

    .featured--products--section-inner-content-container-slider-wrapper .slick-dots li.slick-active button:before {
        opacity: 1;
        color: #0D1B39;
    }

    .featured--products--section-inner-content-container-slider-wrapper .slick-dots li button:before {
        font-family: slick;
        font-size: 10px;
        line-height: 20px;
        position: absolute;
        top: 0;
        left: 0;
        width: 20px;
        height: 20px;
        content: '•';
        text-align: center;
        opacity: .25;
        color: #000;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
    }

    .featured--products--section-inner-content-container-slider-wrapper .slick-next, 
    .featured--products--section-inner-content-container-slider-wrapper .slick-prev {
        width: 30px;
        height: 30px;
        position: absolute;
        top: 102%;
        z-index: 50;
    }

    .featured--products--section-inner-content-container-slider-wrapper .slick-next::before, 
    .featured--products--section-inner-content-container-slider-wrapper .slick-prev::before {
        font-size: 0;
    }

    .featured--products--section-inner-content-container-slider-wrapper .slick-prev {
        background: url('<?php echo get_template_directory_uri(); ?>/icons/prev.svg');
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        left: 45%;
        background-color: #fff;
        box-shadow: 0px 4px 23.2px 0px #00000012;
        padding: 10px;
    }

    .featured--products--section-inner-content-container-slider-wrapper .slick-next {
        background: url('<?php echo get_template_directory_uri(); ?>/icons/next.svg');
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        right: 45%;
        background-color: #fff;
        box-shadow: 0px 4px 23.2px 0px #00000012;
        padding: 10px;
    }

    .featured--products--section-inner-content-container-slider-wrapper-single-slide-inner {
        position: relative;
        padding: 0px 5px;
    }

    .featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-image-container {
        position: relative;
        z-index: 1;
        width: 100%;
        height: 350px;
        border-radius: 5px;
    }

    .featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-image-container img {
        width: 100%;
        height: 90%;
        object-fit: cover;
        object-position: center;
        border-radius: 5px;
    }

    .featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-text-container-wrapper {
        width: 100%;
        position: absolute;
        z-index: 2;
        bottom: 0;
        padding: 0% 15%;
    }

    .featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-text-container {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 10px 15px;
        border-radius: 5px;
        background: #fff;
    }

    .featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-text-container-title {
        font-weight: 400;
        color: #0D1B39;
    }

    @media (max-width: 1600px) {
        .featured--products--section {
            padding: 4% 18%;
        }
    }

    @media (max-width: 1400px) {
        .featured--products--section {
            padding: 4% 15%;
        }
    }

    @media (max-width: 1200px) {
        .featured--products--section {
            padding: 4% 10%;
        }
    }

    @media (max-width: 768px) {
        .featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-wrapper {
            grid-template-columns: 1fr;
        }

        .featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-image-container {
            height: 275px;
        }

        .featured--products--section-inner-content-container-slider-wrapper .slick-next, 
        .featured--products--section-inner-content-container-slider-wrapper .slick-prev {
            top: 55%;
        }

        .featured--products--section-inner-content-container-slider-wrapper .slick-prev {
            left: 0%;
        }

        .featured--products--section-inner-content-container-slider-wrapper .slick-next {
            right: 0%;
        }
    }

    /*  */
    .popup-overlay {
        display: none;
        position: fixed;
        top: 0; left: 0;
        width: 100%; height: 100%;
        background: rgba(0,0,0,0.7);
        justify-content: center;
        align-items: center;
        z-index: 9999;
    }

    .popup-content {
        background: #fff;
        padding: 30px;
        border-radius: 10px;
        max-width: 600px;
        width: 90%;
        text-align: left;
        position: relative;
    }

    .popup-close {
        position: absolute;
        right: 15px; top: 10px;
        font-size: 24px;
        cursor: pointer;
    }

    .popup-inner img {
        border-radius: 6px;
        display: block;
    }
</style>

<section class="featured--products--section">
    <div class="featured--products--section-inner">
        <div class="featured--products--section-inner-text-container" data-aos="fade-up">
            <div class="section-inner-text-container-title">Featured Products</div>
            <div class="section-inner-text-container-tagline">
                You can get a workspace of the highest quality at an affordable price and still enjoy the facilities that are oly here.
            </div>
        </div>

        <div class="featured--products--section-inner-content-container" data-aos="fade-up">
            <div class="featured--products--section-inner-content-container-slider-wrapper">
                <?php 
                $args = array( 
                    'post_type' => 'featured-product',
                    'posts_per_page' => 100 , 
                    'orderby' =>'menu_order' ,
                );

                $the_query = new WP_Query( $args ); 
                $count = 0;

                if ( $the_query->have_posts() ) {
                    echo '<div class="featured--products--section-inner-content-container-slider-wrapper">';

                    while ( $the_query->have_posts() ) { 
                        $the_query->the_post(); 
                        $count++;

                        $front_image = get_field('featured_product_image');
                        if(empty($front_image)) {
                            $front_image = get_template_directory_uri().'/images/products.jpg';
                        }

                        if($count % 4 == 1) {
                            // Open slide wrapper every 4 items
                            echo '<div class="featured--products--section-inner-content-container-slider-wrapper-single-slide">
                                    <div class="featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-wrapper">';
                        }
                        ?>

                        <div class="featured--products--section-inner-content-container-slider-wrapper-single-slide-inner">
                            <div class="featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-image-container">
                                <img src="<?php echo $front_image; ?>" alt="">
                            </div>

                            <div class="featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-text-container-wrapper">
                                <div class="featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-text-container">
                                    <div class="featured--products--section-inner-content-container-slider-wrapper-single-slide-inner-text-container-title font-1"><?php the_title(); ?></div>
                                    <!-- <a href="<?php //the_permalink(); ?>" class="section-button-yellow">More Info</a> -->

                                    <a href="javascript:void(0);" 
                                    class="section-button-yellow open-popup" 
                                    data-title="<?php echo esc_attr(get_the_title()); ?>" 
                                    data-content="<?php echo esc_attr(wp_kses_post(get_the_content())); ?>" 
                                    data-image="<?php echo esc_url($front_image); ?>">
                                    More Info
                                    </a>
                                </div>
                            </div>
                        </div>

                        <?php
                        if($count % 4 == 0) {
                            // Close slide wrapper
                            echo '  </div>
                                </div>';
                        }
                    }

                    // Close if leftover items
                    if($count % 4 != 0) {
                        echo '  </div>
                            </div>';
                    }

                    echo '</div>';

                    wp_reset_postdata();
                } else {
                    echo '<p class="description-font-family black-font">No content to display</p>';
                }
                ?>
            </div>
        </div>

        <div id="product-popup" class="popup-overlay">
            <div class="popup-content">
                <span class="popup-close">&times;</span>
                <div class="popup-inner">
                <img id="popup-image" src="" alt="" style="max-width:100%; margin-bottom:15px;">
                <h2 id="popup-title"></h2>
                <div id="popup-body"></div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- why choose us section -->
<style>
    .strengths--section {
        padding: 4% 20%;
        width: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        position: relative;
        background: #FFF;
    }
	
    .strengths--section-inner {
        text-align: center;
        width: 100%;
        position: relative;
    }

    .strengths--section-inner-text-container {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        justify-content: center;
        text-align: left;
        gap: 10px;
        position: relative;
    }

    .strengths--section-inner-content-container {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        margin-top: 30px;
        position: relative;
    }

    .strengths--section-inner-content-container-slider-wrapper {
        width: 100%;
        position: relative;
        margin: 0 auto;
    }

    .strengths--section-inner-content-container-slider-wrapper .slick-next, 
    .strengths--section-inner-content-container-slider-wrapper .slick-prev {
        width: 30px;
        height: 30px;
        position: absolute;
        top: 120%;
        z-index: 50;
    }

    .strengths--section-inner-content-container-slider-wrapper .slick-next::before, 
    .strengths--section-inner-content-container-slider-wrapper .slick-prev::before {
        font-size: 0;
    }

    .strengths--section-inner-content-container-slider-wrapper .slick-prev {
        background: url('<?php echo get_template_directory_uri(); ?>/icons/prev.svg');
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        left: 45%;
        background-color: #fff;
        box-shadow: 0px 4px 23.2px 0px #00000012;
        padding: 10px;
    }

    .strengths--section-inner-content-container-slider-wrapper .slick-next {
        background: url('<?php echo get_template_directory_uri(); ?>/icons/next.svg');
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        right: 45%;
        background-color: #fff;
        box-shadow: 0px 4px 23.2px 0px #00000012;
        padding: 10px;
    }

    .strengths--section-inner-content-container-slider-wrapper .slick-slide {
        position: relative;
        box-sizing: border-box;
        padding: 0px 20px;
    }

    .strengths--section-inner-content-container-slider-wrapper-single-slide {}

    .strengths--section-inner-content-container-slider-wrapper-single-slide-inner {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        text-align: left;
        gap: 15px;
    }

    .strengths--section-inner-content-container-slider-wrapper-single-slide-inner-title {
        font-weight: 400;
        font-size: 24px;
        line-height: 100%;
        color: #00D6C9;
    }

    .strengths--section-inner-content-container-slider-wrapper-single-slide-inner-description {
        font-weight: 400;
        font-size: 16px;
        line-height: 185%;
        color: #1E1E1E;
    }

    @media (max-width: 1600px) {
        .strengths--section {
            padding: 4% 18%;
        }
    }

    @media (max-width: 1500px) {
        .strengths--section-inner-content-container-slider-wrapper-single-slide-inner-title {
            font-size: 22px;
        }

        .strengths--section-inner-content-container-slider-wrapper-single-slide-inner-description {
            font-size: 15.5px;
        }
    }

    @media (max-width: 1400px) {
        .strengths--section {
            padding: 4% 15%;
        }
    }

    @media (max-width: 1200px) {
        .strengths--section {
            padding: 4% 10%;
        }

        .strengths--section-inner-content-container-slider-wrapper-single-slide-inner-title {
            font-size: 20px;
        }

        .strengths--section-inner-content-container-slider-wrapper-single-slide-inner-description {
            font-size: 15px;
        }

        .strengths--section-inner-text-container {
            align-items: center;
            text-align: center;
        }

        .strengths--section-inner-content-container-slider-wrapper .slick-next, .strengths--section-inner-content-container-slider-wrapper .slick-prev {
            top: 105%;
        }
    }

    @media (max-width: 992px) {
        .strengths--section-inner-content-container-slider-wrapper-single-slide-inner-title {
            font-size: 18px;
        }

        .strengths--section-inner-content-container-slider-wrapper-single-slide-inner-description {
            font-size: 14px;
        }

        .strengths--section-inner-content-container-slider-wrapper .slick-next {
            right: 40%;
        }

        .strengths--section-inner-content-container-slider-wrapper .slick-prev {
            left: 40%;
        }
    }

    @media (max-width: 768px) {
        .strengths--section-inner-content-container-slider-wrapper-single-slide-inner-title {
            font-size: 17px;
        }

        .strengths--section-inner-content-container-slider-wrapper-single-slide-inner-description {
            font-size: 13.5px;
        }

        .strengths--section-inner-content-container-slider-wrapper-single-slide-inner {
            align-items: center;
            text-align: center;
        }

        .strengths--section-inner-content-container-slider-wrapper .slick-next, 
        .strengths--section-inner-content-container-slider-wrapper .slick-prev {
            top: 115%;
        }
    }

    @media (max-width: 575px) {
        .strengths--section-inner-content-container-slider-wrapper-single-slide-inner-title {
            font-size: 16px;
        }

        .strengths--section-inner-content-container-slider-wrapper-single-slide-inner-description {
            font-size: 13px;
        }
    }

    @media (max-width: 480px) {
        .strengths--section-inner-content-container-slider-wrapper-single-slide-inner-title {
            font-size: 15px;
        }

        .strengths--section-inner-content-container-slider-wrapper-single-slide-inner-description {
            font-size: 12.5px;
        }
    }
</style>

<section class="strengths--section">
    <div class="strengths--section-inner">
        <div class="strengths--section-inner-text-container" data-aos="fade-up">
            <div class="section-inner-text-container-title">Why Choose Us?</div>
        </div>

        <div class="strengths--section-inner-content-container" data-aos="fade-up">
            <div class="strengths--section-inner-content-container-slider-wrapper">
                <?php 
                    $args = array( 
                        'post_type' => 'strength',
                        'posts_per_page' => 100 , 
                        'orderby' =>'menu_order' ,
                    );

                    $count = 0;

                    $the_query = new WP_Query( $args ); 

                        if ( $the_query->have_posts() ) {
                            while ( $the_query->have_posts() ) { 
                                $the_query->the_post(); 
                                $count++;
                ?>
                    <div class="strengths--section-inner-content-container-slider-wrapper-single-slide">
                        <div class="strengths--section-inner-content-container-slider-wrapper-single-slide-inner">
                            <div class="strengths--section-inner-content-container-slider-wrapper-single-slide-inner-title"><?php the_title(); ?></div>

                            <div class="strengths--section-inner-content-container-slider-wrapper-single-slide-inner-description">
                                <?php the_content(); ?>
                            </div>
                        </div>
                    </div>
                <?php
                    }
                        wp_reset_postdata();
                    } else {
                        echo '<p class="description-font-family black-font">No content to display</p>';
                    }
                ?>
            </div>
        </div>
    </div>
</section>

<!-- testimonials section -->
<!-- <style>
    .testimonials--section {
        padding: 6% 20%;
        width: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        position: relative;
        background: url('<?php echo get_template_directory_uri(); ?>/images/testmial-background.svg');
        background-position: center;
        background-size: cover;
        background-repeat: no-repeat;
        border-bottom: 2px solid;
        border-image-source: linear-gradient(270deg, rgba(255, 255, 255, 0) 0%, #00D6C9 50.48%, rgba(255, 255, 255, 0) 100%);
        border-image-slice: 1;
        border-image-repeat: stretch;
    }
	
    .testimonials--section-inner {
        text-align: center;
        width: 100%;
        position: relative;
    }

    .testimonials--section-inner-text-container {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        text-align: center;
        gap: 10px;
        position: relative;
    }

    .testimonials--section-inner-content-container {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        margin-top: 30px;
        position: relative;
    }

    .testimonials--section-inner-content-container-slider-wrapper {
        width: 100%;
        position: relative;
        margin: 0 auto;
    }

    .testimonials--section-inner-content-container-slider-wrapper .slick-slide {
        position: relative;
        box-sizing: border-box;
        padding: 0px 20px;
        width: 100%;
    }

    .testimonials--section-inner-content-container-slider-wrapper .slick-next, 
    .testimonials--section-inner-content-container-slider-wrapper .slick-prev {
        width: 30px;
        height: 30px;
        position: absolute;
        top: 120%;
        z-index: 50;
    }

    .testimonials--section-inner-content-container-slider-wrapper .slick-next::before, 
    .testimonials--section-inner-content-container-slider-wrapper .slick-prev::before {
        font-size: 0;
    }

    .testimonials--section-inner-content-container-slider-wrapper .slick-prev {
        background: url('<?php echo get_template_directory_uri(); ?>/icons/prev-blue.svg');
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        left: 45%;
        background-color: #fff;
        box-shadow: 0px 4px 23.2px 0px #00000012;
        padding: 10px;
    }

    .testimonials--section-inner-content-container-slider-wrapper .slick-next {
        background: url('<?php echo get_template_directory_uri(); ?>/icons/next-blue.svg');
        background-position: center;
        background-repeat: no-repeat;
        background-size: contain;
        right: 45%;
        background-color: #fff;
        box-shadow: 0px 4px 23.2px 0px #00000012;
        padding: 10px;
    }

    .testimonials--section-inner-content-container-slider-wrapper-single-slide {
        width: 100%;
    }

    .testimonials--section-inner-content-container-slider-wrapper-single-slide img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        object-position: center;
    }

    @media (max-width: 1600px) {
        .testimonials--section {
            padding: 6% 18%;
        }
    }

    @media (max-width: 1400px) {
        .testimonials--section {
            padding: 6% 15%;
        }
    }

    @media (max-width: 1200px) {
        .testimonials--section {
            padding: 6% 10% 10% 10%;
        }
    }

    @media (max-width: 992px) {
        .testimonials--section-inner-content-container-slider-wrapper .slick-next {
            right: 40%;
        }

        .testimonials--section-inner-content-container-slider-wrapper .slick-prev {
            left: 40%;
        }
    }

    @media (max-width: 768px) {
        .testimonials--section-inner-content-container-slider-wrapper .slick-next, 
        .testimonials--section-inner-content-container-slider-wrapper .slick-prev {
            top: 50%;
        }

        .testimonials--section-inner-content-container-slider-wrapper .slick-next {
            right: 0%;
        }

        .testimonials--section-inner-content-container-slider-wrapper .slick-prev {
            left: 0%;
        }
    }
</style>

<section class="testimonials--section">
    <div class="testimonials--section-inner">
        <div class="testimonials--section-inner-text-container" data-aos="fade-up">
            <div class="section-inner-text-container-title">Client Testimonials</div>
        </div>

        <div class="testimonials--section-inner-content-container" data-aos="fade-up">
            <div class="testimonials--section-inner-content-container-slider-wrapper">
                <?php for ($i=0; $i < 10; $i++) { ?> 
                    <div class="testimonials--section-inner-content-container-slider-wrapper-single-slide">
                        <img src="<?php echo get_template_directory_uri(); ?>/images/tesimonial.svg" alt="">
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</section> -->

<script>
    document.addEventListener("DOMContentLoaded", function() {
        const buttons = document.querySelectorAll(".open-popup");
        const popup = document.getElementById("product-popup");
        const popupTitle = document.getElementById("popup-title");
        const popupBody = document.getElementById("popup-body");
        const popupClose = document.querySelector(".popup-close");

        buttons.forEach(btn => {
            btn.addEventListener("click", function() {
                const title = this.getAttribute("data-title");
                const content = this.getAttribute("data-content");

                popupTitle.innerHTML = title;
                popupBody.innerHTML = content;

                popup.style.display = "flex";
            });
        });

        popupClose.addEventListener("click", function() {
            popup.style.display = "none";
        });

        popup.addEventListener("click", function(e) {
            if(e.target === popup) {
                popup.style.display = "none";
            }
        });
    });
</script>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        const buttons = document.querySelectorAll(".open-popup");
        const popup = document.getElementById("product-popup");
        const popupTitle = document.getElementById("popup-title");
        const popupBody = document.getElementById("popup-body");
        const popupImage = document.getElementById("popup-image");
        const popupClose = document.querySelector(".popup-close");

        buttons.forEach(btn => {
            btn.addEventListener("click", function() {
                const title = this.getAttribute("data-title");
                const content = this.getAttribute("data-content");
                const image = this.getAttribute("data-image");

                popupTitle.innerHTML = title;
                popupBody.innerHTML = content;
                popupImage.src = image;

                popup.style.display = "flex";
            });
        });

        popupClose.addEventListener("click", function() {
            popup.style.display = "none";
        });

        popup.addEventListener("click", function(e) {
            if(e.target === popup) {
                popup.style.display = "none";
            }
        });
    });
</script>

<?php get_footer(); ?>