<?php
// Template Name: Contact Us
?>

<?php 
    get_header(); 
    include get_theme_file_path('header-banner.php');
?>

<style>
    .contact--section {
        padding: 4% 20%;
        width: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        position: relative;
        background: #F6F9FF;
        border-bottom: 2px solid;
        border-image-source: linear-gradient(270deg, rgba(255, 255, 255, 0) 0%, #00D6C9 50.48%, rgba(255, 255, 255, 0) 100%);
        border-image-slice: 1;
        border-image-repeat: stretch;
    }
	
    .contact--section-inner {
        text-align: center;
        width: 100%;
        height: 100%;
        position: relative;
        display: grid;
        grid-template-columns: 2fr 1fr;
        gap: 40px;
        align-items: center;
    }

    .contact--section-inner-left-container {
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        justify-content: flex-start;
        width: 100%;
        height: 100%;
        gap: 20px;
    }

    .contact--section-inner-left-container-form-container {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        height: 100%;
    }

    .contact--section-inner-left-container-form-container .wpcf7 {
        width: 100%;
    }

    .contact--section-inner-left-container-form-container form {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        text-align: left;
        gap: 20px;
        margin-bottom: 5%;
    }

    .contact--section-inner-left-container-form-container input[type="text"], 
    .contact--section-inner-left-container-form-container input[type="email"], 
    .contact--section-inner-left-container-form-container input[type="tel"], 
    .contact--section-inner-left-container-form-container textarea,
    .contact--section-inner-left-container-form-container select {
        width: 100%;
        padding: 5px 10px;
        border-radius: 5px;
        border: 1px solid #000;
    }

    .contact--section-inner-left-container-form-container input[type="text"]::placeholder, 
    .contact--section-inner-left-container-form-container input[type="email"]::placeholder, 
    .contact--section-inner-left-container-form-container input[type="tel"]::placeholder, 
    .contact--section-inner-left-container-form-container textarea::placeholder,
    .contact--section-inner-left-container-form-container select,
    label {
        font-size: clamp(13px, 1.3vw, 16px);
    }

    .contact--section-inner-left-container-form-container .wpcf7-form-control-wrap {
        width: 100%;
    }

    .form-row {
        width: 100%;
        display: grid;
        grid-template-columns: 1fr 1fr;
        align-items: center;
        gap: 30px;
    }

    .form-col {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        gap: 5px;
    }

    .contact--section-inner-left-container-text-container {
        width: 100%;
        text-align: left;
    }

    .contact--section-inner-left-container-contact-container {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        justify-content: center;
        gap: 20px;
    }

    .contact--section-inner-left-container-contact-container-single-card {
        width: 100%;
        display: flex;
        align-items: center;
        justify-content: flex-start;
        gap: 20px;
    }

    .contact--section-inner-left-container-contact-container-single-card-icon {
        width: 30px;
        height: 30px;
    }

    .contact--section-inner-left-container-contact-container-single-card-icon img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        object-position: center;
    }

    .contact--section-inner-left-container-contact-container-single-card-text {
        font-weight: 400;
        font-size: clamp(12px, 1.2vw, 15px);
        line-height: 160%;
        color: #1E1E1E;
    }

    .contact--section-inner-left-container-social-container {
        width: 100%;
        display: flex;
        align-items: center;
        justify-content: flex-start;
        gap: 20px;
    }

    .contact--section-inner-left-container-social-container-single-icon {
        width: 30px;
        height: 30px;
    }

    .contact--section-inner-left-container-social-container-single-icon img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        object-position: center;
    }

    .contact--section-inner-right-container {
        width: 100%;
        height: 100%;
    }

    .contact--section-inner-right-container-map-container {
        width: 100%;
        height: 400px;
    }

    .contact--section-inner-right-container-map-container iframe {
        width: 100%;
        height: 100%;
        border-radius: 20px;
    }

    .form-row input[type="submit"] {
        position: relative;
        overflow: hidden;
        font-weight: 500;
        font-size: 16px;
        line-height: 1.85;
        color: #1E1E1E;
        border-radius: 4px;
        padding: 10px 24px;
        background: #F6B76F;
        border: none;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        transition: color 0.4s ease-in-out, transform 0.2s ease;
        z-index: 1;
    }

    /* animated overlay */
    .form-row input[type="submit"]::before {
        content: "";
        position: absolute;
        top: 0;
        left: 0;
        width: 0;
        height: 100%;
        background: #00D6C9;
        transition: width 0.4s ease-in-out;
        z-index: -1;
        border-radius: inherit;
    }

    /* hover state */
    .form-row input[type="submit"]:hover {
        color: #fff;
    }

    .form-row input[type="submit"]:hover::before {
        width: 100%;
    }

    /* optional focus for accessibility */
    .form-row input[type="submit"]:focus-visible {
        outline: 2px solid #00D6C9;
        outline-offset: 2px;
    }

    @media (max-width: 1600px) {
        .contact--section {
            padding: 4% 18%;
        }
    }

    @media (max-width: 1400px) {
        .contact--section {
            padding: 4% 15%;
        }
    }

    @media (max-width: 1200px) {
        .contact--section {
            padding: 4% 10%;
        }

        .contact--section-inner-left-container-contact-container-single-card-icon,
        .contact--section-inner-left-container-social-container-single-icon {
            width: 20px;
            height: 20px;
        }
    }

    @media (max-width: 1050px) {
        .contact--section-inner {
            grid-template-columns: 1fr;
        }
    }

    @media (max-width: 992px) {
        .contact--section {
            padding: 4% 5%;
        }
    }

    @media (max-width: 600px) {
        .form-row {
            grid-template-columns: 1fr;
        }
    }
</style>

<section class="contact--section">
    <div class="contact--section-inner">
        <div class="contact--section-inner-left-container" data-aos="fade-up">

            <div class="contact--section-inner-left-container-text-container" data-aos="fade-up">
                <div class="section-inner-text-container-title">Contact Information </div>
                <div class="section-inner-text-container-tagline">Bringing Sri Lankan artistry and soul into global hospitality spaces.</div>
            </div>

            <div class="contact--section-inner-left-container-contact-container">
                <?php 
                $contactContent = [
                    ["https://maps.app.goo.gl/rcwmcALXixndBm2Q9","location.svg","No. 709/D, Mankada Rd,Kadawatha, Sri Lanka."],
                    ["tel:+94 817 414656","phone.svg","+94 817 414656"],
                    ["mailto:info@ceypearlexim.com","email.svg","info@ceypearlexim.com"],
                ];

                foreach($contactContent as [$link, $icon, $text]) {
                ?>
                <a href="<?php echo $link; ?>" target="_blank">
                    <div class="contact--section-inner-left-container-contact-container-single-card">
                        <div class="contact--section-inner-left-container-contact-container-single-card-icon">
                            <img src="<?php echo get_template_directory_uri(); ?>/icons/<?php echo $icon; ?>" alt="">
                        </div>
                        <div class="contact--section-inner-left-container-contact-container-single-card-text"><?php echo $text; ?></div>
                    </div>
                </a>
                <?php } ?>
                <div class="contact--section-inner-left-container-contact-container-single-card">
                    <div class="contact--section-inner-left-container-contact-container-single-card-icon">
                        <img src="<?php echo get_template_directory_uri(); ?>/icons/business.svg" alt="">
                    </div>
                    <div class="contact--section-inner-left-container-contact-container-single-card-text">Business Hours: 08am to 5:30pm  </div>
                </div>
            </div>

            <div class="contact--section-inner-left-container-form-container">
                <?php echo do_shortcode('[contact-form-7 id="51d0b86" title="Inquiry Form"]'); ?>
            </div>

            <div class="contact--section-inner-left-container-social-container">
                <?php 
                $socialContnet = [
                    ["facebook.svg","https://www.facebook.com/profile.php?id=61577583847134"],
                    ["twitter.svg",""],
                    ["instagram.svg",""],
                ];

                foreach($socialContnet as [$icon, $link]) {
                ?>
                <a href="<?php echo $link; ?>" target="_blank">
                    <div class="contact--section-inner-left-container-social-container-single-icon">
                        <img src="<?php echo get_template_directory_uri(); ?>/icons/<?php echo $icon; ?>" alt="">
                    </div>
                </a>
                <?php } ?>
            </div>
        </div>

        <div class="contact--section-inner-right-container" data-aos="fade-up">
            <div class="contact--section-inner-right-container-map-container">
                <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3960.1638032342153!2d79.958327083993!3d6.989978799564043!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3ae2f8653628840d%3A0x7c4c5e757a35170f!2sMankada%20Rd%2C%20Kadawatha!5e0!3m2!1sen!2slk!4v1756381065492!5m2!1sen!2slk" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>
