<?php
// Template Name: Blogs
?>

<?php 
    get_header(); 
    include get_theme_file_path( 'header-banner.php' );
?>

<style>
    .day-tours--section {
        padding: 4% 20%;
        width: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        position: relative;
        z-index: 35;
    }

    .day-tour-single-cards-wrapper {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 5% 10%;
    }

    .day-tour-single-card {
        box-shadow: 0px 0px 10px #000;
        border-radius: 20px;
    }

    .day-tour-single-card-count-container {
        display: flex;
        justify-content: flex-end;
        align-items: center;
        transform: translateX(7%);
    }

    .day-tour-single-card-count-container img {
        width: 40px;
        height: 40px;
        object-fit: cover;
        object-position: center;
    }

    .day-tour-single-card-image-container {
        height: 400px;
    }

    .day-tour-single-card-image-container img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        object-position: center;
        border-radius: 20px 20px 0px 0px;
    }

    .day-tour-single-card-content-container {
        display: flex;
        flex-direction: column;
        padding: 20px;
        align-items: center;
        gap: 15px;
        text-align: center;
    }

    .day-tour-single-card-content-container-button {
        padding-top: 3%;
    }

    .day-tours--section-inner-tab-titles {
        display: grid;
        grid-template-columns: 1fr 1fr 1fr;
        gap: 5%;
    }

    .day-tours--section-inner-tab-titles-single-card {
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        cursor: pointer;
    }

    .day-tours--section-inner-tab-titles-single-card-image-container {
        height: 500px;
        width: 400px;
        transition: 0.3s ease-in-out;
    }

    .day-tours--section-inner-tab-titles-single-card-image-container img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        object-position: center;
        border-radius: 20px;
    }

    .day-tours--section-inner-tab-titles-single-card-button-container a {
        padding: 5px 10px;
        border: 1px solid #000;
        color: #1E1E1E;
        border-radius: 5px;
        transition: 0.3s ease-in-out;
    }

    .day-tours--section-inner-tab-titles-single-card-title-container {
        color: #000;
    }

    .day-tours--section-inner-tab-titles-single-card:hover .day-tours--section-inner-tab-titles-single-card-image-container,
    .day-tours--section-inner-tab-titles-single-card.active .day-tours--section-inner-tab-titles-single-card-image-container {
        transform: translateY(-3%);
    }

    .day-tours--section-inner-tab-titles-single-card.active .day-tours--section-inner-tab-titles-single-card-title-container,
    .day-tours--section-inner-tab-titles-single-card:hover .day-tours--section-inner-tab-titles-single-card-title-container {
        color: #2E3191;
    }

    @media (max-width: 1600px) {
        .day-tours--section {
            padding: 4% 18%;
        }
    }

    @media (max-width: 1400px) {
        .day-tours--section {
            padding: 4% 15%;
        }
    }

    @media (max-width: 1200px) {
        .day-tours--section {
            padding: 4% 10%;
        }
    }

    @media (max-width: 992px) {
        .day-tours--section {
            padding: 4% 5%;
        }
    }

    @media (max-width: 768px) {
        .day-tour-single-cards-wrapper {
            display: grid;
            grid-template-columns: 1fr;
            gap: 20px;
        }
    }

    @media (max-width: 768px) {
        .day-tour-single-card-image-container {
            height: 300px;
        }
    }
</style>

<section class="day-tours--section">
	<div class="day-tours--section-inner">
        <div class="day-tour-single-cards-wrapper" data-aos="fade-up">
            <?php 
                $args = array( 
                    'post_type' => 'blog',
                    'posts_per_page' => 100 , 
                    'orderby' =>'menu_order' ,
                );

                $i = 1;

                $the_query = new WP_Query( $args ); 

                if ( $the_query->have_posts() ) {
                    while ( $the_query->have_posts() ) { 
                        $the_query->the_post(); 

                        $front_image = get_field('blog_front_image');
                        if(empty($front_image)) {
                            $front_image = get_template_directory_uri().'/images/home.jpg';
                        } else {
                            $front_image = $front_image;
                        }

                        $content = get_the_content();

            ?>
                <div class="day-tour-single-card" data-aos="zoom-in">

                    <div class="day-tour-single-card-image-container">
                        <img src="<?php echo $front_image; ?>" alt="">
                    </div>

                    <div class="day-tour-single-card-content-container">
                        <div class="day-tour-single-card-content-container-title font-weight-500 font-1-5"><?php the_title(); ?></div>

                        <a href="<?php the_permalink(); ?>" class="section-button">
                            More Info
                            <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M13.2328 16.4569C12.9328 16.7426 12.9212 17.2173 13.2069 17.5172C13.4926 17.8172 13.9673 17.8288 14.2672 17.5431L13.2328 16.4569ZM19.5172 12.5431C19.8172 12.2574 19.8288 11.7827 19.5431 11.4828C19.2574 11.1828 18.7827 11.1712 18.4828 11.4569L19.5172 12.5431ZM18.4828 12.5431C18.7827 12.8288 19.2574 12.8172 19.5431 12.5172C19.8288 12.2173 19.8172 11.7426 19.5172 11.4569L18.4828 12.5431ZM14.2672 6.4569C13.9673 6.17123 13.4926 6.18281 13.2069 6.48276C12.9212 6.78271 12.9328 7.25744 13.2328 7.5431L14.2672 6.4569ZM19 12.75C19.4142 12.75 19.75 12.4142 19.75 12C19.75 11.5858 19.4142 11.25 19 11.25V12.75ZM5 11.25C4.58579 11.25 4.25 11.5858 4.25 12C4.25 12.4142 4.58579 12.75 5 12.75V11.25ZM14.2672 17.5431L19.5172 12.5431L18.4828 11.4569L13.2328 16.4569L14.2672 17.5431ZM19.5172 11.4569L14.2672 6.4569L13.2328 7.5431L18.4828 12.5431L19.5172 11.4569ZM19 11.25L5 11.25V12.75L19 12.75V11.25Z"></path> </g></svg>
                        </a>
                    </div>
                </div>
            <?php
                        $i++;
                    }
                    wp_reset_postdata();
                } else {
                    echo '<p class="roboto-thin black-font">No content to display 3</p>';
                }
            ?>
        </div>
    </div>
</section>

<?php get_footer(); ?>