<?php
// Template Name: About Us
?>

<?php 
    get_header(); 
    include get_theme_file_path('header-banner.php');
?>

<style>
    .single-about--section {
        padding: 4% 20%;
        width: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        position: relative;
        background: #fff;
        border-bottom: 2px solid;
        border-image-source: linear-gradient(270deg, rgba(255, 255, 255, 0) 0%, #00D6C9 50.48%, rgba(255, 255, 255, 0) 100%);
        border-image-slice: 1;
        border-image-repeat: stretch;
    }
	
    .single-about--section-inner {
        text-align: center;
        width: 100%;
        position: relative;
    }

    .single-about--section-inner-description-container {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        text-align: left;
        justify-content: center;
        gap: 20px;
        padding: 3% 0%;
    }

    .single-about--section-inner-description-container-title {
        font-weight: 400;
        font-size: 36px;
        line-height: 100%;
        color: #0D1B39;
    }

    .single-about--section-inner-description-container-description {
        font-weight: 400;
        font-size: 16px;
        line-height: 185%;
        color: #1E1E1E;
        text-align: justify;
    }

    /* vision mission */
    .single-about--section-inner-vision-mission-container {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
    }

    .single-about--section-inner-vision-mission-container-single-card {
        width: 100%;
        height: 100%;
        display: flex;        
        justify-content: space-between;
        align-items: center;
    }

    .single-about--section-inner-vision-mission-container-single-card-row {
        flex-direction: row;
    }

    .single-about--section-inner-vision-mission-container-single-card-row-reverse {
        flex-direction: row-reverse;
    }

    .single-about--section-inner-vision-mission-container-single-card-image-container {
        width: 50%;
        height: 100%;
    }

    .single-about--section-inner-vision-mission-container-single-card-image-container img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        object-position: center;
    }

    .single-about--section-inner-vision-mission-container-single-card-text-container {
        width: 50%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: flex-start;
        text-align: left;
        gap: 20px;
        padding: 0% 5%;
    }

    .single-about--section-inner-vision-mission-container-single-card-text-container-title {
        font-weight: 400;
        font-size: 32px;
        line-height: 100%;
        color: #0D1B39;
    }

    .single-about--section-inner-vision-mission-container-single-card-text-container-description {
        font-weight: 400;
        font-size: 16px;
        line-height: 185%;
        color: #1E1E1E;
    }

    @media (max-width: 1600px) {
        .single-about--section {
            padding: 4% 18%;
        }
    }

    @media (max-width: 1400px) {
        .single-about--section {
            padding: 4% 15%;
        }
    }

    @media (max-width: 1200px) {
        .single-about--section {
            padding: 4% 10%;
        }

        .single-about--section-inner-vision-mission-container-single-card-text-container {
            padding: 0% 3%;
            gap: 10px;
        }
    }

    @media (max-width: 992px) {
        .single-about--section-inner-description-container {
            align-items: center;
            text-align: center;
        }

        .single-about--section-inner-vision-mission-container-single-card {
            justify-content: center;
            gap: 20px;
            margin: 30px 0px;
        }

        .single-about--section-inner-vision-mission-container-single-card-row,
        .single-about--section-inner-vision-mission-container-single-card-row-reverse {
            flex-direction: column;
        }

        .single-about--section-inner-vision-mission-container-single-card-image-container {
            height: 300px;
        }

        .single-about--section-inner-vision-mission-container-single-card-image-container,
        .single-about--section-inner-vision-mission-container-single-card-text-container {
            width: 100%;
        }
    }
</style>

<section class="single-about--section">
    <div class="single-about--section-inner">
        <!-- description container -->
        <div class="single-about--section-inner-description-container" data-aos="fade-up">
            <div class="single-about--section-inner-description-container-title">
                Rooted in Craft. Elevated by Purpose. Defined by Detail. 
            </div>

            <div class="single-about--section-inner-description-container-description">
                CeyPearl Exim began as a quiet idea. A belief that the most beautiful spaces are built through intention and that even the smallest object can tell a story. From the lush coastal textures of Sri Lanka to the elegant interiors of luxury hotels, we exist to bridge tradition with modern hospitality. Every item we create is designed not only to serve but to speak. It reflects the soul of a space, the feeling of a moment, and the experience of being cared for. <br>
                Our story is grounded in Sri Lankan heritage and shaped by a global vision. We source ethically, design mindfully, and partner with properties that seek more than standard supplies. They seek meaning in materials, authenticity in details, and distinction in every layer of their guest experience. 
            </div>
        </div>

        <!-- vision mission section -->
        <div class="single-about--section-inner-vision-mission-container">
            <?php 
            $content = [
                ["1","mission.jpg","Our Mission","To create thoughtful, beautifully made hospitality products that blend sustainable practice with elevated design. We aim to shape experiences that feel warm, refined, and unforgettable. "],
                ["2","vision.jpg","Our Vision","To become the leading name in hospitality sourcing by offering a collection that is cohesive, customizable, and rooted in care. We strive to make luxury more thoughtful and sustainability more elegant, one product at a time."],
            ];

            foreach($content as [$count, $image, $title, $description]) {
            ?>
            <div class="single-about--section-inner-vision-mission-container-single-card <?php echo ($count % 2 == 0) ? 'single-about--section-inner-vision-mission-container-single-card-row' : 'single-about--section-inner-vision-mission-container-single-card-row-reverse'; ?>" data-aos="zoom-in">
                <div class="single-about--section-inner-vision-mission-container-single-card-image-container">
                    <img src="<?php echo get_template_directory_uri(); ?>/images/<?php echo $image; ?>" alt="">
                </div>
                <div class="single-about--section-inner-vision-mission-container-single-card-text-container">
                    <div class="single-about--section-inner-vision-mission-container-single-card-text-container-title">
                        <?php echo $title; ?>
                    </div>

                    <div class="single-about--section-inner-vision-mission-container-single-card-text-container-description"><?php echo $description; ?></div>
                </div>
            </div>
            <?php } ?>
        </div>
    </div>
</section>

<!-- our goals section -->
<style>
    .single-about--goals--section {
        padding: 4% 20%;
        width: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        position: relative;
        background: #F6F9FF;
        border-bottom: 2px solid;
        border-image-source: linear-gradient(270deg, rgba(255, 255, 255, 0) 0%, #00D6C9 50.48%, rgba(255, 255, 255, 0) 100%);
        border-image-slice: 1;
        border-image-repeat: stretch;
    }
	
    .single-about--goals--section-inner {
        text-align: center;
        width: 100%;
        position: relative;
    }

    .single-about--goals--section-inner-content-container {
        width: 100%;
        position: relative;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: flex-start;
        text-align: left;
        gap: 15px;
    }

    .single-about--goals--section-inner-content-container-title {
        font-weight: 400;
        font-size: 36px;
        line-height: 100%;
        color: #0D1B39;
    }

    .single-about--goals--section-inner-content-container-list {
        font-weight: 400;
        font-size: 16px;
        line-height: 185%;
        color: #1E1E1E;
    }

    .single-about--goals--section-inner-content-container-list ul {
        list-style: disc;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: flex-start;
        text-align: left;
        gap: 15px;
    }

    @media (max-width: 1600px) {
        .single-about--goals--section {
            padding: 4% 18%;
        }
    }

    @media (max-width: 1400px) {
        .single-about--goals--section {
            padding: 4% 15%;
        }
    }

    @media (max-width: 1200px) {
        .single-about--goals--section {
            padding: 4% 10%;
        }
    }

    @media (max-width: 992px) {
        .single-about--goals--section-inner-content-container-title {
            width: 100%;
            text-align: center;
        }
    }
</style>

<section class="single-about--goals--section">
    <div class="single-about--goals--section-inner">
        <div class="single-about--goals--section-inner-content-container">
            <div class="single-about--goals--section-inner-content-container-title" data-aos="fade-up">Our Goals </div>

            <div class="single-about--goals--section-inner-content-container-list" data-aos="fade-up">
                <ul>
                    <li>To evolve our product range while staying true to our artisanal spirit and commitment to sustainability.</li>
                    <li>To support local craftsmanship and preserve Sri Lanka’s legacy of handmade excellence.</li>
                    <li>To offer hospitality partners across the world a sourcing experience built on trust, transparency, and consistency.</li>
                    <li>To be a partner, not just a supplier; someone who understands the rhythm of hospitality and the details that make it unforgettable.</li>
                </ul>
            </div>
        </div>
    </div>
</section>

<!-- strengths section -->
<style>
    .single-about--strengths--section {
        padding: 4% 20%;
        width: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        position: relative;
        background: #0D1B39;
        border-bottom: 2px solid;
        border-image-source: linear-gradient(270deg, rgba(255, 255, 255, 0) 0%, #00D6C9 50.48%, rgba(255, 255, 255, 0) 100%);
        border-image-slice: 1;
        border-image-repeat: stretch;
    }
	
    .single-about--strengths--section-inner {
        text-align: center;
        width: 100%;
        position: relative;
    }

    .single-about--strengths--section-inner-text-container {
        width: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: flex-start;
        text-align: left;
        position: relative;
    }

    .single-about--strengths--section-inner-text-container-title {
        font-weight: 400;
        font-size: 36px;
        line-height: 100%;
        color: #FFF;
    }

    .single-about--strengths--section-inner-content-container {
        width: 100%;
        display: flex;
        align-items: center;
        justify-content: space-between;
        flex-wrap: wrap;
        margin-top: 30px;
    }

    .single-about--strengths--section-inner-content-container-single-card {
        width: calc(50% - 10px);
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        justify-content: center;
        text-align: left;
        gap: 20px; 
        margin: 30px 0px;       
    }

    .single-about--strengths--section-inner-content-container-single-card-icon {
        width: 50px;
        height: 50px;
    }

    .single-about--strengths--section-inner-content-container-single-card-icon img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        object-position: center;
    }

    .single-about--strengths--section-inner-content-container-single-card-title {
        font-weight: 400;
        font-size: 24px;
        line-height: 100%;
        color: #fff;
    }

    .single-about--strengths--section-inner-content-container-single-card-description {
        font-weight: 400;
        font-size: 16px;
        line-height: 185%;
        color: #FFF;
    }

    @media (max-width: 1600px) {
        .single-about--strengths--section {
            padding: 4% 18%;
        }
    }

    @media (max-width: 1400px) {
        .single-about--strengths--section {
            padding: 4% 15%;
        }
    }

    @media (max-width: 1200px) {
        .single-about--strengths--section {
            padding: 4% 10%;
        }
    }

    @media (max-width: 992px) {
        .single-about--strengths--section-inner-text-container-title {
            width: 100%;
            text-align: center;
        }
    }

    @media (max-width: 768px) {
        .single-about--strengths--section-inner-content-container {
            flex-wrap: nowrap;
            flex-direction: column;
        }

        .single-about--strengths--section-inner-content-container-single-card {
            align-items: center;
            text-align: center;
            width: 100%;
        }
    }
</style>

<!-- responsive font styles -->
<style>
    @media (max-width: 1500px) {
        .single-about--section-inner-description-container-title,
        .single-about--goals--section-inner-content-container-title,
        .single-about--strengths--section-inner-text-container-title {
            font-size: 34px;
        }
        .single-about--section-inner-vision-mission-container-single-card-text-container-title {
            font-size: 30px;
        }
        .single-about--strengths--section-inner-content-container-single-card-title {
            font-size: 22px;
        }
        .single-about--section-inner-description-container-description,
        .single-about--section-inner-vision-mission-container-single-card-text-container-description,
        .single-about--goals--section-inner-content-container-list,
        .single-about--strengths--section-inner-content-container-single-card-description {
            font-size: 15.5px;
        }
    }

    /* ==============================
    1200px and below
    ============================== */
    @media (max-width: 1200px) {
        .single-about--section-inner-description-container-title,
        .single-about--goals--section-inner-content-container-title,
        .single-about--strengths--section-inner-text-container-title {
            font-size: 32px;
        }
        .single-about--section-inner-vision-mission-container-single-card-text-container-title {
            font-size: 28px;
        }
        .single-about--strengths--section-inner-content-container-single-card-title {
            font-size: 21px;
        }
        .single-about--section-inner-description-container-description,
        .single-about--section-inner-vision-mission-container-single-card-text-container-description,
        .single-about--goals--section-inner-content-container-list,
        .single-about--strengths--section-inner-content-container-single-card-description {
            font-size: 15px;
        }
    }

    /* ==============================
    992px and below
    ============================== */
    @media (max-width: 992px) {
        .single-about--section-inner-description-container-title,
        .single-about--goals--section-inner-content-container-title,
        .single-about--strengths--section-inner-text-container-title {
            font-size: 28px;
        }
        .single-about--section-inner-vision-mission-container-single-card-text-container-title {
            font-size: 24px;
        }
        .single-about--strengths--section-inner-content-container-single-card-title {
            font-size: 20px;
        }
        .single-about--section-inner-description-container-description,
        .single-about--section-inner-vision-mission-container-single-card-text-container-description,
        .single-about--goals--section-inner-content-container-list,
        .single-about--strengths--section-inner-content-container-single-card-description {
            font-size: 14px;
        }
    }

    /* ==============================
    768px and below
    ============================== */
    @media (max-width: 768px) {
        .single-about--section-inner-description-container-title,
        .single-about--goals--section-inner-content-container-title,
        .single-about--strengths--section-inner-text-container-title {
            font-size: 24px;
        }
        .single-about--section-inner-vision-mission-container-single-card-text-container-title {
            font-size: 22px;
        }
        .single-about--strengths--section-inner-content-container-single-card-title {
            font-size: 18px;
        }
        .single-about--section-inner-description-container-description,
        .single-about--section-inner-vision-mission-container-single-card-text-container-description,
        .single-about--goals--section-inner-content-container-list,
        .single-about--strengths--section-inner-content-container-single-card-description {
            font-size: 13.5px;
        }
    }

    /* ==============================
    575px and below
    ============================== */
    @media (max-width: 575px) {
        .single-about--section-inner-description-container-title,
        .single-about--goals--section-inner-content-container-title,
        .single-about--strengths--section-inner-text-container-title {
            font-size: 22px;
        }
        .single-about--section-inner-vision-mission-container-single-card-text-container-title {
            font-size: 20px;
        }
        .single-about--strengths--section-inner-content-container-single-card-title {
            font-size: 17px;
        }
        .single-about--section-inner-description-container-description,
        .single-about--section-inner-vision-mission-container-single-card-text-container-description,
        .single-about--goals--section-inner-content-container-list,
        .single-about--strengths--section-inner-content-container-single-card-description {
            font-size: 13px;
        }
    }

    /* ==============================
    480px and below
    ============================== */
    @media (max-width: 480px) {
        .single-about--section-inner-description-container-title,
        .single-about--goals--section-inner-content-container-title,
        .single-about--strengths--section-inner-text-container-title {
            font-size: 20px;
        }
        .single-about--section-inner-vision-mission-container-single-card-text-container-title {
            font-size: 18px;
        }
        .single-about--strengths--section-inner-content-container-single-card-title {
            font-size: 16px;
        }
        .single-about--section-inner-description-container-description,
        .single-about--section-inner-vision-mission-container-single-card-text-container-description,
        .single-about--goals--section-inner-content-container-list,
        .single-about--strengths--section-inner-content-container-single-card-description {
            font-size: 12.5px;
        }
    }
</style>

<!-- <section class="single-about--strengths--section">
    <div class="single-about--strengths--section-inner">
        <div class="single-about--strengths--section-inner-text-container" data-aos="fade-up">
            <div class="single-about--strengths--section-inner-text-container-title">
                What Makes Us Different.
            </div>
        </div>

        <div class="single-about--strengths--section-inner-content-container">
            <?php 
            $strengthsContent = [
                ["Craftsmanship.svg","Craftsmanship That Speaks Without Words","Many of our products are made by hand, shaped by artisans who carry decades of experience in their fingers. These items hold more than beauty. They carry story, skill, and soul. "],
                ["Custom.svg","A Custom Approach to Every Brand","Your space is unique, and so should the products within it. We work closely with each client to offer tailored solutions, adjusting materials, dimensions, colours, finishes, and branding until every piece feels like it was made just for you. "],
                ["Value.svg","Refined Value at Every Level","We believe luxury should feel honest. Our pricing reflects the care we put into every detail, the quality of our materials, and the transparency of our process. You receive value not only in what we create but in how we work. "],
                ["Service.svg","A Commitment to Seamless Service","From first inquiry to final delivery, our team is focused on ensuring a smooth, responsive, and thoughtful process. We honour your time, brand, and vision, always aiming to exceed expectations rather than meet them. "],
                ["Quality.svg","A Harmonised Collection with Depth and Soul","What sets us apart is not just the quality of each product but the way they all speak to each other. Our tableware, uniforms, amenities, packaging, and décor pieces are curated to complement each other, creating a unified guest experience across every touchpoint. "],
            ];

            foreach($strengthsContent as [$icon, $title, $description]) {
            ?>
            <div class="single-about--strengths--section-inner-content-container-single-card" data-aos="zoom-in">
                <div class="single-about--strengths--section-inner-content-container-single-card-icon">
                    <img src="<?php echo get_template_directory_uri(); ?>/icons/<?php echo $icon; ?>" alt="">
                </div>

                <div class="single-about--strengths--section-inner-content-container-single-card-title"><?php echo $title; ?></div>

                <div class="single-about--strengths--section-inner-content-container-single-card-description"><?php echo $description; ?></div>
            </div>
            <?php } ?>
        </div>
    </div>
</section> -->


<?php get_footer(); ?>