<?php
/**
 * Header template for our theme
*/
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>
    <?php
        /*
        * Print the <title> tag based on what is being viewed.
        */
        global $page, $paged;

        wp_title( '|', true, 'right' );

        // Add the blog name.
        bloginfo( 'name' );

        // Add the blog description for the home/front page.
        $site_description = get_bloginfo( 'description', 'display' );
        if ( $site_description && ( is_home() || is_front_page() ) ) {
            echo " | $site_description";
        }

            // Add a page number if necessary:
        if ( ( $paged >= 2 || $page >= 2 ) && ! is_404() ) {
            echo esc_html( ' | ' . sprintf( __( 'Page %s', 'twentyten' ), max( $paged, $page ) ) );
        }

    ?>
    </title>

    <?php
        /*
        * We add some JavaScript to pages with the comment form
        * to support sites with threaded comments (when in use).
        */
        if ( is_singular() && get_option( 'thread_comments' ) ) {
            wp_enqueue_script( 'comment-reply' );
        }

        /*
        * Always have wp_head() just before the closing </head>
        * tag of your theme, or you will break many plugins, which
        * generally use this hook to add elements to <head> such
        * as styles, scripts, and meta tags.
        */
        wp_head();
    ?>
</head>
<body>
    <!-- font families -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&family=Italiana&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

    <!-- bootstrap css -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">

    <!-- slick css -->
    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.min.css" />
    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css" />

    <!-- animate css -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />

    <!-- aos library -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">


    <!-- global styles -->
    <style>
        body {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: "Poppins", sans-serif;
        }

        a {
            text-decoration: none;
        }

        ul {
            list-style: none;
        }

        /* font sizes */
        .font-1 {
            font-size: 1rem;
        }

        .font-1-2 {
            font-size: 1.2rem;
        }

        .font-1-3 {
            font-size: 1.3rem;
        }

        .font-1-5 {
            font-size: 1.5rem;
        }

        .font-2 {
            font-size: 2rem;
        }

        .font-2-5 {
            font-size: 2.5rem;
        }

        .font-3 {
            font-size: 3rem;
        }

        .font-4 {
            font-size: 4rem;
        }

        .font-5 {
            font-size: 5rem;
            line-height: 5rem;
        }

        .font-6 {
            font-size: 6rem;
        }

        @media (max-width: 1500px) {
            .font-3 {
                font-size: 2.7rem;
            }

            .font-4 {
                font-size: 3.7rem;
            }

            .font-5 {
                font-size: 4.7rem;
                line-height: 4.7rem;
            }

            .font-6 {
                font-size: 5.7rem;
            }
        }

        @media (max-width: 1500px) {
            .font-3 {
                font-size: 2.5rem;
            }

            .font-4 {
                font-size: 3.5rem;
            }

            .font-5 {
                font-size: 4.5rem;
                line-height: 4.5rem;
            }

            .font-6 {
                font-size: 5.5rem;
            }
        }

        @media (max-width: 1200px) {
            .font-1 {
                font-size: 0.9rem;
            }

            .font-1-2 {
                font-size: 1.1rem;
            }

            .font-1-3 {
                font-size: 1.2rem;
            }

            .font-1-5 {
                font-size: 1.4rem;
            }

            .font-2 {
                font-size: 1.5rem;
            }

            .font-2-5 {
                font-size: 2rem;
            }

            .font-3 {
                font-size: 2.3rem;
            }

            .font-4 {
                font-size: 3.3rem;
            }

            .font-5 {
                font-size: 4.3rem;
                line-height: 4.3rem;
            }

            .font-6 {
                font-size: 5.3rem;
            }
        }

        @media (max-width: 992px) {
            .font-1 {
                font-size: 0.8rem;
            }

            .font-1-2 {
                font-size: 1rem;
            }

            .font-1-3 {
                font-size: 1.1rem;
            }

            .font-1-5 {
                font-size: 1.3rem;
            }

            .font-2 {
                font-size: 1.3rem;
            }

            .font-2-5 {
                font-size: 1.9rem;
            }

            .font-3 {
                font-size: 2.2rem;
            }

            .font-4 {
                font-size: 3.2rem;
            }

            .font-5 {
                font-size: 4rem;
                line-height: 4rem;
            }

            .font-6 {
                font-size: 5rem;
            }
        }

        @media (max-width: 880px) {}

        @media (max-width: 768px) {
            .font-1 {
                font-size: 0.7rem;
            }

            .font-1-2 {
                font-size: 1.1rem;
            }

            .font-1-3 {
                font-size: 1rem;
            }

            .font-1-5 {
                font-size: 1.2rem;
            }

            .font-3 {
                font-size: 1.8rem;
            }

            .font-2 {
                font-size: 1.2rem;
            }

            .font-2-5 {
                font-size: 1.7rem;
            }

            .font-4 {
                font-size: 2rem;
            }

            .font-5 {
                font-size: 3rem;
                line-height: 3rem;
            }

            .font-6 {
                font-size: 4rem;
            }
        }

        @media (max-width: 480px) {
            .font-1 {
                font-size: 0.8rem;
            }

            .font-1-2 {
                font-size: 1rem;
            }

            .font-1-3 {
                font-size: 1rem;
            }

            .font-1-5 {
                font-size: 1rem;
            }

            .font-2 {
                font-size: 1.3rem;
            }

            .font-2-5 {
                font-size: 1.7rem;
            }

            .font-3 {
                font-size: 1.5rem;
            }

            .font-4 {
                font-size: 1.8rem;
            }

            .font-5 {
                font-size: 2.5rem;
                line-height: 2.5rem;
            }

            .font-6 {
                font-size: 3.5rem;
            }
        }

        @media (max-width: 420px) {
            .font-1 {
                font-size: 0.8rem;
            }

            .font-1-2 {
                font-size: 0.9rem;
            }

            .font-1-3 {
                font-size: 1rem;
            }

            .font-1-5 {
                font-size: 1rem;
            }

            .font-2 {
                font-size: 1rem;
            }

            .font-2-5 {
                font-size: 1.3rem;
            }

            .font-3 {
                font-size: 1.4rem;
            }

            .font-4 {
                font-size: 1.8rem;
            }

            .font-5 {
                font-size: 2rem;
                line-height: 2rem;
            }

            .font-6 {
                font-size: 3rem;
            }
        }

        /* line heights */
        .line-height-3 {
            line-height: 3rem;
        }

        /* font weights */
        .font-weight-100 {
            font-weight: 100;
        }

        .font-weight-200 {
            font-weight: 200;
        }

        .font-weight-300 {
            font-weight: 300;
        }

        .font-weight-400 {
            font-weight: 400;
        }

        .font-weight-500 {
            font-weight: 500;
        }

        .font-weight-600 {
            font-weight: 600;
        }

        .font-weight-700 {
            font-weight: 700;
        }

        .font-weight-800 {
            font-weight: 800;
        }

        .font-weight-900 {
            font-weight: 900;
        }

        /* font colors */
        .white-font {
            color: #fff;
        }

        .black-font {
            color: #000;
        }

        /* background colors */
        .white-background {
            background-color: #fff;
        }

        .transparent-background {
            background: transparent;
        }

        /* margin */
        .margin-left-5 {
            margin-left: 5%;
        }

        .margin-top-1 {
            margin-top: 1%;
        }

        .margin-top-2 {
            margin-top: 2%;
        }

        .margin-top-3 {
            margin-top: 3%;
        }

        .margin-top-4 {
            margin-top: 4%;
        }

        .margin-top-5 {
            margin-top: 5%;
        }

        .margin-bottom-1 {
            margin-bottom: 1%;
        }

        .margin-bottom-2 {
            margin-bottom: 2%;
        }

        .margin-bottom-3 {
            margin-bottom: 3%;
        }

        .margin-bottom-4 {
            margin-bottom: 4%;
        }

        .margin-bottom-5 {
            margin-bottom: 5%;
        }

        .margin-3-t-b {
            margin: 10% 0;
        }

        /* padding */
        .padding-5 {
            padding: 5px;
        }

        .padding-block-5 {
            padding-block: 5px;
        }

        .padding-5-10 {
            padding: 5px 10px;
        }

        .padding-5-20 {
            padding: 5px 20px;
        }

        .padding-right-1 {
            padding-right: 1%;
        }

        .padding-right-2 {
            padding-right: 2%;
        }

        .padding-right-3 {
            padding-right: 3%;
        }

        .padding-right-4 {
            padding-right: 4%;
        }

        .padding-right-5 {
            padding-right: 5%;
        }

        /* align items */
        .flex-center {
            justify-content: center;
        }

        .align-center {
            text-align: center;
        }

        /* border */
        .b-r-5 {
            border-radius: 5px;
        }

        .b-r-2 {
            border-radius: 2px;
        }

        .white-border {
            border: 1px solid #fff;
        }

        .black-border {
            border: 1px solid #000;
        }

        .light-black-border {
            border: 1px solid #1E1E1E;
        }

        /* custom styles */
        .section-button-white-border {
            font-weight: 500;
            font-size: 16px;
            line-height: 130%;
            color: #fff;
            border-radius: 5px;
            border: 1px solid #fff;
            padding: 10px 20px;
        }

        .section-inner-text-container-title {
            font-weight: 400;
            font-size: 42px;
            line-height: 100%;
            color: #0D1B39;
        }

        .section-inner-text-container-tagline {
            font-weight: 400;
            font-size: 16px;
            line-height: 185%;
            color: #1E1E1E;
            width: 55%;
        }

        .section-button {
            position: relative;
            overflow: hidden;
            font-weight: 400;
            font-size: 16px;
            line-height: 185%;
            color: #1E1E1E;
            border-radius: 2px;
            padding: 10px 20px;
            background: #F6B76F;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            transition: color 0.4s ease-in-out;
            z-index: 1;
        }

        /* background sliding effect */
        .section-button::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0; /* always start from left */
            width: 0; /* collapsed */
            height: 100%;
            background: #00D6C9;
            transition: width 0.4s ease-in-out;
            z-index: -1;
        }

        /* hover effect */
        .section-button:hover {
            color: #fff;
        }

        .section-button:hover::before {
            width: 100%; /* expand from left */
        }

        /* svg icon transition */
        .section-button svg {
            fill: #1E1E1E;
            height: 25px;
            transition: 0.4s ease-in-out;
            z-index: 2;
        }

        .section-button:hover svg {
            fill: #fff;
        }

        /* section button yellow */
        .section-button-yellow {
            font-weight: 400;
            font-size: 16px;
            line-height: 185%;
            color: #F6B76F;
            border-radius: 5px;
            padding: 10px 20px;
            border: none;
            background: transparent;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            transition: 0.4s ease-in-out;
        }

        .section-button-yellow svg {
            fill: #F6B76F;
            height: 25px;

        }

        .section-button-yellow:hover {
            background: #F6B76F;
            color: #fff;
        }

        .section-button-yellow:hover svg {
            fill: #FFFF;
            transition: 0.4s ease-in-out;
        }

        @media (max-width: 1500px) {
            .section-inner-text-container-title {
                font-size: 38px;
            }

            .section-inner-text-container-tagline {
                font-size: 15px;
                width: 60%;
            }

            .section-button,
            .section-button-yellow,
            .section-button-white-border {
                font-size: 15px;
                padding: 9px 18px;
            }
        }

        @media (max-width: 1200px) {
            .section-inner-text-container-title {
                font-size: 34px;
            }

            .section-inner-text-container-tagline {
                font-size: 15px;
                width: 65%;
            }

            .section-button,
            .section-button-yellow,
            .section-button-white-border {
                font-size: 14px;
                padding: 8px 16px;
            }
        }

        @media (max-width: 992px) {
            .section-inner-text-container-title {
                font-size: 30px;
            }

            .section-inner-text-container-tagline {
                font-size: 14px;
                width: 75%;
            }

            .section-button,
            .section-button-yellow,
            .section-button-white-border {
                font-size: 14px;
                padding: 8px 14px;
            }
        }

        @media (max-width: 768px) {
            .section-inner-text-container-title {
                font-size: 26px;
            }

            .section-inner-text-container-tagline {
                font-size: 13.5px;
                width: 85%;
            }

            .section-button,
            .section-button-yellow,
            .section-button-white-border {
                font-size: 13px;
                padding: 7px 12px;
            }
        }

        @media (max-width: 575px) {
            .section-inner-text-container-title {
                font-size: 22px;
            }

            .section-inner-text-container-tagline {
                font-size: 13px;
                width: 95%;
            }

            .section-button,
            .section-button-yellow,
            .section-button-white-border {
                font-size: 12px;
                padding: 6px 10px;
            }
        }

        @media (max-width: 480px) {
            .section-inner-text-container-title {
                font-size: 20px;
            }

            .section-inner-text-container-tagline {
                font-size: 12.5px;
                width: 100%;
            }

            .section-button,
            .section-button-yellow,
            .section-button-white-border {
                font-size: 11px;
                padding: 6px 9px;
            }
        }
    </style>

    <!-- styles for nav -->
    <style>
        header {
            display: flex;
            justify-content: center;
            align-items: center;
            width: 100%;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 999;
        }

        .black-bg {
            background: #00000085;
            position: absolute;
            top: 0;
            height: 100%;
            width: 100%;
            overflow: hidden;
            z-index: -1;
        }

        /* toggle button */
        .toggle_btn {
            position: relative;
            width: 20px;
            height: 20px;
            display: none;
            z-index: 301;
        }

        .toggle_btn img {
            object-fit: cover;
            width: 100%;
            height: 100%;
        }

        /* mobile button */
        .mobile-logo {
            display: none;
        }

        .mobile-logo img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            object-position: center;
        }

        /* drop down menu */
        .dropdown_menu {
            position: fixed;
            width: 100%;
            text-align: left;
            padding: 0;
            margin: 0;
            top: -200%;
            transition: 0.3s ease-in;
            background-color: #1E1E1E;
            backdrop-filter: blur(15px);
            z-index: 300;
        }

        .dropdown_menu.open {
            top: 15%;
        }

        .dropdown_menu ul {
            width: 100%;
            display: flex;
            justify-content: center;
            flex-direction: column;
            padding: 0;
            margin: 0;
        }

        .dropdown_menu .nav-inner-single-title {
            font-weight: 500;
            line-height: 130%;
            color: #fff;
            padding: 10px 20px;
            border-bottom: 1px solid #fff;
        }

        .dropdown_menu ul li {
            padding: 10px 0 10px 20px;
            border-bottom: 1px solid #fff;
        }

        .has-dropdown {
            position: relative;
            display: flex;
            align-items: center;
        }

        .dropdown-toggle {
            cursor: pointer;
            margin-left: 8px;
            font-size: 14px;
        }

        .dropdown {
            display: none;
            position: absolute;
            top: 100%;
            left: 0;
            background: white;
            list-style: none;
            padding: 0;
            box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
            min-width: 150px;
        }

        .dropdown li {
            padding: 8px 12px;
        }

        .dropdown li a {
            text-decoration: none;
            color: black;
        }

        .mobile-header {
            display: none;
        }

        nav {
            display: flex;
            justify-content: space-between;
            align-items: center;
            width: 100%;
            height: 125px;
            gap: 20px;
            padding-block: 20px;
            padding-inline: 20%;
            /* transition: background-color 0.3s ease; */
        }

        .nav-scrolled {
            background-color: #0d1b39ff;
        }

        nav .logo {
            width: auto;
            height: 100%;
        }

        nav .logo a {}

        nav .logo img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            object-position: center;
        }

        .nav-inner {
            display: flex;
            justify-content: space-between;
            align-items: center;
            width: 90%;
            height: 100%;
            border-bottom: 2px solid;
            border-image-source: linear-gradient(270deg, rgba(255, 255, 255, 0) 0%, #00D6C9 50.48%, rgba(255, 255, 255, 0) 100%);
            border-image-slice: 1;
            border-image-repeat: stretch;
        }

        .nav-inner-single-title {
            font-weight: 500;
            line-height: 130%;
            color: #fff;
        }

        @media (max-width: 1600px) {
            nav {
                padding-inline: 18%;
            }
        }

        @media (max-width: 1400px) {
            nav {
                padding-inline: 15%;
            }
        }

        @media (max-width: 1350px) {
            .nav-bottom-container a {
                padding: 5px 5px;
            }
        }

        @media (max-width: 1200px) {
            .single-title {
                font-size: 55px;
                line-height: 100px;
            }

            nav {
                padding-inline: 10%;
            }
        }

        @media (max-width: 1105px) {
            .nav-bottom-container {
                padding: 3px;
            }
        }

        @media (max-width: 1050px) {
            .nav-bottom-container a {
                padding: 5px 3px;
            }
        }

        @media (max-width: 992px) {
            nav {
                display: none;
            }

            .toggle_btn {
                display: block;
            }

            .mobile-logo {
                display: block;
                width: 75px;
                height: 75px;
                position: relative;
            }

            .single-title {
                font-size: 45px;
                line-height: 90px;
            }

            .dropdown_menu {
                font-size: 1rem;
            }

            header .logo {
                display: none;
            }

            .mobile-header {
                width: 100%;
                position: fixed;
                z-index: 301;
                top: 0;
                left: 0;
                background: #0D1B39;
                display: flex;
                justify-content: space-between;
                align-items: center;
                padding: 2% 5%;
                flex-direction: row-reverse;
            }
        }

        @media (max-width: 768px) {
            .single-title {
                font-size: 35px;
                line-height: 80px;
            }

            .dropdown_menu {
                font-size: 0.9rem;
            }

            .dropdown_menu.open {
                top: 10%;
            }
        }

        @media (max-width: 768px) {
            .mobile-logo {
                width: 50px;
                height: 50px;
            }
        }

        @media (max-width: 580px) {
            .single-title {
                font-size: 30px;
                line-height: 70px;
            }

            .dropdown_menu {
                font-size: 0.85rem;
            }
        }

        @media (max-width: 480px) {
            .dropdown_menu {
                font-size: 0.8rem;
            }

            /* .toggle_btn {
                top: 0;
            } */
        }

        @media (max-width: 420px) {
            .dropdown_menu {
                font-size: 0.7rem;
            }
        }
    </style>

    <header>
        <nav>
            <div class="logo" data-aos="zoom-in">
                <a href="<?php echo home_url(); ?>">
                    <img src="<?php echo get_template_directory_uri(); ?>/icons/logo.svg" alt="">
                </a>
            </div>

            <div class="nav-inner">
                <?php 
                $linksContent = [
                    ["Home",""],
                    ["About Us","about-us"],
                    ["Why Ceypearls","why-choose-us"],
                    ["Products Range","product-range"],
                    // ["Clients",""],
                    ["Inquiries","contact-us"],
                    ["Clients","blogs"],
                ];

                foreach($linksContent as [$title, $link]) {
                ?>
                <a href="<?php echo home_url(); ?>/<?php echo $link; ?>/">
                    <div class="nav-inner-single-title font-1">
                        <?php echo $title; ?>
                    </div>
                </a>
                <?php } ?>
            </div>
        </nav>

        <div class="mobile-header">
            <!-- toggle button -->
            <div class="toggle_btn">
                <img src="<?php echo get_template_directory_uri(); ?>/icons/menu.svg" alt="">
            </div>

            <!-- mobile logo -->
            <div class="mobile-logo">
                <a href="<?php echo home_url(); ?>">
                    <img src="<?php echo get_template_directory_uri(); ?>/icons/logo.svg" alt="">
                </a>
            </div>
        </div>

        <!-- drop down menu -->
        <div class="dropdown_menu">
            <ul>
                <?php 
                    $navigation_links = [
                        ["Home",""],
                        ["About Us","about-us"],
                        ["Why Ceypearls","why-choose-us"],
                        ["Products Range","product-range"],
                        // ["Clients",""],
                        ["Inquiries","contact-us"],
                        ["Clients","blogs"],
                    ];

                    foreach($navigation_links as [$title, $link]) {
                ?>
                <a href="<?php echo home_url(); ?>/<?php echo $link; ?>/">
                    <div class="nav-inner-single-title font-1">
                        <?php echo $title; ?>
                    </div>
                </a>
                <?php } ?>
            </ul>
        </div>
    </header>