<?php 
$banner_image = get_field('banner_image');

if(empty($banner_image)) {
    $banner_image = get_template_directory_uri().'/images/home.jpg';
} else {
    $banner_image = $banner_image;
}

$tagline = get_field('banner_tagline');

if(empty($tagline)) {
    $tagline = '';
} else {
    $tagline = $tagline;
}
?>

<style>
    .header-banner {
        overflow: hidden;
        align-items: center;
        height: 65vh;
        display: flex;
        justify-content: center;
        flex-direction: column;
        position: relative;
        z-index: -99;
        text-align: center;

        background-image: url('<?php echo $banner_image; ?>'); 
        background-position: center; 
        background-repeat: no-repeat; 
        background-size: cover; 
        background-attachment: fixed;
    }

    .banner-heading {
        text-align: left;
        display: flex;
        justify-content: center;
        align-items: flex-start;
        flex-direction: column;
        gap: 20px;
        width: 100%;
        height: 100%;
        padding-inline: 20%;
    }

    .banner-heading-title {
        font-weight: 500;
        font-size: 40px;
        line-height: 130%;
        color: #fff;
    }

    .header-banner .logo {
        height: 195px;
        width: 195px;
    }

    .header-banner .logo img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        object-position: center;
    }

    .home-bottom-bg {
        position: absolute;
        top: 22%;
        width: 100%;
        z-index: 25;
    }

    .home-bottom-bg img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        object-position: center;
    }

    @media (max-width: 1600px) {
        .banner-heading {
            padding-inline: 18%;
        }
    }

    @media (max-width: 1400px) {
        .banner-heading {
            padding-inline: 15%;
        }
    }

    @media (max-width: 1379px) {
        .home-title {
            font-size: 55px;
        }
    }

    @media (max-width: 1200px) {
        .header-banner .logo {
            height: 165px;
            width: 165px;
        }

        .banner-heading {
            padding-inline: 10%;
        }
    }

    @media (max-width: 992px) {
        .header-banner .logo {
            height: 95px;
            width: 95px;
        }

        .banner-heading {
            padding-inline: 5%;
            align-items: center;
            text-align: center;
        }
    }

    @media (max-width: 768px) {
        .header-banner .logo {
            height: 65px;
            width: 65px;
        }
    }

    @media (max-width: 580px) {
        .header-banner {
            background-attachment: scroll;
        }

        .header-banner .logo {
            height: 45px;
            width: 45px;
        }
    }

    @media (max-width: 480px) {
        .header-banner .logo {
            height: 30px;
        }
    }

    @media (max-width: 420px) {
        .header-banner .logo {
            height: 25px;
            width: 25px;
        }
    }
</style>

<div class="header-banner">

    <div class="black-bg"></div>

    <div class="banner-heading" data-aos="zoom-in">
        <?php
        $title = get_the_title();
        $font_class = strlen($title) > 40 ? 'font-3' : 'font-6';
        ?>
        <div class="banner-heading-title <?php echo $font_class; ?> font-weight-400">
            <?php echo $title; ?>
        </div>
    </div>
</div>
