<?php
function theamezelanka_enqueue_styles() {
    wp_enqueue_style('main-style', get_stylesheet_uri()); // Loads style.css
}

add_action('wp_enqueue_scripts', 'theamezelanka_enqueue_styles');

// adding menu for apperance
function register_main_menu() {
    register_nav_menus(
        array(
            'main-menu' => __( 'Main Menu' ), // Main menu
        )
    );
}


// runs when wordpress initialize
// init - action
add_action( 'init', 'register_main_menu' ); 

function custom_post_type01() {
 
    // Set UI labels for Custom Post Type
        $labels = array(
            'name'                => _x( 'Offer Products', 'Post Type General Name', 'twentytwenty' ),
            'singular_name'       => _x( 'Offer Product', 'Post Type Singular Name', 'twentytwenty' ),
            'menu_name'           => __( 'Offer Products', 'twentytwenty' ),
            'parent_item_colon'   => __( 'Parent  ', 'twentytwenty' ),
            'all_items'           => __( 'All Offer Products', 'twentytwenty' ),
            'view_item'           => __( 'View Offer Product', 'twentytwenty' ),
            'add_new_item'        => __( 'Add New Offer Product', 'twentytwenty' ),
            'add_new'             => __( 'Add New', 'twentytwenty' ),
            'edit_item'           => __( 'Edit Offer Product', 'twentytwenty' ),
            'update_item'         => __( 'Update Offer Product', 'twentytwenty' ),
            'search_items'        => __( 'Search Offer Product', 'twentytwenty' ),
            'not_found'           => __( 'Not Found', 'twentytwenty' ),
            'not_found_in_trash'  => __( 'Not found in Trash', 'twentytwenty' ),
        );
         
    // Set other options for Custom Post Type
         
        $args = array(
            'label'               => __( 'Offer Product', 'twentytwenty' ),
            'description'         => __( 'Offer Products', 'twentytwenty' ),
            'labels'              => $labels,
            // Features this CPT supports in Post Editor
            'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
            // You can associate this CPT with a taxonomy or custom taxonomy. 
           'taxonomies'          => array('topics', 'category' ),
            /* A hierarchical CPT is like Pages and can have
            * Parent and child items. A non-hierarchical CPT
            * is like Posts.
            */ 
            'hierarchical'        => true,
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'show_in_nav_menus'   => true,
            'show_in_admin_bar'   => true,
            'menu_position'       => 5,
            'can_export'          => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'publicly_queryable'  => true,
            'capability_type'     => 'post',
            'show_in_rest' => true,
     
        );
         
        // Registering your Custom Post Type
        register_post_type( 'offer-product', $args );
     
}

    /* Hook into the 'init' action so that the function
    * Containing our post type registration is not 
    * unnecessarily executed. 
    */
    
add_action( 'init', 'custom_post_type01', 0 );

function custom_post_type02() {
 
    // Set UI labels for Custom Post Type
        $labels = array(
            'name'                => _x( 'Featured Products', 'Post Type General Name', 'twentytwenty' ),
            'singular_name'       => _x( 'Featured Product', 'Post Type Singular Name', 'twentytwenty' ),
            'menu_name'           => __( 'Featured Products', 'twentytwenty' ),
            'parent_item_colon'   => __( 'Parent  ', 'twentytwenty' ),
            'all_items'           => __( 'All Featured Products', 'twentytwenty' ),
            'view_item'           => __( 'View Featured Product', 'twentytwenty' ),
            'add_new_item'        => __( 'Add New Featured Product', 'twentytwenty' ),
            'add_new'             => __( 'Add New', 'twentytwenty' ),
            'edit_item'           => __( 'Edit Featured Product', 'twentytwenty' ),
            'update_item'         => __( 'Update Featured Product', 'twentytwenty' ),
            'search_items'        => __( 'Search Featured Product', 'twentytwenty' ),
            'not_found'           => __( 'Not Found', 'twentytwenty' ),
            'not_found_in_trash'  => __( 'Not found in Trash', 'twentytwenty' ),
        );
         
    // Set other options for Custom Post Type
         
        $args = array(
            'label'               => __( 'Featured Product', 'twentytwenty' ),
            'description'         => __( 'Featured Products', 'twentytwenty' ),
            'labels'              => $labels,
            // Features this CPT supports in Post Editor
            'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
            // You can associate this CPT with a taxonomy or custom taxonomy. 
           'taxonomies'          => array('topics', 'category' ),
            /* A hierarchical CPT is like Pages and can have
            * Parent and child items. A non-hierarchical CPT
            * is like Posts.
            */ 
            'hierarchical'        => true,
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'show_in_nav_menus'   => true,
            'show_in_admin_bar'   => true,
            'menu_position'       => 5,
            'can_export'          => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'publicly_queryable'  => true,
            'capability_type'     => 'post',
            'show_in_rest' => true,
     
        );
         
        // Registering your Custom Post Type
        register_post_type( 'featured-product', $args );
     
}

    /* Hook into the 'init' action so that the function
    * Containing our post type registration is not 
    * unnecessarily executed. 
    */
    
add_action( 'init', 'custom_post_type02', 0 );

function custom_post_type03() {
 
    // Set UI labels for Custom Post Type
        $labels = array(
            'name'                => _x( 'Strengths', 'Post Type General Name', 'twentytwenty' ),
            'singular_name'       => _x( 'Strength', 'Post Type Singular Name', 'twentytwenty' ),
            'menu_name'           => __( 'Strengths', 'twentytwenty' ),
            'parent_item_colon'   => __( 'Parent  ', 'twentytwenty' ),
            'all_items'           => __( 'All Strengths', 'twentytwenty' ),
            'view_item'           => __( 'View Strength', 'twentytwenty' ),
            'add_new_item'        => __( 'Add New Strength', 'twentytwenty' ),
            'add_new'             => __( 'Add New', 'twentytwenty' ),
            'edit_item'           => __( 'Edit Strength', 'twentytwenty' ),
            'update_item'         => __( 'Update Strength', 'twentytwenty' ),
            'search_items'        => __( 'Search Strength', 'twentytwenty' ),
            'not_found'           => __( 'Not Found', 'twentytwenty' ),
            'not_found_in_trash'  => __( 'Not found in Trash', 'twentytwenty' ),
        );
         
    // Set other options for Custom Post Type
         
        $args = array(
            'label'               => __( 'Strength', 'twentytwenty' ),
            'description'         => __( 'Strengths', 'twentytwenty' ),
            'labels'              => $labels,
            // Features this CPT supports in Post Editor
            'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
            // You can associate this CPT with a taxonomy or custom taxonomy. 
           'taxonomies'          => array('topics', 'category' ),
            /* A hierarchical CPT is like Pages and can have
            * Parent and child items. A non-hierarchical CPT
            * is like Posts.
            */ 
            'hierarchical'        => true,
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'show_in_nav_menus'   => true,
            'show_in_admin_bar'   => true,
            'menu_position'       => 5,
            'can_export'          => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'publicly_queryable'  => true,
            'capability_type'     => 'post',
            'show_in_rest' => true,
     
        );
         
        // Registering your Custom Post Type
        register_post_type( 'strength', $args );
     
}

    /* Hook into the 'init' action so that the function
    * Containing our post type registration is not 
    * unnecessarily executed. 
    */
    
add_action( 'init', 'custom_post_type04', 0 );

function custom_post_type04() {
 
    // Set UI labels for Custom Post Type
        $labels = array(
            'name'                => _x( 'Blogs', 'Post Type General Name', 'twentytwenty' ),
            'singular_name'       => _x( 'Blog', 'Post Type Singular Name', 'twentytwenty' ),
            'menu_name'           => __( 'Blogs', 'twentytwenty' ),
            'parent_item_colon'   => __( 'Parent  ', 'twentytwenty' ),
            'all_items'           => __( 'All Blogs', 'twentytwenty' ),
            'view_item'           => __( 'View Blog', 'twentytwenty' ),
            'add_new_item'        => __( 'Add New Blog', 'twentytwenty' ),
            'add_new'             => __( 'Add New', 'twentytwenty' ),
            'edit_item'           => __( 'Edit Blog', 'twentytwenty' ),
            'update_item'         => __( 'Update Blog', 'twentytwenty' ),
            'search_items'        => __( 'Search Blog', 'twentytwenty' ),
            'not_found'           => __( 'Not Found', 'twentytwenty' ),
            'not_found_in_trash'  => __( 'Not found in Trash', 'twentytwenty' ),
        );
         
    // Set other options for Custom Post Type
         
        $args = array(
            'label'               => __( 'Blog', 'twentytwenty' ),
            'description'         => __( 'Blogs', 'twentytwenty' ),
            'labels'              => $labels,
            // Features this CPT supports in Post Editor
            'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
            // You can associate this CPT with a taxonomy or custom taxonomy. 
           'taxonomies'          => array('topics', 'category' ),
            /* A hierarchical CPT is like Pages and can have
            * Parent and child items. A non-hierarchical CPT
            * is like Posts.
            */ 
            'hierarchical'        => true,
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'show_in_nav_menus'   => true,
            'show_in_admin_bar'   => true,
            'menu_position'       => 5,
            'can_export'          => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'publicly_queryable'  => true,
            'capability_type'     => 'post',
            'show_in_rest' => true,
     
        );
         
        // Registering your Custom Post Type
        register_post_type( 'blog', $args );
     
}

    /* Hook into the 'init' action so that the function
    * Containing our post type registration is not 
    * unnecessarily executed. 
    */
    
add_action( 'init', 'custom_post_type04', 0 );

add_filter('show_admin_bar', '__return_false');

add_filter('wpcf7_autop_or_not', '__return_false');

// disabling p tag
remove_filter('the_content', 'wpautop');
remove_filter('the_excerpt', 'wpautop');

?>