<style>
    footer {
        padding: 4% 20%;
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        background: #fff;
    }

    .footer-inner {
        width: 100%;
        display: grid;
        grid-template-columns: 1fr 1fr 1fr;
        gap: 30px;
        align-items: flex-start;
    }

    /* logo container */
    .footer-inner-logo-container {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        justify-content: flex-start;
    }

    .footer-inner-logo-container-icon {}

    .footer-inner-logo-container-icon img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        object-position: center;
    }

    .footer-inner-logo-container-text {
        font-weight: 400;
        line-height: 160%;
        color: #1E1E1E;
    }

    /* navigations container */
    .footer-inner-navigations-container {
        display: flex;
        flex-direction: column;
        gap: 15px;
    }

    .footer-inner-navigations-container-title {
        font-weight: 400;
        font-size: 18px;
        line-height: 100%;
        color: #00D6C9;
    }

    .footer-inner-navigations-container-links {
        display: flex;
        flex-direction: column;
        gap: 15px;
    }

    .footer-inner-navigations-container-links-single-title {
        font-weight: 400;
        font-size: 15px;
        line-height: 160%;
        color: #1E1E1E;
    }

    .footer-inner-navigations-container-links-social-card {
        width: 100%;
        display: flex;
        align-items: center;
        justify-content: flex-start;
        gap: 20px;
    }

    .footer-inner-navigations-container-links-social-card-icon {
        width: 30px;
        height: 30px;
    }

    .footer-inner-navigations-container-links-social-card-icon img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        object-position: center;
    }

    .footer-inner-navigations-container-links-social-card-text {
        font-weight: 400;
        font-size: 15px;
        line-height: 160%;
        color: #1E1E1E;
    }

    @media (max-width: 1600px) {
        footer {
            padding-inline: 18%;
        }
    }

    @media (max-width: 1500px) {
        .footer-inner-navigations-container-title {
            font-size: 17px;
        }

        .footer-inner-navigations-container-links-single-title,
        .footer-inner-navigations-container-links-social-card-text {
            font-size: 14px;
        }
    }

    @media (max-width: 1400px) {
        footer {
            padding-inline: 15%;
        }
    }

    @media (max-width: 1200px) {
        footer {
            padding-inline: 10%;
        }
    }

    @media (max-width: 1200px) {
        .footer-inner-navigations-container-title {
            font-size: 16px;
        }

        .footer-inner-navigations-container-links-single-title,
        .footer-inner-navigations-container-links-social-card-text {
            font-size: 13.5px;
        }

        .footer-inner-navigations-container-links {
            gap: 5px;
        }

        .footer-inner-navigations-container-links-social-card-icon {
            width: 20px;
            height: 20px;
        }

        .footer-inner {
            gap: 15px;
        }
    }

    @media (max-width: 992px) {
        .footer-inner-navigations-container-title {
            font-size: 15px;
        }

        .footer-inner-navigations-container-links-single-title,
        .footer-inner-navigations-container-links-social-card-text {
            font-size: 13px;
        }

        .footer-inner {
            grid-template-columns: 1fr 1fr 2fr 1fr;
        }
    }

    @media (max-width: 992px) {
        .footer-inner {
            grid-template-columns: 1fr 1fr;
            gap: 40px;
        }
    }

    /* 768px and below */
    @media (max-width: 768px) {
        .footer-inner-navigations-container-title {
            font-size: 14px;
        }

        .footer-inner-navigations-container-links-single-title,
        .footer-inner-navigations-container-links-social-card-text {
            font-size: 12.5px;
        }
    }

    /* 575px and below */
    @media (max-width: 575px) {
        .footer-inner-navigations-container-title {
            font-size: 13px;
        }

        .footer-inner-navigations-container-links-single-title,
        .footer-inner-navigations-container-links-social-card-text {
            font-size: 12px;
        }
    }

    /* 480px and below */
    @media (max-width: 480px) {
        .footer-inner-navigations-container-title {
            font-size: 12px;
        }

        .footer-inner-navigations-container-links-single-title,
        .footer-inner-navigations-container-links-social-card-text {
            font-size: 11px;
        }

        .footer-inner {
            grid-template-columns: 1fr;
        }
    }
</style>

<footer>
    <section class="footer-inner">
        <div class="footer-inner-logo-container">
            <div class="footer-inner-logo-container-icon">
                <a href="<?php echo home_url(); ?>">
                    <img src="<?php echo get_template_directory_uri(); ?>/icons/logo-color.svg" alt="">
                </a>
            </div>

            <div class="footer-inner-logo-container-text font-1">
                The advantage of hiring a workspace with us is that.
            </div>
        </div>

        <div class="footer-inner-navigations-container">
            <div class="footer-inner-navigations-container-title">
                Navigations
            </div>

            <div class="footer-inner-navigations-container-links">
                <?php 
                $linksContent = [
                    ["Home",""],
                    ["About Us","about-us"],
                    ["Why Ceypearls","why-choose-us"],
                    ["Products Range","product-range"],
                    ["Inquiries","contact-us"],
                    ["Clients","blogs"],
                ];

                foreach($linksContent as [$title, $link]) {
                ?>
                <a href="<?php echo $link; ?>">
                    <div class="footer-inner-navigations-container-links-single-title font-1">
                        <?php echo $title; ?>
                    </div>
                </a>
                <?php } ?>
            </div>
        </div>

        <!-- <div class="footer-inner-navigations-container">
            <div class="footer-inner-navigations-container-title">
                Useful Links
            </div>

            <div class="footer-inner-navigations-container-links">
                <?php 
                $linksContent = [
                    ['Department of Immigration','https://www.immigration.gov.lk/'],
                    ['Sri Lanka Tourism','https://www.sltda.gov.lk/en'],
                    ['Electronic Travel Authorization','https://eta.gov.lk/slvisa/'],
                    ['Sri Lankan Embassies','https://www.srilanka.travel/foreign-embassies'],
                    ['Department of Wildlife','http://www.dwc.gov.lk/'],
                    ['Sri Lanka Transport Board','https://www.sltb.lk/'],
                    ['Sri Lanka Police','https://www.police.lk/'],
                    ['Department of Motor Traffic','https://dmt.gov.lk/index.php?lang=en'],
                    ['Airport & Aviation Services','https://www.airport.lk/']
                ];

                foreach($linksContent as [$title, $link]) {
                ?>
                <a href="<?php echo $link; ?>">
                    <div class="footer-inner-navigations-container-links-single-title font-1">
                        <?php echo $title; ?>
                    </div>
                </a>
                <?php } ?>
            </div>
        </div> -->

        <div class="footer-inner-navigations-container">
            <div class="footer-inner-navigations-container-title">
                Follow Us
            </div>

            <div class="footer-inner-navigations-container-links">
                <?php 
                $socialContent = [
                    ["","facebook.svg","Facebook"],
                    ["","twitter.svg","Twitter"],
                    ["","instagram.svg","Instagram"],
                ];

                foreach($socialContent as [$link, $icon, $text]) {
                ?>
                <a href="<?php echo $link; ?>" target="_blank">
                    <div class="footer-inner-navigations-container-links-social-card">
                        <div class="footer-inner-navigations-container-links-social-card-icon">
                            <img src="<?php echo get_template_directory_uri(); ?>/icons/<?php echo $icon; ?>" alt="">
                        </div>

                        <div class="footer-inner-navigations-container-links-social-card-text"><?php echo $text; ?></div>
                    </div>
                </a>
                <?php } ?>
            </div>
        </div>
    </section>
</footer>

<?php wp_footer(); ?>

</body>
</html>

<!-- js -->
<!-- bootstrap -->
<script type="text/javascript" src="https://code.jquery.com/jquery-1.11.0.min.js"></script>
<script type="text/javascript" src="https://code.jquery.com/jquery-migrate-1.2.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/slick.min.js"></script>

<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/jquery-1.11.3.min.js"></script>
<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js"></script>
<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/jquery.waypoints.min.js"></script>
<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/jquery.easing.1.3.js"></script>
<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/jquery.slicknav.min.js"></script>
<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/slick.min.js"></script>
<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/customs.js"></script>
<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/jquery.flexslider-min.js"></script>

<!-- aos -->
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

<script>
  AOS.init();
</script>

<script>
    $(document).ready(function() {
        $('.products--section-inner-content-container-slider-werapper').slick({
            slidesToShow: 3,
			slidesToScroll:1,
			arrows: true,
			infinite: true,
			autoplay: false,
			dots: true,
			speed: 1000,
			autoplaySpeed: 1000,

            responsive: [
				{
				breakpoint: 1201,
				settings: {
                    slidesToShow: 2,	
					}
				},
                {
				breakpoint: 769,
				settings: {
                    slidesToShow: 1,	
					}
				},
			]
        }); 

        $('.featured--products--section-inner-content-container-slider-wrapper').slick({
            slidesToShow: 1,
			slidesToScroll:1,
			arrows: true,
			infinite: true,
			autoplay: false,
			dots: true,
			speed: 1000,
			autoplaySpeed: 1000,

            responsive: [
				{
				breakpoint: 769,
				settings: {
                    dots: false,	
					}
				},
			]
        }); 

        $('.strengths--section-inner-content-container-slider-wrapper').slick({
            slidesToShow: 3,
			slidesToScroll:1,
			arrows: true,
			infinite: true,
			autoplay: false,
			dots: false,
			speed: 1000,
			autoplaySpeed: 1000,

            responsive: [
				{
				breakpoint: 1201,
				settings: {
                    slidesToShow: 2,	
					}
				},
                {
				breakpoint: 769,
				settings: {
                    slidesToShow: 1,	
					}
				},
			]
        }); 

        $('.testimonials--section-inner-content-container-slider-wrapper').slick({
            slidesToShow: 3,
			slidesToScroll:1,
			arrows: true,
			infinite: true,
			autoplay: false,
			dots: false,
			speed: 1000,
			autoplaySpeed: 1000,

            responsive: [
				{
				breakpoint: 1201,
				settings: {
                    slidesToShow: 2,	
					}
				},
                {
				breakpoint: 769,
				settings: {
                    slidesToShow: 1,	
					}
				},
			]
        }); 
    });

    document.addEventListener("DOMContentLoaded", function () {
        const toggleBtn = document.querySelector(".toggle_btn");
        const toggleBtnIcon = document.querySelector(".toggle_btn img");
        const dropDownMenu = document.querySelector(".dropdown_menu");

        toggleBtn.onclick = function () {
            dropDownMenu.classList.toggle("open");
            const isOpen = dropDownMenu.classList.contains("open");

            // Update image src based on menu state
        	toggleBtnIcon.src = isOpen
            ? '<?php echo get_template_directory_uri(); ?>/icons/close.svg'
            : '<?php echo get_template_directory_uri(); ?>/icons/menu.svg';
        };

    });
</script>

<!-- script for nav background color change on scrolling -->
<script>
    window.addEventListener('scroll', function () {
        const nav = document.querySelector('nav');
        if (window.scrollY > 0) {
            nav.classList.add('nav-scrolled');
        } else {
            nav.classList.remove('nav-scrolled');
        }
    });
</script>

<!-- script for play pause button -->
<script>
document.addEventListener("DOMContentLoaded", function () {
    const video = document.getElementById("headerVideo");
    const button = document.querySelector(".play-pause-button");
    const icon = document.getElementById("playPauseIcon");

    button.addEventListener("click", function () {
        if (video.paused) {
            video.play();
            icon.src = "<?php echo get_template_directory_uri(); ?>/icons/pause-button.png";
        } else {
            video.pause();
            icon.src = "<?php echo get_template_directory_uri(); ?>/icons/play-button.png";
        }
    });
});
</script>
